/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.jte;

import gg.jte.CodeResolver;
import gg.jte.ContentType;
import gg.jte.TemplateEngine;
import gg.jte.TemplateOutput;
import gg.jte.output.WriterOutput;
import gg.jte.resolve.DirectoryCodeResolver;
import gg.jte.resolve.ResourceCodeResolver;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.Writable;
import io.micronaut.http.HttpRequest;
import io.micronaut.views.ViewUtils;
import io.micronaut.views.ViewsConfiguration;
import io.micronaut.views.ViewsRenderer;
import io.micronaut.views.jte.JteViewsRendererConfiguration;
import io.micronaut.views.jte.JteWritable;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JteViewsRenderer<T>
implements ViewsRenderer<T> {
    @Deprecated
    public static final String DEFAULT_EXTENSION = ".jte";
    private static final Logger LOGGER = LoggerFactory.getLogger(JteViewsRenderer.class);
    private static final List<String> EXTENSIONS = Arrays.asList(".jte", ".kte");
    private final TemplateEngine templateEngine;

    protected JteViewsRenderer(ViewsConfiguration viewsConfiguration, JteViewsRendererConfiguration jteViewsRendererConfiguration, ContentType contentType, Path classDirectory) {
        if (jteViewsRendererConfiguration.isDynamic()) {
            CodeResolver codeResolver = this.newDynamicCodeResolver(jteViewsRendererConfiguration, viewsConfiguration.getFolder());
            this.templateEngine = TemplateEngine.create((CodeResolver)codeResolver, (Path)classDirectory, (ContentType)contentType);
        } else {
            LOGGER.info("Using precompiled views.");
            this.templateEngine = TemplateEngine.createPrecompiled((ContentType)contentType);
        }
        this.templateEngine.setBinaryStaticContent(jteViewsRendererConfiguration.isBinaryStaticContent());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CodeResolver newDynamicCodeResolver(JteViewsRendererConfiguration jteViewsRendererConfiguration, String folder) {
        block17: {
            if (jteViewsRendererConfiguration.getDynamicSourcePath() != null) {
                Path path2 = Paths.get(jteViewsRendererConfiguration.getDynamicSourcePath(), new String[0]);
                LOGGER.info("Using dynamic views loaded from {}", (Object)path2);
                return new DirectoryCodeResolver(path2);
            }
            try {
                Path src = Paths.get("src", new String[0]);
                if (!Files.exists(src, new LinkOption[0])) break block17;
                try (Stream<Path> search = Files.find(src, 2, (path, basicFileAttributes) -> path.endsWith("resources") && basicFileAttributes.isDirectory(), new FileVisitOption[0]);){
                    List jteSrc2 = search.map(p -> p.resolve(folder)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).collect(Collectors.toList());
                    if (jteSrc2.size() == 1) {
                        Path path3 = (Path)jteSrc2.get(0);
                        LOGGER.info("Using dynamic views loaded from {}", (Object)path3);
                        DirectoryCodeResolver directoryCodeResolver2 = new DirectoryCodeResolver(path3);
                        return directoryCodeResolver2;
                    }
                }
                search = Files.find(src, 2, (path, basicFileAttributes) -> path.endsWith("jte") && basicFileAttributes.isDirectory(), new FileVisitOption[0]);
                try {
                    List jteSrc = search.filter(x$0 -> Files.exists(x$0, new LinkOption[0])).collect(Collectors.toList());
                    if (jteSrc.size() == 1) {
                        Path path4 = (Path)jteSrc.get(0);
                        LOGGER.info("Using dynamic views loaded from {}", (Object)path4);
                        DirectoryCodeResolver directoryCodeResolver = new DirectoryCodeResolver(path4);
                        return directoryCodeResolver;
                    }
                }
                finally {
                    if (search != null) {
                        search.close();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        LOGGER.info("Dynamic view path not found, using views from classpath.");
        return new ResourceCodeResolver(folder);
    }

    @NonNull
    public Writable render(@NonNull String viewName, @Nullable T data, @Nullable HttpRequest<?> request) {
        return new JteWritable(this.templateEngine, this.viewName(viewName), ViewUtils.modelOf(data), this::decorateOutput);
    }

    @NonNull
    TemplateOutput decorateOutput(@NonNull TemplateOutput output) {
        return output;
    }

    @Deprecated
    @NonNull
    protected TemplateOutput getOutput(Writer out) {
        return new WriterOutput(out);
    }

    public boolean exists(@NonNull String viewName) {
        return EXTENSIONS.stream().anyMatch(x -> this.templateEngine.hasTemplate(this.viewName(viewName, (String)x)));
    }

    private String viewName(@NonNull String name, @NonNull String extension) {
        return ViewUtils.normalizeFile((String)name, (String)extension) + extension;
    }

    private String viewName(@NonNull String viewName) {
        return EXTENSIONS.stream().filter(x -> this.templateEngine.hasTemplate(this.viewName(viewName, (String)x))).map(x -> this.viewName(viewName, (String)x)).findFirst().orElse(null);
    }
}

