/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.jte;

import gg.jte.TemplateEngine;
import gg.jte.TemplateOutput;
import gg.jte.output.Utf8ByteOutput;
import gg.jte.output.WriterOutput;
import io.micronaut.core.io.Writable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Function;

public class JteWritable
implements Writable {
    private final TemplateEngine templateEngine;
    private final String viewName;
    private final Map<String, Object> data;
    private final Function<TemplateOutput, TemplateOutput> outputDecorator;

    public JteWritable(TemplateEngine templateEngine, String viewName, Map<String, Object> data, Function<TemplateOutput, TemplateOutput> outputDecorator) {
        this.templateEngine = templateEngine;
        this.viewName = viewName;
        this.data = data;
        this.outputDecorator = outputDecorator;
    }

    private void render(TemplateOutput output) {
        TemplateOutput decorated = this.outputDecorator.apply(output);
        this.templateEngine.render(this.viewName, this.data, decorated);
    }

    public void writeTo(Writer out) throws IOException {
        WriterOutput output = new WriterOutput(out);
        this.render((TemplateOutput)output);
    }

    public void writeTo(OutputStream outputStream, Charset charset) throws IOException {
        if (charset == null || StandardCharsets.UTF_8.equals(charset)) {
            Utf8ByteOutput output = new Utf8ByteOutput();
            this.render((TemplateOutput)output);
            output.writeTo(outputStream);
        } else {
            super.writeTo(outputStream, charset);
        }
    }
}

