/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.jte;

import gg.jte.Content;
import gg.jte.ContentType;
import gg.jte.TemplateOutput;
import gg.jte.html.HtmlTemplateOutput;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.annotation.Produces;
import io.micronaut.views.ViewsConfiguration;
import io.micronaut.views.jte.JteViewsRenderer;
import io.micronaut.views.jte.JteViewsRendererConfiguration;
import jakarta.inject.Singleton;
import java.io.Writer;
import java.nio.file.Paths;

@Produces(value={"text/plain"})
@Singleton
public class PlainJteViewsRenderer<T>
extends JteViewsRenderer<T> {
    protected PlainJteViewsRenderer(ViewsConfiguration viewsConfiguration, JteViewsRendererConfiguration jteViewsRendererConfiguration) {
        super(viewsConfiguration, jteViewsRendererConfiguration, ContentType.Plain, Paths.get(jteViewsRendererConfiguration.getDynamicPath(), new String[0]).resolve("plain"));
    }

    @Override
    @NonNull
    TemplateOutput decorateOutput(@NonNull TemplateOutput output) {
        return new PlainHtmlTemplateOutput(output);
    }

    private static class PlainHtmlTemplateOutput
    implements HtmlTemplateOutput {
        private final TemplateOutput delegate;

        public PlainHtmlTemplateOutput(TemplateOutput delegate) {
            this.delegate = delegate;
        }

        public Writer getWriter() {
            return this.delegate.getWriter();
        }

        public void writeContent(String value) {
            this.delegate.writeContent(value);
        }

        public void setContext(String tagName, String attributeName) {
        }

        public void writeBinaryContent(byte[] value) {
            this.delegate.writeBinaryContent(value);
        }

        public void writeUserContent(String value) {
            this.delegate.writeUserContent(value);
        }

        public void writeUserContent(Enum<?> value) {
            this.delegate.writeUserContent(value);
        }

        public void writeUserContent(Content content) {
            this.delegate.writeUserContent(content);
        }

        public void writeUserContent(boolean value) {
            this.delegate.writeUserContent(value);
        }

        public void writeUserContent(byte value) {
            this.delegate.writeUserContent(value);
        }

        public void writeUserContent(short value) {
            this.delegate.writeUserContent(value);
        }

        public void writeUserContent(int value) {
            this.delegate.writeUserContent(value);
        }

        public void writeUserContent(long value) {
            this.delegate.writeUserContent(value);
        }

        public void writeUserContent(float value) {
            this.delegate.writeUserContent(value);
        }

        public void writeUserContent(double value) {
            this.delegate.writeUserContent(value);
        }

        public void writeUserContent(char value) {
            this.delegate.writeUserContent(value);
        }

        public void writeUserContent(Boolean value) {
            this.delegate.writeUserContent(value);
        }

        public void writeUserContent(Number value) {
            this.delegate.writeUserContent(value);
        }

        public void writeUserContent(Character value) {
            this.delegate.writeUserContent(value);
        }
    }
}

