/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.thymeleaf;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.Writable;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.Produces;
import io.micronaut.views.ViewUtils;
import io.micronaut.views.ViewsConfiguration;
import io.micronaut.views.ViewsRenderer;
import io.micronaut.views.exceptions.ViewRenderingException;
import io.micronaut.views.thymeleaf.ThymeleafViewsRendererConfiguration;
import io.micronaut.views.thymeleaf.WebContext;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.exceptions.TemplateEngineException;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Produces(value={"text/html"})
@Singleton
public class ThymeleafViewsRenderer
implements ViewsRenderer {
    protected final AbstractConfigurableTemplateResolver templateResolver;
    protected final TemplateEngine engine;
    protected ResourceLoader resourceLoader;

    @Inject
    public ThymeleafViewsRenderer(AbstractConfigurableTemplateResolver templateResolver, TemplateEngine templateEngine, ClassPathResourceLoader resourceLoader) {
        this.templateResolver = templateResolver;
        this.resourceLoader = resourceLoader;
        this.engine = templateEngine;
    }

    @NonNull
    public Writable render(@NonNull String viewName, @Nullable Object data) {
        ArgumentUtils.requireNonNull((String)"viewName", (Object)viewName);
        return writer -> {
            Context context = new Context(Locale.US, ThymeleafViewsRenderer.variables(data));
            this.render(viewName, (IContext)context, writer);
        };
    }

    @NonNull
    public Writable render(@NonNull String viewName, @Nullable Object data, @NonNull HttpRequest<?> request) {
        ArgumentUtils.requireNonNull((String)"viewName", (Object)viewName);
        ArgumentUtils.requireNonNull((String)"request", request);
        return writer -> {
            WebContext context = new WebContext(request, Locale.US, ThymeleafViewsRenderer.variables(data));
            this.render(viewName, (IContext)context, writer);
        };
    }

    public void render(String viewName, IContext context, Writer writer) {
        try {
            this.engine.process(viewName, context, writer);
        }
        catch (TemplateEngineException e) {
            throw new ViewRenderingException("Error rendering Thymeleaf view [" + viewName + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean exists(@NonNull String viewName) {
        String location = this.viewLocation(viewName);
        return this.resourceLoader.getResourceAsStream(location).isPresent();
    }

    private TemplateEngine initializeTemplateEngine() {
        TemplateEngine engine = new TemplateEngine();
        engine.setTemplateResolver((ITemplateResolver)this.templateResolver);
        return engine;
    }

    private ClassLoaderTemplateResolver initializeTemplateResolver(ViewsConfiguration viewsConfiguration, ThymeleafViewsRendererConfiguration thConfiguration) {
        ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
        templateResolver.setPrefix(ViewUtils.normalizeFolder((String)viewsConfiguration.getFolder()));
        templateResolver.setCharacterEncoding(thConfiguration.getCharacterEncoding());
        templateResolver.setTemplateMode(thConfiguration.getTemplateMode());
        templateResolver.setSuffix(thConfiguration.getSuffix());
        templateResolver.setForceSuffix(thConfiguration.getForceSuffix());
        templateResolver.setForceTemplateMode(thConfiguration.getForceTemplateMode());
        templateResolver.setCacheTTLMs(thConfiguration.getCacheTTLMs());
        templateResolver.setCheckExistence(thConfiguration.getCheckExistence());
        templateResolver.setCacheable(thConfiguration.getCacheable());
        return templateResolver;
    }

    private static Map<String, Object> variables(@Nullable Object data) {
        if (data == null) {
            return new HashMap<String, Object>();
        }
        if (data instanceof Map) {
            return (Map)data;
        }
        return BeanMap.of((Object)data);
    }

    private String viewLocation(String name) {
        return this.templateResolver.getPrefix() + ViewUtils.normalizeFile((String)name, (String)this.templateResolver.getSuffix()) + this.templateResolver.getSuffix();
    }
}

