/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.thymeleaf;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.Writable;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.server.util.locale.HttpLocaleResolver;
import io.micronaut.views.ViewUtils;
import io.micronaut.views.ViewsConfiguration;
import io.micronaut.views.ViewsRenderer;
import io.micronaut.views.exceptions.ViewRenderingException;
import io.micronaut.views.thymeleaf.ThymeleafViewsRendererConfiguration;
import io.micronaut.views.thymeleaf.WebContext;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Writer;
import java.util.Locale;
import java.util.Optional;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.exceptions.TemplateEngineException;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Singleton
public class ThymeleafViewsRenderer<T>
implements ViewsRenderer<T> {
    protected final AbstractConfigurableTemplateResolver templateResolver;
    protected final TemplateEngine engine;
    protected final HttpLocaleResolver httpLocaleResolver;
    protected ResourceLoader resourceLoader;

    @Inject
    public ThymeleafViewsRenderer(AbstractConfigurableTemplateResolver templateResolver, TemplateEngine templateEngine, ClassPathResourceLoader resourceLoader, HttpLocaleResolver httpLocaleResolver) {
        this.templateResolver = templateResolver;
        this.resourceLoader = resourceLoader;
        this.engine = templateEngine;
        this.httpLocaleResolver = httpLocaleResolver;
    }

    @Deprecated
    public ThymeleafViewsRenderer(AbstractConfigurableTemplateResolver templateResolver, TemplateEngine templateEngine, ClassPathResourceLoader resourceLoader) {
        this(templateResolver, templateEngine, resourceLoader, new HttpLocaleResolver(){

            @NonNull
            public Optional<Locale> resolve(@NonNull HttpRequest<?> context) {
                return context.getLocale();
            }

            @NonNull
            public Locale resolveOrDefault(@NonNull HttpRequest<?> context) {
                return Locale.US;
            }
        });
    }

    @NonNull
    public Writable render(@NonNull String viewName, @Nullable T data, @NonNull HttpRequest<?> request) {
        ArgumentUtils.requireNonNull((String)"viewName", (Object)viewName);
        ArgumentUtils.requireNonNull((String)"request", request);
        return writer -> {
            WebContext context = new WebContext(request, this.httpLocaleResolver.resolveOrDefault((Object)request), ViewUtils.modelOf((Object)data));
            this.render(viewName, (IContext)context, writer);
        };
    }

    public void render(String viewName, IContext context, Writer writer) {
        try {
            this.engine.process(viewName, context, writer);
        }
        catch (TemplateEngineException e) {
            throw new ViewRenderingException("Error rendering Thymeleaf view [" + viewName + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean exists(@NonNull String viewName) {
        String location = this.viewLocation(viewName);
        return this.resourceLoader.getResourceAsStream(location).isPresent();
    }

    private TemplateEngine initializeTemplateEngine() {
        TemplateEngine engine = new TemplateEngine();
        engine.setTemplateResolver((ITemplateResolver)this.templateResolver);
        return engine;
    }

    private ClassLoaderTemplateResolver initializeTemplateResolver(ViewsConfiguration viewsConfiguration, ThymeleafViewsRendererConfiguration thConfiguration) {
        ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
        templateResolver.setPrefix(ViewUtils.normalizeFolder((String)viewsConfiguration.getFolder()));
        templateResolver.setCharacterEncoding(thConfiguration.getCharacterEncoding());
        templateResolver.setTemplateMode(thConfiguration.getTemplateMode());
        templateResolver.setSuffix(thConfiguration.getSuffix());
        templateResolver.setForceSuffix(thConfiguration.getForceSuffix());
        templateResolver.setForceTemplateMode(thConfiguration.getForceTemplateMode());
        templateResolver.setCacheTTLMs(thConfiguration.getCacheTTLMs());
        templateResolver.setCheckExistence(thConfiguration.getCheckExistence());
        templateResolver.setCacheable(thConfiguration.getCacheable());
        return templateResolver;
    }

    private String viewLocation(String name) {
        return this.templateResolver.getPrefix() + ViewUtils.normalizeFile((String)name, (String)this.templateResolver.getSuffix()) + this.templateResolver.getSuffix();
    }
}

