/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.thymeleaf;

import io.micronaut.context.annotation.Factory;
import io.micronaut.views.ViewsConfiguration;
import io.micronaut.views.thymeleaf.MessageSourceMessageResolver;
import io.micronaut.views.thymeleaf.ThymeleafViewsRendererConfiguration;
import jakarta.inject.Singleton;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IEngineContextFactory;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.extras.java8time.dialect.Java8TimeDialect;
import org.thymeleaf.linkbuilder.ILinkBuilder;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Factory
public class ThymeleafFactory {
    @Singleton
    public AbstractConfigurableTemplateResolver templateResolver(ViewsConfiguration viewsConfiguration, ThymeleafViewsRendererConfiguration rendererConfiguration) {
        ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
        templateResolver.setPrefix(viewsConfiguration.getFolder());
        templateResolver.setCharacterEncoding(rendererConfiguration.getCharacterEncoding());
        templateResolver.setTemplateMode(rendererConfiguration.getTemplateMode());
        templateResolver.setSuffix(rendererConfiguration.getSuffix());
        templateResolver.setForceSuffix(rendererConfiguration.getForceSuffix());
        templateResolver.setForceTemplateMode(rendererConfiguration.getForceTemplateMode());
        templateResolver.setCacheTTLMs(rendererConfiguration.getCacheTTLMs());
        templateResolver.setCheckExistence(rendererConfiguration.getCheckExistence());
        templateResolver.setCacheable(rendererConfiguration.getCacheable());
        return templateResolver;
    }

    @Singleton
    public TemplateEngine templateEngine(ITemplateResolver templateResolver, IEngineContextFactory engineContextFactory, ILinkBuilder linkBuilder, MessageSourceMessageResolver messageSourceMessageResolver) {
        TemplateEngine engine = new TemplateEngine();
        engine.setEngineContextFactory(engineContextFactory);
        engine.setLinkBuilder(linkBuilder);
        engine.setTemplateResolver(templateResolver);
        engine.addDialect((IDialect)new Java8TimeDialect());
        engine.addMessageResolver((IMessageResolver)messageSourceMessageResolver);
        return engine;
    }
}

