/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.thymeleaf;

import io.micronaut.views.thymeleaf.WebContext;
import io.micronaut.views.thymeleaf.WebEngineContext;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.EngineContext;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.context.IEngineContextFactory;
import org.thymeleaf.engine.TemplateData;

@Singleton
public class EngineContextFactory
implements IEngineContextFactory {
    public IEngineContext createEngineContext(IEngineConfiguration configuration, TemplateData templateData, Map<String, Object> templateResolutionAttributes, IContext context) {
        Map<String, Object> variables;
        Objects.requireNonNull(context, "Context object cannot be null");
        Set variableNames = context.getVariableNames();
        if (variableNames == null || variableNames.isEmpty()) {
            variables = Collections.emptyMap();
        } else {
            variables = new LinkedHashMap(variableNames.size() + 1, 1.0f);
            for (String variableName : variableNames) {
                variables.put(variableName, context.getVariable(variableName));
            }
        }
        if (context instanceof WebContext) {
            WebContext webContext = (WebContext)context;
            return new WebEngineContext(configuration, templateData, templateResolutionAttributes, webContext.getRequest(), webContext.getLocale(), variables);
        }
        return new EngineContext(configuration, templateData, templateResolutionAttributes, context.getLocale(), variables);
    }
}

