/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.thymeleaf;

import io.micronaut.context.MessageSource;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.messageresolver.AbstractMessageResolver;
import org.thymeleaf.messageresolver.StandardMessageResolver;
import org.thymeleaf.util.Validate;

@Singleton
public class MessageSourceMessageResolver
extends AbstractMessageResolver {
    private final StandardMessageResolver standardMessageResolver = new StandardMessageResolver();
    private final MessageSource messageSource;

    public MessageSourceMessageResolver(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public final String resolveMessage(ITemplateContext context, Class<?> origin, String key, Object[] messageParameters) {
        Validate.notNull((Object)context.getLocale(), (String)"Locale in context cannot be null");
        Validate.notNull((Object)key, (String)"Message key cannot be null");
        MessageSource.MessageContext messageContext = MessageSource.MessageContext.of((Locale)context.getLocale(), this.translateMessagesToMap(messageParameters));
        return this.messageSource.getMessage(key, messageContext).map(template -> this.messageSource.interpolate(template, messageContext)).orElse(null);
    }

    public String createAbsentMessageRepresentation(ITemplateContext context, Class<?> origin, String key, Object[] messageParameters) {
        return this.standardMessageResolver.createAbsentMessageRepresentation(context, origin, key, messageParameters);
    }

    private Map<String, Object> translateMessagesToMap(Object[] messageParameters) {
        if (messageParameters.length > 0) {
            HashMap<String, Object> messageMap = new HashMap<String, Object>();
            for (int i = 0; i < messageParameters.length; ++i) {
                Object val = messageParameters[i];
                if (val == null) continue;
                String value = val.toString();
                messageMap.put(String.valueOf(i), value);
            }
            return messageMap;
        }
        return null;
    }
}

