/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.thymeleaf;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.Writable;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.server.util.locale.HttpLocaleResolver;
import io.micronaut.views.ViewUtils;
import io.micronaut.views.ViewsConfiguration;
import io.micronaut.views.ViewsRenderer;
import io.micronaut.views.exceptions.ViewRenderingException;
import io.micronaut.views.thymeleaf.ThymeleafViewsRendererConfiguration;
import io.micronaut.views.thymeleaf.WebContext;
import jakarta.inject.Singleton;
import java.io.Writer;
import java.util.Locale;
import java.util.Set;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.ExpressionContext;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.exceptions.TemplateEngineException;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.FragmentExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Singleton
@Requires(classes={HttpRequest.class, HttpLocaleResolver.class})
public class ThymeleafViewsRenderer<T>
implements ViewsRenderer<T, HttpRequest<?>> {
    protected final AbstractConfigurableTemplateResolver templateResolver;
    protected final TemplateEngine engine;
    protected final HttpLocaleResolver httpLocaleResolver;
    protected ResourceLoader resourceLoader;

    public ThymeleafViewsRenderer(AbstractConfigurableTemplateResolver templateResolver, TemplateEngine templateEngine, ClassPathResourceLoader resourceLoader, HttpLocaleResolver httpLocaleResolver) {
        this.templateResolver = templateResolver;
        this.resourceLoader = resourceLoader;
        this.engine = templateEngine;
        this.httpLocaleResolver = httpLocaleResolver;
    }

    @NonNull
    public Writable render(@NonNull String viewName, @Nullable T data, @Nullable HttpRequest<?> request) {
        ArgumentUtils.requireNonNull((String)"viewName", (Object)viewName);
        return writer -> {
            WebContext context = new WebContext(request, request != null ? this.httpLocaleResolver.resolveOrDefault((Object)request) : Locale.getDefault(), ViewUtils.modelOf((Object)data));
            TemplateAndFragment templateAndFragment = this.resolveTemplate(viewName);
            this.render(templateAndFragment.templateName, templateAndFragment.fragmentSelectors, (IContext)context, writer);
        };
    }

    public void render(String viewName, Set<String> fragmentSelectors, IContext context, Writer writer) {
        try {
            this.engine.process(viewName, fragmentSelectors, context, writer);
        }
        catch (TemplateEngineException e) {
            throw new ViewRenderingException("Error rendering Thymeleaf view [" + viewName + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated(forRemoval=true, since="5.2.0")
    public void render(String viewName, IContext context, Writer writer) {
        try {
            this.engine.process(viewName, context, writer);
        }
        catch (TemplateEngineException e) {
            throw new ViewRenderingException("Error rendering Thymeleaf view [" + viewName + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean exists(@NonNull String viewName) {
        TemplateAndFragment templateAndFragment = this.resolveTemplate(viewName);
        String location = this.viewLocation(templateAndFragment.templateName);
        return this.resourceLoader.getResourceAsStream(location).isPresent();
    }

    private TemplateEngine initializeTemplateEngine() {
        TemplateEngine engine = new TemplateEngine();
        engine.setTemplateResolver((ITemplateResolver)this.templateResolver);
        return engine;
    }

    private ClassLoaderTemplateResolver initializeTemplateResolver(ViewsConfiguration viewsConfiguration, ThymeleafViewsRendererConfiguration thConfiguration) {
        ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
        templateResolver.setPrefix(ViewUtils.normalizeFolder((String)viewsConfiguration.getFolder()));
        templateResolver.setCharacterEncoding(thConfiguration.getCharacterEncoding());
        templateResolver.setTemplateMode(thConfiguration.getTemplateMode());
        templateResolver.setSuffix(thConfiguration.getSuffix());
        templateResolver.setForceSuffix(thConfiguration.getForceSuffix());
        templateResolver.setForceTemplateMode(thConfiguration.getForceTemplateMode());
        templateResolver.setCacheTTLMs(thConfiguration.getCacheTTLMs());
        templateResolver.setCheckExistence(thConfiguration.getCheckExistence());
        templateResolver.setCacheable(thConfiguration.getCacheable());
        return templateResolver;
    }

    private String viewLocation(String name) {
        return this.templateResolver.getPrefix() + ViewUtils.normalizeFile((String)name, (String)this.templateResolver.getSuffix()) + this.templateResolver.getSuffix();
    }

    private TemplateAndFragment resolveTemplate(String viewName) {
        FragmentExpression fragmentExpression;
        if (!viewName.contains("::")) {
            return new TemplateAndFragment(viewName, null);
        }
        ExpressionContext expressionContext = new ExpressionContext(this.engine.getConfiguration());
        IStandardExpressionParser parser = StandardExpressions.getExpressionParser((IEngineConfiguration)this.engine.getConfiguration());
        try {
            fragmentExpression = (FragmentExpression)parser.parseExpression((IExpressionContext)expressionContext, "~{" + viewName + "}");
        }
        catch (TemplateProcessingException e) {
            throw new IllegalArgumentException("Invalid template name specification: '" + viewName + "'");
        }
        FragmentExpression.ExecutedFragmentExpression fragment = FragmentExpression.createExecutedFragmentExpression((IExpressionContext)expressionContext, (FragmentExpression)fragmentExpression);
        String templateName = FragmentExpression.resolveTemplateName((FragmentExpression.ExecutedFragmentExpression)fragment);
        Set fragmentSelectors = FragmentExpression.resolveFragments((FragmentExpression.ExecutedFragmentExpression)fragment);
        return new TemplateAndFragment(templateName, fragmentSelectors);
    }

    private record TemplateAndFragment(String templateName, Set<String> fragmentSelectors) {
    }
}

