/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.velocity;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.Writable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.views.ViewUtils;
import io.micronaut.views.ViewsConfiguration;
import io.micronaut.views.ViewsRenderer;
import io.micronaut.views.exceptions.ViewRenderingException;
import io.micronaut.views.velocity.VelocityViewsRendererConfiguration;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

@Singleton
public class VelocityViewsRenderer<T, R>
implements ViewsRenderer<T, R> {
    protected final VelocityEngine velocityEngine;
    protected final ViewsConfiguration viewsConfiguration;
    protected final VelocityViewsRendererConfiguration velocityConfiguration;
    protected final String folder;

    @Inject
    public VelocityViewsRenderer(ViewsConfiguration viewsConfiguration, VelocityViewsRendererConfiguration velocityConfiguration, VelocityEngine velocityEngine) {
        this.viewsConfiguration = viewsConfiguration;
        this.velocityConfiguration = velocityConfiguration;
        this.velocityEngine = velocityEngine;
        this.folder = viewsConfiguration.getFolder();
    }

    @NonNull
    public Writable render(@NonNull String view, @Nullable T data, @NonNull R request) {
        ArgumentUtils.requireNonNull((String)"view", (Object)view);
        return writer -> {
            Map context = ViewUtils.modelOf((Object)data);
            VelocityContext velocityContext = new VelocityContext(context);
            this.render(view, velocityContext, StandardCharsets.UTF_8.name(), writer);
        };
    }

    public void render(@NonNull String view, VelocityContext context, String encoding, Writer writer) {
        String viewName = this.viewName(view);
        try {
            this.velocityEngine.mergeTemplate(viewName, encoding, (Context)context, writer);
        }
        catch (MethodInvocationException | ParseErrorException | ResourceNotFoundException e) {
            throw new ViewRenderingException("Error rendering Velocity view [" + viewName + "]: " + e.getMessage(), e);
        }
    }

    public boolean exists(@NonNull String viewName) {
        try {
            this.velocityEngine.getTemplate(this.viewName(viewName));
        }
        catch (ParseErrorException | ResourceNotFoundException e) {
            throw new ViewRenderingException("Error rendering Velocity view [" + viewName + "]: " + e.getMessage(), e);
        }
        return true;
    }

    private VelocityEngine initializeVelocityEngine() {
        Properties p = new Properties();
        p.setProperty("resource.loaders", "class");
        p.setProperty("resource.loader.class.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        return new VelocityEngine(p);
    }

    private String viewName(String name) {
        return this.folder + ViewUtils.normalizeFile((String)name, (String)this.extension()) + "." + this.extension();
    }

    private String extension() {
        return this.velocityConfiguration.getDefaultExtension();
    }
}

