/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.xml.jackson.server;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.HttpContentProcessor;
import io.micronaut.http.server.netty.HttpContentSubscriberFactory;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.xml.jackson.server.XmlContentProcessor;
import jakarta.inject.Singleton;

@Consumes(value={"application/xml", "application/xhtml+xml", "text/xml"})
@Singleton
@Requires(classes={HttpContentSubscriberFactory.class})
public class XmlHttpContentSubscriberFactory
implements HttpContentSubscriberFactory {
    private final NettyHttpServerConfiguration configuration;

    public XmlHttpContentSubscriberFactory(NettyHttpServerConfiguration configuration) {
        this.configuration = configuration;
    }

    public HttpContentProcessor build(NettyHttpRequest request) {
        return new XmlContentProcessor(request, (HttpServerConfiguration)this.configuration);
    }
}

