/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.xml.jackson.server.convert;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.xml.jackson.server.convert.ByteArrayXmlStreamReader;
import io.micronaut.xml.jackson.server.convert.XmlStreamConvertibleValues;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Optional;
import javax.xml.stream.XMLStreamReader;

@Singleton
@Internal
public class XmlStreamToObjectConverter
implements TypeConverter<ByteArrayXmlStreamReader, Object> {
    private final XmlMapper xmlMapper;
    private final ConversionService<?> conversionService;

    public XmlStreamToObjectConverter(XmlMapper xmlMapper, ConversionService<?> conversionService) {
        this.xmlMapper = xmlMapper;
        this.conversionService = conversionService;
    }

    public Optional<Object> convert(ByteArrayXmlStreamReader stream, Class<Object> targetType, ConversionContext context) {
        try {
            if (ConvertibleValues.class.isAssignableFrom(targetType)) {
                return Optional.of(new XmlStreamConvertibleValues(stream, this.xmlMapper, this.conversionService));
            }
            return Optional.of(this.xmlMapper.readValue((XMLStreamReader)stream, targetType));
        }
        catch (IOException e) {
            context.reject((Exception)e);
            return Optional.empty();
        }
    }
}

