/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.xml.jackson.server;

import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.AbstractBufferingHttpContentProcessor;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.xml.jackson.server.convert.ByteArrayXmlStreamReader;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlContentProcessor
extends AbstractBufferingHttpContentProcessor<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(XmlContentProcessor.class);
    private static final int DEFAULT_REQUEST_SIZE = 1024;
    private final ByteArrayOutputStream byteArrayStream;

    public XmlContentProcessor(NettyHttpRequest<?> nettyHttpRequest, HttpServerConfiguration configuration) {
        super(nettyHttpRequest, configuration);
        int requestLength = this.advertisedLength != -1L ? (int)this.advertisedLength : 1024;
        this.byteArrayStream = new ByteArrayOutputStream(requestLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onUpstreamMessage(ByteBufHolder message) {
        ByteBuf content = message.content();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Buffer xml bytes of size {}", (Object)content.readableBytes());
        }
        try {
            content.readBytes((OutputStream)this.byteArrayStream, content.readableBytes());
            ++this.upstreamDemand;
            this.upstreamSubscription.request(1L);
        }
        catch (IOException e) {
            this.onError(e);
        }
        finally {
            content.release();
        }
    }

    protected void doOnComplete() {
        try {
            this.sendXmlStreamToSubscriber();
            super.doOnComplete();
        }
        catch (Exception e) {
            this.doOnError(e);
        }
    }

    private void sendXmlStreamToSubscriber() {
        this.currentDownstreamSubscriber().ifPresent(subscriber -> {
            block2: {
                try {
                    byte[] bytes = this.byteArrayStream.toByteArray();
                    ByteArrayXmlStreamReader byteArrayXmlStreamReader = new ByteArrayXmlStreamReader(bytes);
                    subscriber.onNext((Object)byteArrayXmlStreamReader);
                }
                catch (XMLStreamException e) {
                    if (!LOG.isErrorEnabled()) break block2;
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }
}

