/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.xml.jackson.server.convert;

import io.micronaut.core.annotation.Internal;
import java.io.ByteArrayInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;

@Internal
public final class ByteArrayXmlStreamReader
extends StreamReaderDelegate
implements AutoCloseable {
    private byte[] bytes;

    public ByteArrayXmlStreamReader(byte[] bytes) throws XMLStreamException {
        super(ByteArrayXmlStreamReader.toReader(bytes));
        this.bytes = bytes;
    }

    private static XMLStreamReader toReader(byte[] bytes) throws XMLStreamException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        return XMLInputFactory.newInstance().createXMLStreamReader(in);
    }

    byte[] getBytes() {
        return this.bytes;
    }

    public ByteArrayXmlStreamReader reset() {
        try {
            return new ByteArrayXmlStreamReader(this.bytes);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }
}

