/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.xml.jackson.server.convert;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.jackson.JacksonConfiguration;
import io.micronaut.xml.jackson.server.convert.ByteArrayXmlStreamReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlStreamConvertibleValues<V>
implements ConvertibleValues<V> {
    private static final Logger LOG = LoggerFactory.getLogger(XmlStreamConvertibleValues.class);
    private final ByteArrayXmlStreamReader stream;
    private final XmlMapper xmlMapper;
    private final ConversionService<?> conversionService;
    private final Supplier<JsonNode> objectNode;

    public XmlStreamConvertibleValues(ByteArrayXmlStreamReader stream, XmlMapper xmlMapper, ConversionService<?> conversionService) {
        this.stream = stream;
        this.xmlMapper = xmlMapper;
        this.conversionService = conversionService;
        this.objectNode = SupplierUtil.memoized(() -> {
            try {
                return xmlMapper.readTree(stream.getBytes());
            }
            catch (IOException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Failed to read the xml stream as a tree", (Throwable)e);
                }
                return null;
            }
        });
    }

    public Set<String> names() {
        JsonNode jsonNode = this.objectNode.get();
        if (jsonNode != null) {
            Iterator fieldNames = this.objectNode.get().fieldNames();
            return CollectionUtils.iteratorToSet((Iterator)fieldNames);
        }
        return Collections.emptySet();
    }

    public Collection<V> values() {
        JsonNode jsonNode = this.objectNode.get();
        if (jsonNode != null) {
            ArrayList<JsonNode> values = new ArrayList<JsonNode>();
            for (JsonNode node : jsonNode) {
                values.add(node);
            }
            return Collections.unmodifiableCollection(values);
        }
        return Collections.emptyList();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        type = conversionContext.getArgument().getType();
        if (!Collection.class.isAssignableFrom(type)) {
            node = this.objectNode.get();
            if (node == null) return Optional.empty();
            return this.conversionService.convert((Object)node.get(name.toString()), conversionContext);
        }
        depth = -1;
        javaType = JacksonConfiguration.constructType((Argument)conversionContext.getArgument(), (TypeFactory)this.xmlMapper.getTypeFactory());
        nameString = name.toString();
        try {
            streamReader = this.stream.reset();
            ** try [egrp 1[TRYBLOCK] [0 : 59->143)] { 
lbl12:
            // 1 sources

            ** GOTO lbl-1000
lbl13:
            // 1 sources

            finally {
                if (streamReader != null) {
                    streamReader.close();
                }
            }
        }
        catch (Exception e) {
            if (XmlStreamConvertibleValues.LOG.isErrorEnabled() == false) return Optional.empty();
            XmlStreamConvertibleValues.LOG.error("Failed to retrieve {} field from xml stream", (Object)name, (Object)e);
        }
        return Optional.empty();
lbl-1000:
        // 1 sources

        {
            while (true) {
                if (streamReader.hasNext() == false) return Optional.empty();
                token = streamReader.next();
                if (token == 1) {
                    if (++depth == 1 && nameString.equals(streamReader.getName().toString())) {
                        if (ClassUtils.isJavaBasicType((Class)conversionContext.getArgument().getType())) {
                            value = streamReader.getElementText();
                            var10_16 = this.conversionService.convert((Object)value, conversionContext);
                            return var10_16;
                        }
                        value = Optional.ofNullable(this.xmlMapper.readValue((XMLStreamReader)streamReader, javaType));
                        return value;
                    }
                    if (depth != 0) continue;
                } else {
                    if (token != 2) continue;
                    --depth;
                    continue;
                }
                i = 0;
                while (true) {
                    if (i >= streamReader.getAttributeCount()) ** break;
                    attr = streamReader.getAttributeLocalName(i);
                    if (attr.equals(nameString)) {
                        var11_17 = this.conversionService.convert((Object)streamReader.getAttributeValue(i), conversionContext);
                        return var11_17;
                    }
                    ++i;
                }
                break;
            }
        }
    }
}

