/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.xml.jackson.server;

import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.AbstractHttpContentProcessor;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.xml.jackson.server.convert.ByteArrayXmlStreamReader;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlContentProcessor
extends AbstractHttpContentProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(XmlContentProcessor.class);
    private static final int DEFAULT_REQUEST_SIZE = 1024;
    private final ByteArrayOutputStream byteArrayStream;

    public XmlContentProcessor(NettyHttpRequest<?> nettyHttpRequest, HttpServerConfiguration configuration) {
        super(nettyHttpRequest, configuration);
        int requestLength = this.advertisedLength != -1L ? (int)this.advertisedLength : 1024;
        this.byteArrayStream = new ByteArrayOutputStream(requestLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onData(ByteBufHolder message, Collection<Object> out) throws Throwable {
        ByteBuf content = message.content();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Buffer xml bytes of size {}", (Object)content.readableBytes());
        }
        try {
            content.readBytes((OutputStream)this.byteArrayStream, content.readableBytes());
        }
        finally {
            content.release();
        }
    }

    public void complete(Collection<Object> out) throws Throwable {
        byte[] bytes = this.byteArrayStream.toByteArray();
        ByteArrayXmlStreamReader byteArrayXmlStreamReader = new ByteArrayXmlStreamReader(bytes);
        out.add(byteArrayXmlStreamReader);
    }
}

