/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.xml.jackson.server;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.body.MessageBodyHandler;
import io.micronaut.http.codec.CodecException;
import io.micronaut.xml.jackson.server.convert.ByteArrayXmlStreamReader;
import io.micronaut.xml.jackson.server.convert.XmlStreamConvertibleValues;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

@Singleton
@Produces(value={"application/xml", "text/xml"})
@Consumes(value={"application/xml", "text/xml"})
final class XmlMessageHandler<T>
implements MessageBodyHandler<T> {
    private final ObjectMapper objectMapper;
    private final ConversionService conversionService;

    XmlMessageHandler(@Named(value="xml") ObjectMapper objectMapper, ConversionService conversionService) {
        this.objectMapper = objectMapper;
        this.conversionService = conversionService;
    }

    public boolean isReadable(Argument<T> type, MediaType mediaType) {
        return mediaType != null && mediaType.getExtension().equals("xml");
    }

    private static CodecException decorateRead(Argument<?> type, Exception e) {
        return new CodecException("Error decoding XML stream for type [" + type.getName() + "]: " + e.getMessage(), (Throwable)e);
    }

    public T read(Argument<T> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
        try {
            if (type.getType() == ConvertibleValues.class) {
                return (T)new XmlStreamConvertibleValues(new ByteArrayXmlStreamReader(inputStream.readAllBytes()), (XmlMapper)this.objectMapper, this.conversionService);
            }
            return (T)this.objectMapper.readValue(inputStream, XmlMessageHandler.constructType(type, this.objectMapper.getTypeFactory()));
        }
        catch (IOException | XMLStreamException e) {
            throw XmlMessageHandler.decorateRead(type, e);
        }
    }

    public boolean isWriteable(Argument<T> type, MediaType mediaType) {
        return mediaType != null && mediaType.getExtension().equals("xml");
    }

    private static CodecException decorateWrite(Object object, IOException e) {
        return new CodecException("Error encoding object [" + object + "] to XML: " + e.getMessage(), (Throwable)e);
    }

    public void writeTo(Argument<T> type, MediaType mediaType, T object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        outgoingHeaders.set((CharSequence)"Content-Type", (CharSequence)(mediaType != null ? mediaType : MediaType.APPLICATION_XML_TYPE));
        try {
            this.objectMapper.writerFor(XmlMessageHandler.constructType(type, this.objectMapper.getTypeFactory())).writeValue(outputStream, object);
        }
        catch (IOException e) {
            throw XmlMessageHandler.decorateWrite(object, e);
        }
    }

    public static <T> JavaType constructType(@NonNull Argument<T> type, @NonNull TypeFactory typeFactory) {
        ArgumentUtils.requireNonNull((String)"type", type);
        ArgumentUtils.requireNonNull((String)"typeFactory", (Object)typeFactory);
        Map typeVariables = type.getTypeVariables();
        Object[] objects = XmlMessageHandler.toJavaTypeArray(typeFactory, typeVariables);
        Class rawType = type.getType();
        if (ArrayUtils.isNotEmpty((Object[])objects)) {
            JavaType javaType = typeFactory.constructType((Type)rawType);
            if (javaType.isCollectionLikeType()) {
                return typeFactory.constructCollectionLikeType(rawType, (JavaType)objects[0]);
            }
            if (javaType.isMapLikeType()) {
                return typeFactory.constructMapLikeType(rawType, (JavaType)objects[0], (JavaType)objects[1]);
            }
            if (javaType.isReferenceType()) {
                return typeFactory.constructReferenceType(rawType, (JavaType)objects[0]);
            }
            return typeFactory.constructParametricType(rawType, (JavaType[])objects);
        }
        return typeFactory.constructType((Type)rawType);
    }

    private static JavaType[] toJavaTypeArray(TypeFactory typeFactory, Map<String, Argument<?>> typeVariables) {
        ArrayList<JavaType> javaTypes = new ArrayList<JavaType>();
        for (Argument<?> argument : typeVariables.values()) {
            if (argument.hasTypeVariables()) {
                javaTypes.add(typeFactory.constructParametricType(argument.getType(), XmlMessageHandler.toJavaTypeArray(typeFactory, argument.getTypeVariables())));
                continue;
            }
            javaTypes.add(typeFactory.constructType((Type)argument.getType()));
        }
        return javaTypes.toArray(new JavaType[0]);
    }
}

