/*
 * Decompiled with CFR 0.152.
 */
package io.microservices.canvas.asciidoc;

import io.microservices.canvas.model.AggregateAndPublishedEvents;
import io.microservices.canvas.model.InvokedChannelAndCommands;
import io.microservices.canvas.model.Operation;
import io.microservices.canvas.model.Service;
import io.microservices.canvas.model.SubscribedToAggregateAndEvents;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\tR\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\tR\u0011\u0010\u0019\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lio/microservices/canvas/asciidoc/Canvas;", "", "service", "Lio/microservices/canvas/model/Service;", "(Lio/microservices/canvas/model/Service;)V", "apiCommands", "", "Lio/microservices/canvas/model/Operation;", "getApiCommands", "()Ljava/util/List;", "apiEvents", "", "Lio/microservices/canvas/model/AggregateAndPublishedEvents;", "getApiEvents", "apiQueries", "getApiQueries", "capabilities", "", "getCapabilities", "dependenciesAsynchronousOperations", "Lio/microservices/canvas/model/InvokedChannelAndCommands;", "getDependenciesAsynchronousOperations", "dependenciesEvents", "Lio/microservices/canvas/model/SubscribedToAggregateAndEvents;", "getDependenciesEvents", "description", "getDescription", "()Ljava/lang/String;", "name", "getName", "microservice-canvas-render"})
public final class Canvas {
    @NotNull
    private final String name;
    @NotNull
    private final String description;
    @NotNull
    private final List<String> capabilities;
    @NotNull
    private final List<Operation> apiCommands;
    @NotNull
    private final List<Operation> apiQueries;
    @NotNull
    private final List<AggregateAndPublishedEvents> apiEvents;
    @NotNull
    private final List<InvokedChannelAndCommands> dependenciesAsynchronousOperations;
    @NotNull
    private final List<SubscribedToAggregateAndEvents> dependenciesEvents;

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final List<String> getCapabilities() {
        return this.capabilities;
    }

    @NotNull
    public final List<Operation> getApiCommands() {
        return this.apiCommands;
    }

    @NotNull
    public final List<Operation> getApiQueries() {
        return this.apiQueries;
    }

    @NotNull
    public final List<AggregateAndPublishedEvents> getApiEvents() {
        return this.apiEvents;
    }

    @NotNull
    public final List<InvokedChannelAndCommands> getDependenciesAsynchronousOperations() {
        return this.dependenciesAsynchronousOperations;
    }

    @NotNull
    public final List<SubscribedToAggregateAndEvents> getDependenciesEvents() {
        return this.dependenciesEvents;
    }

    public Canvas(@NotNull Service service) {
        Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
        this.name = service.getName();
        this.description = service.getDescription();
        this.capabilities = service.getCapabilities();
        this.apiCommands = service.getApi().getOperations().getCommands();
        this.apiQueries = service.getApi().getOperations().getQueries();
        this.apiEvents = service.getApi().getEvents().getPublishedEvents();
        this.dependenciesAsynchronousOperations = service.getDependencies().getAsynchronousOperations();
        this.dependenciesEvents = service.getDependencies().getEvents();
    }
}

