/*
 * Decompiled with CFR 0.152.
 */
package io.microservices.canvas.asciidoc;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import io.microservices.canvas.asciidoc.Canvas;
import io.microservices.canvas.asciidoc.OperationEndpointMixin;
import io.microservices.canvas.model.OperationEndpoint;
import io.microservices.canvas.model.Service;
import java.io.IOException;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class ServiceToJSon {
    public static <T> String toJson(T service) {
        ObjectMapper om = new ObjectMapper().registerModule((Module)new KotlinModule());
        try {
            return om.writeValueAsString(service);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toYaml(Service service) {
        ObjectMapper om = new ObjectMapper((JsonFactory)new YAMLFactory()).registerModule((Module)new KotlinModule());
        try {
            return om.writeValueAsString((Object)service);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromYaml(String yaml, Class<T> targetType) {
        ObjectMapper om = new ObjectMapper((JsonFactory)new YAMLFactory()).addMixIn(OperationEndpoint.class, OperationEndpointMixin.class).registerModule((Module)new KotlinModule());
        try {
            return (T)om.readValue(yaml, targetType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromJson(String json, Class<T> targetType) {
        ObjectMapper om = new ObjectMapper().addMixIn(OperationEndpoint.class, OperationEndpointMixin.class).registerModule((Module)new KotlinModule());
        try {
            return (T)om.readValue(json, targetType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toAsciidoc(Service service) {
        ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
        templateResolver.setTemplateMode(TemplateMode.TEXT);
        templateResolver.setSuffix(".adoc");
        return ServiceToJSon.processTemplate(service, templateResolver);
    }

    private static String processTemplate(Service service, ClassLoaderTemplateResolver templateResolver) {
        templateResolver.setPrefix("/templates/");
        templateResolver.setCacheable(true);
        SpringTemplateEngine te = new SpringTemplateEngine();
        te.setTemplateResolver((ITemplateResolver)templateResolver);
        Context context = new Context();
        context.setVariable("service", (Object)new Canvas(service));
        return te.process("/microservicecanvas/asciiDocCanvas", (IContext)context);
    }

    public static String toHtml(Service service) {
        ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
        templateResolver.setTemplateMode(TemplateMode.HTML);
        templateResolver.setSuffix(".html");
        return ServiceToJSon.processTemplate(service, templateResolver);
    }
}

