/*
 * Decompiled with CFR 0.152.
 */
package org.masukomi.aspirin.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.masukomi.aspirin.core.Helper;
import org.masukomi.aspirin.core.config.Configuration;
import org.masukomi.aspirin.core.delivery.DeliveryManager;
import org.masukomi.aspirin.core.listener.AspirinListener;
import org.masukomi.aspirin.core.listener.ListenerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspirinInternal {
    private static final Logger log = LoggerFactory.getLogger(AspirinInternal.class);
    private volatile Session defaultSession = null;
    private Integer idCounter = 0;
    private Object idCounterLock = new Object();
    private final Configuration configuration;
    private final ListenerManager listenerManager;
    private final DeliveryManager deliveryManager;
    private final Helper helper;

    public AspirinInternal(Configuration configuration, DeliveryManager deliveryManager, ListenerManager listenerManager) {
        this.configuration = configuration;
        this.deliveryManager = deliveryManager;
        this.listenerManager = listenerManager;
        this.helper = new Helper(configuration);
    }

    public void start() {
        if (!this.deliveryManager.isAlive()) {
            this.deliveryManager.start();
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    protected void add(MimeMessage msg) throws MessagingException {
        if (!this.deliveryManager.isAlive()) {
            this.deliveryManager.start();
        }
        this.deliveryManager.add(msg);
    }

    public void add(MimeMessage msg, long expiry) throws MessagingException {
        if (0L < expiry) {
            this.helper.setExpiry(msg, expiry);
        }
        this.add(msg);
    }

    public void addListener(AspirinListener listener) {
        this.listenerManager.add(listener);
    }

    public void remove(String mailid) throws MessagingException {
        this.deliveryManager.remove(mailid);
    }

    public void removeListener(AspirinListener listener) {
        if (this.listenerManager != null) {
            this.listenerManager.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimeMessage createNewMimeMessage() {
        if (this.defaultSession == null) {
            this.defaultSession = Session.getDefaultInstance((Properties)System.getProperties());
        }
        MimeMessage mMesg = new MimeMessage(this.defaultSession);
        Object object = this.idCounterLock;
        synchronized (object) {
            long nowTime = System.currentTimeMillis() / 1000L;
            Integer n = this.idCounter;
            Integer n2 = this.idCounter = Integer.valueOf(this.idCounter + 1);
            String newId = nowTime + "." + Integer.toHexString(n);
            try {
                mMesg.setHeader("X-Aspirin-MailID", newId);
            }
            catch (MessagingException msge) {
                log.warn("Aspirin Mail ID could not be generated.", (Throwable)msge);
                msge.printStackTrace();
            }
        }
        return mMesg;
    }

    public static Collection<InternetAddress> extractRecipients(MimeMessage message) throws MessagingException {
        Message.RecipientType[] types;
        ArrayList<InternetAddress> recipients = new ArrayList<InternetAddress>();
        for (Message.RecipientType recType : types = new Message.RecipientType[]{MimeMessage.RecipientType.TO, MimeMessage.RecipientType.CC, MimeMessage.RecipientType.BCC}) {
            Address[] addresses = message.getRecipients(recType);
            if (addresses == null) continue;
            for (Address addr : addresses) {
                try {
                    recipients.add((InternetAddress)addr);
                }
                catch (Exception e) {
                    log.warn("Recipient parsing failed.", (Throwable)e);
                }
            }
        }
        return recipients;
    }

    public DeliveryManager getDeliveryManager() {
        return this.deliveryManager;
    }

    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    public void shutdown() {
        this.deliveryManager.shutdown();
    }
}

