/*
 * Decompiled with CFR 0.152.
 */
package org.masukomi.aspirin.core.delivery;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.masukomi.aspirin.core.AspirinInternal;
import org.masukomi.aspirin.core.Helper;
import org.masukomi.aspirin.core.config.Configuration;
import org.masukomi.aspirin.core.config.ConfigurationChangeListener;
import org.masukomi.aspirin.core.delivery.DeliveryContext;
import org.masukomi.aspirin.core.delivery.DeliveryHandler;
import org.masukomi.aspirin.core.delivery.DeliveryThread;
import org.masukomi.aspirin.core.delivery.GenericPoolableDeliveryThreadFactory;
import org.masukomi.aspirin.core.delivery.SendMessage;
import org.masukomi.aspirin.core.dns.ResolveHost;
import org.masukomi.aspirin.core.store.mail.MailStore;
import org.masukomi.aspirin.core.store.queue.DeliveryState;
import org.masukomi.aspirin.core.store.queue.QueueInfo;
import org.masukomi.aspirin.core.store.queue.QueueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeliveryManager
extends Thread
implements ConfigurationChangeListener {
    private static final Logger log = LoggerFactory.getLogger(DeliveryManager.class);
    private final Configuration configuration;
    private final MailStore mailStore;
    private final QueueStore queueStore;
    private Object mailingLock = new Object();
    private ObjectPool deliveryThreadObjectPool = null;
    private boolean running = false;
    private GenericPoolableDeliveryThreadFactory deliveryThreadObjectFactory = null;
    private Map<String, DeliveryHandler> deliveryHandlers = new HashMap<String, DeliveryHandler>();
    private final Helper helper;

    public DeliveryManager(Configuration configuration, QueueStore queueStore, MailStore mailStore) {
        this.configuration = configuration;
        this.helper = new Helper(configuration);
        this.mailStore = mailStore;
        this.setName("Aspirin-" + this.getClass().getSimpleName() + "-" + this.getId());
        GenericObjectPool.Config gopConf = new GenericObjectPool.Config();
        gopConf.lifo = false;
        gopConf.maxActive = configuration.getDeliveryThreadsActiveMax();
        gopConf.maxIdle = configuration.getDeliveryThreadsIdleMax();
        gopConf.maxWait = 5000L;
        gopConf.testOnReturn = true;
        gopConf.whenExhaustedAction = 1;
        this.deliveryThreadObjectFactory = new GenericPoolableDeliveryThreadFactory(this, configuration);
        this.deliveryThreadObjectPool = new GenericObjectPool((PoolableObjectFactory)this.deliveryThreadObjectFactory, gopConf);
        this.deliveryThreadObjectFactory.init(new ThreadGroup("DeliveryThreadGroup"), this.deliveryThreadObjectPool);
        this.queueStore = queueStore;
        queueStore.init();
        this.deliveryHandlers.put(SendMessage.class.getCanonicalName(), new SendMessage(configuration, mailStore));
        this.deliveryHandlers.put(ResolveHost.class.getCanonicalName(), new ResolveHost());
        configuration.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String add(MimeMessage mimeMessage) throws MessagingException {
        String mailid = this.helper.getMailID(mimeMessage);
        long expiry = this.helper.getExpiry(mimeMessage);
        Collection<InternetAddress> recipients = AspirinInternal.extractRecipients(mimeMessage);
        Object object = this.mailingLock;
        synchronized (object) {
            this.mailStore.set(mailid, mimeMessage);
            this.queueStore.add(mailid, expiry, recipients);
        }
        return mailid;
    }

    public MimeMessage get(QueueInfo qi) {
        if (qi == null) {
            throw new RuntimeException("queue info object is null");
        }
        return this.mailStore.get(qi.getMailid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String messageName) {
        Object object = this.mailingLock;
        synchronized (object) {
            this.mailStore.remove(messageName);
            this.queueStore.remove(messageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        log.info("DeliveryManager started.");
        while (this.running) {
            QueueInfo qi = null;
            try {
                Object dCtx;
                qi = this.queueStore.next();
                if (qi != null) {
                    dCtx = new DeliveryContext().setQueueInfo(qi);
                    log.trace("DeliveryManager.run(): Pool state. A{}/I{}", new Object[]{this.deliveryThreadObjectPool.getNumActive(), this.deliveryThreadObjectPool.getNumIdle()});
                    try {
                        log.debug("DeliveryManager.run(): Start delivery. qi={}", (Object)qi);
                        DeliveryThread dThread = (DeliveryThread)this.deliveryThreadObjectPool.borrowObject();
                        log.trace("DeliveryManager.run(): Borrow DeliveryThread object. dt={}: state '{}/{}'", new Object[]{dThread.getName(), dThread.getState().name(), dThread.isAlive()});
                        dThread.setContext((DeliveryContext)dCtx);
                        if (dThread.isAlive()) continue;
                        dThread.start();
                    }
                    catch (IllegalStateException ise) {
                        this.release(qi);
                    }
                    catch (NoSuchElementException nsee) {
                        log.debug("DeliveryManager.run(): No idle DeliveryThread is available: {}", (Object)nsee.getMessage());
                        qi.setResultInfo("No delivery available, will try again");
                        this.release(qi);
                    }
                    catch (Exception e) {
                        log.error("DeliveryManager.run(): Failed borrow delivery thread object.", (Throwable)e);
                        this.release(qi);
                    }
                    continue;
                }
                dCtx = this;
                synchronized (dCtx) {
                    try {
                        this.wait(6000L);
                    }
                    catch (InterruptedException e) {
                        this.running = false;
                    }
                }
            }
            catch (Throwable t) {
                log.error("Exception polling for messages", t);
                System.out.println("----");
                if (qi == null) continue;
                this.release(qi);
            }
        }
        log.info("DeliveryManager terminated.");
    }

    public boolean isRunning() {
        return this.running;
    }

    public void terminate() {
        this.running = false;
    }

    public void release(QueueInfo qi) {
        if (qi.hasState(DeliveryState.IN_PROGRESS)) {
            if (qi.isInTimeBounds()) {
                qi.setState(DeliveryState.QUEUED);
                log.trace("DeliveryManager.release(): Releasing: QUEUED. qi={}", (Object)qi);
            } else {
                qi.setState(DeliveryState.FAILED);
                log.trace("DeliveryManager.release(): Releasing: FAILED. qi={}", (Object)qi);
            }
        }
        this.queueStore.setSendingResult(qi);
        if (this.queueStore.isCompleted(qi.getMailid())) {
            this.queueStore.remove(qi.getMailid());
        }
        log.trace("DeliveryManager.release(): Release item '{}' with state: '{}' after {} attempts.", new Object[]{qi.getMailid(), qi.getState().name(), qi.getAttemptCount()});
    }

    public boolean isCompleted(QueueInfo qi) {
        return this.queueStore.isCompleted(qi.getMailid());
    }

    @Override
    public void configChanged(String parameterName) {
    }

    public DeliveryHandler getDeliveryHandler(String handlerName) {
        return this.deliveryHandlers.get(handlerName);
    }

    public void shutdown() {
        this.running = false;
        try {
            this.deliveryThreadObjectPool.close();
            this.deliveryThreadObjectPool.clear();
        }
        catch (Exception e) {
            log.error("DeliveryManager.shutdown() failed.", (Throwable)e);
        }
    }
}

