/*
 * Decompiled with CFR 0.152.
 */
package org.masukomi.aspirin.core.delivery;

import javax.mail.MessagingException;
import javax.mail.Session;
import org.apache.commons.pool.ObjectPool;
import org.masukomi.aspirin.core.config.Configuration;
import org.masukomi.aspirin.core.delivery.DeliveryContext;
import org.masukomi.aspirin.core.delivery.DeliveryException;
import org.masukomi.aspirin.core.delivery.DeliveryHandler;
import org.masukomi.aspirin.core.delivery.DeliveryManager;
import org.masukomi.aspirin.core.delivery.SendMessage;
import org.masukomi.aspirin.core.dns.ResolveHost;
import org.masukomi.aspirin.core.store.queue.DeliveryState;
import org.masukomi.aspirin.core.store.queue.QueueInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeliveryThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(DeliveryThread.class);
    private final DeliveryManager deliveryManager;
    private final Configuration configuration;
    private boolean running = true;
    private ObjectPool parentObjectPool = null;
    private DeliveryContext dCtx = null;

    public DeliveryThread(ThreadGroup parentThreadGroup, DeliveryManager deliveryManager, Configuration configuration) {
        super(parentThreadGroup, DeliveryThread.class.getSimpleName());
        this.deliveryManager = deliveryManager;
        this.configuration = configuration;
    }

    public ObjectPool getParentObjectPool() {
        return this.parentObjectPool;
    }

    public void setParentObjectPool(ObjectPool parentObjectPool) {
        this.parentObjectPool = parentObjectPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        log.debug("DeliveryThread ({}).shutdown(): Called.", (Object)this.getName());
        this.running = false;
        DeliveryThread deliveryThread = this;
        synchronized (deliveryThread) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            DeliveryThread deliveryThread = this;
            synchronized (deliveryThread) {
                if (this.dCtx == null) {
                    try {
                        if (this.running) {
                            log.trace("DeliveryThread ({}).run(): Wait for next sendable item.", (Object)this.getName());
                            this.wait(60000L);
                            continue;
                        }
                    }
                    catch (InterruptedException ie) {
                        if (this.dCtx != null) {
                            log.trace("DeliveryThread ({}).run(): Release item after interruption. qi={}", new Object[]{this.getName(), this.dCtx});
                            this.deliveryManager.release(this.dCtx.getQueueInfo());
                            this.dCtx = null;
                        }
                        this.running = false;
                        try {
                            log.trace("DeliveryThread ({}).run(): Invalidate DeliveryThread object in the pool.", (Object)this.getName());
                            this.parentObjectPool.invalidateObject((Object)this);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("The object could not be invalidated in the pool.", e);
                        }
                    }
                }
            }
            try {
                if (this.dCtx != null) {
                    log.trace("DeliveryThread ({}).run(): Call delivering... dCtx={}", new Object[]{this.getName(), this.dCtx});
                    this.deliver(this.dCtx, this.configuration.newMailSession());
                    this.deliveryManager.release(this.dCtx.getQueueInfo());
                    this.dCtx = null;
                }
            }
            catch (Exception e) {
                log.error("DeliveryThread (" + this.getName() + ").run(): Could not deliver message. dCtx={" + this.dCtx + "}", (Throwable)e);
            }
            finally {
                if (this.dCtx != null && !this.dCtx.getQueueInfo().isSendable()) {
                    this.deliveryManager.release(this.dCtx.getQueueInfo());
                    this.dCtx = null;
                }
            }
            if (this.dCtx != null) continue;
            try {
                log.trace("DeliveryThread ({}).run(): Try to give back DeliveryThread object into the pool.", (Object)this.getName());
                this.parentObjectPool.returnObject((Object)this);
            }
            catch (Exception e) {
                log.error("DeliveryThread (" + this.getName() + ").run(): The object could not be returned into the pool.", (Throwable)e);
                this.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContext(DeliveryContext dCtx) throws MessagingException {
        DeliveryThread deliveryThread = this;
        synchronized (deliveryThread) {
            if (this.dCtx != null) {
                if (this.dCtx.getQueueInfo().hasState(DeliveryState.IN_PROGRESS)) {
                    this.notify();
                }
                throw new MessagingException("The previous QuedItem was not removed from this thread.");
            }
            this.dCtx = dCtx;
            log.trace("DeliveryThread ({}).setQuedItem(): Item was set. qi={}", new Object[]{this.getName(), dCtx});
            this.notify();
        }
    }

    private void deliver(DeliveryContext dCtx, Session session) {
        log.info("DeliveryThread ({}).deliver(): Starting mail delivery. qi={}", new Object[]{this.getName(), dCtx});
        String[] handlerList = new String[]{ResolveHost.class.getCanonicalName(), SendMessage.class.getCanonicalName()};
        QueueInfo qInfo = dCtx.getQueueInfo();
        for (String handlerName : handlerList) {
            try {
                DeliveryHandler handler = this.deliveryManager.getDeliveryHandler(handlerName);
                log.info("deliver using: " + handler.getClass());
                handler.handle(dCtx);
            }
            catch (DeliveryException de) {
                qInfo.setResultInfo(de.getMessage());
                log.info("DeliveryThread ({}).deliver(): Mail delivery failed: {}. qi={}", new Object[]{this.getName(), qInfo.getResultInfo(), dCtx});
                if (de.isPermanent()) {
                    qInfo.setState(DeliveryState.FAILED);
                } else {
                    qInfo.setState(DeliveryState.QUEUED);
                }
                return;
            }
        }
        if (qInfo.hasState(DeliveryState.IN_PROGRESS)) {
            if (qInfo.getResultInfo() == null) {
                qInfo.setResultInfo("250 OK");
            }
            log.info("DeliveryThread ({}).deliver(): Mail delivery success: {}. qi={}", new Object[]{this.getName(), qInfo.getResultInfo(), dCtx});
            qInfo.setState(DeliveryState.SENT);
        }
    }
}

