/*
 * Decompiled with CFR 0.152.
 */
package org.masukomi.aspirin.core.delivery;

import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.masukomi.aspirin.core.config.Configuration;
import org.masukomi.aspirin.core.delivery.DeliveryManager;
import org.masukomi.aspirin.core.delivery.DeliveryThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericPoolableDeliveryThreadFactory
extends BasePoolableObjectFactory {
    private static final Logger log = LoggerFactory.getLogger(GenericPoolableDeliveryThreadFactory.class);
    private ThreadGroup deliveryThreadGroup = null;
    private ObjectPool myParentPool = null;
    private Integer rdCount = 0;
    private Object rdLock = new Object();
    private final DeliveryManager deliveryManager;
    private final Configuration configuration;

    public GenericPoolableDeliveryThreadFactory(DeliveryManager deliveryManager, Configuration configuration) {
        this.deliveryManager = deliveryManager;
        this.configuration = configuration;
    }

    public void init(ThreadGroup deliveryThreadGroup, ObjectPool pool) {
        this.deliveryThreadGroup = deliveryThreadGroup;
        this.myParentPool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object makeObject() throws Exception {
        if (this.myParentPool == null) {
            throw new RuntimeException("Please set the parent pool for right working.");
        }
        DeliveryThread dThread = new DeliveryThread(this.deliveryThreadGroup, this.deliveryManager, this.configuration);
        Object object = this.rdLock;
        synchronized (object) {
            Integer n = this.rdCount;
            Integer n2 = this.rdCount = Integer.valueOf(this.rdCount + 1);
            dThread.setName(DeliveryThread.class.getSimpleName() + "-" + this.rdCount);
        }
        dThread.setParentObjectPool(this.myParentPool);
        log.trace("GenericPoolableDeliveryThreadFactory.makeObject(): New DeliveryThread object created: {}.", (Object)dThread.getName());
        return dThread;
    }

    public void destroyObject(Object obj) throws Exception {
        if (obj instanceof DeliveryThread) {
            DeliveryThread dThread = (DeliveryThread)obj;
            log.trace(((Object)((Object)this)).getClass().getSimpleName() + ".destroyObject(): destroy thread {}.", (Object)dThread.getName());
            dThread.shutdown();
        }
    }

    public boolean validateObject(Object obj) {
        if (obj instanceof DeliveryThread) {
            DeliveryThread dThread = (DeliveryThread)obj;
            return dThread.isAlive() && (dThread.getState().equals((Object)Thread.State.NEW) || dThread.getState().equals((Object)Thread.State.RUNNABLE) || dThread.getState().equals((Object)Thread.State.TIMED_WAITING) || dThread.getState().equals((Object)Thread.State.WAITING));
        }
        return false;
    }
}

