/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.engine;

import info.ineighborhood.cardme.engine.VCardEngine;
import info.ineighborhood.cardme.io.CompatibilityMode;
import info.ineighborhood.cardme.io.VCardWriter;
import info.ineighborhood.cardme.util.StringUtil;
import info.ineighborhood.cardme.vcard.VCard;
import info.ineighborhood.cardme.vcard.VCardImpl;
import info.ineighborhood.cardme.vcard.VCardVersion;
import info.ineighborhood.cardme.vcard.errors.VCardError;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class TestParser {
    private File[] vcardFiles = null;
    private VCardEngine vcardEngine = new VCardEngine();

    public void setCompatibilityMode(CompatibilityMode compatMode) {
        this.vcardEngine.setCompatibilityMode(compatMode);
    }

    public List<VCard> importVCards() {
        ArrayList<VCard> vcards = new ArrayList<VCard>();
        this.vcardFiles = this.getFiles();
        for (int i = 0; i < this.vcardFiles.length; ++i) {
            try {
                VCard vcard = this.vcardEngine.parse(this.vcardFiles[i]);
                vcards.add(vcard);
                continue;
            }
            catch (IOException ioe) {
                System.err.println("Could not read vcard file: " + this.vcardFiles[i].getAbsolutePath());
                ioe.printStackTrace();
            }
        }
        return vcards;
    }

    private File[] getFiles() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select VCards");
        chooser.setCurrentDirectory(new File(System.getProperties().getProperty("user.home")));
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".vcf") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "VCard Files";
            }
        });
        int result = chooser.showOpenDialog(null);
        if (result == 1) {
            return null;
        }
        try {
            File[] files = chooser.getSelectedFiles();
            return files;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Warning! Could not load the file(s)!", "Warning!", 2);
            return null;
        }
    }

    public static void main(String[] args) {
        TestParser testParser = new TestParser();
        testParser.setCompatibilityMode(CompatibilityMode.RFC2426);
        List<VCard> vcards = testParser.importVCards();
        VCardWriter writer = new VCardWriter();
        writer.setOutputVersion(VCardVersion.V3_0);
        for (int i = 0; i < vcards.size(); ++i) {
            VCardImpl vcard = (VCardImpl)vcards.get(i);
            if (vcard.hasErrors()) {
                System.out.println("VCard " + i + " has some errors ...");
                List<VCardError> errors = vcard.getErrors();
                for (int j = 0; j < errors.size(); ++j) {
                    System.out.println(errors.get(j).getErrorMessage());
                    System.out.println((Object)errors.get(j).getSeverity());
                    System.out.println(StringUtil.formatException(errors.get(j).getError()));
                }
            }
            writer.setVCard(vcard);
            String vstring = writer.buildVCardString();
            if (writer.hasErrors()) {
                List<VCardError> errors = vcard.getErrors();
                for (int j = 0; j < errors.size(); ++j) {
                    System.out.println(errors.get(j).getErrorMessage());
                    System.out.println((Object)errors.get(j).getSeverity());
                    System.out.println(StringUtil.formatException(errors.get(j).getError()));
                }
            }
            System.out.println(vstring);
        }
        System.out.println("\n-- END --");
    }
}

