/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.engine;

import info.ineighborhood.cardme.io.CompatibilityMode;
import info.ineighborhood.cardme.util.Base64Wrapper;
import info.ineighborhood.cardme.util.VCardUtils;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCard;
import info.ineighborhood.cardme.vcard.VCardImpl;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.VCardVersion;
import info.ineighborhood.cardme.vcard.errors.ErrorSeverity;
import info.ineighborhood.cardme.vcard.errors.VCardBuildException;
import info.ineighborhood.cardme.vcard.errors.VCardError;
import info.ineighborhood.cardme.vcard.errors.VCardException;
import info.ineighborhood.cardme.vcard.features.AddressFeature;
import info.ineighborhood.cardme.vcard.types.AddressType;
import info.ineighborhood.cardme.vcard.types.BeginType;
import info.ineighborhood.cardme.vcard.types.BirthdayType;
import info.ineighborhood.cardme.vcard.types.CategoriesType;
import info.ineighborhood.cardme.vcard.types.ClassType;
import info.ineighborhood.cardme.vcard.types.DisplayableNameType;
import info.ineighborhood.cardme.vcard.types.EmailType;
import info.ineighborhood.cardme.vcard.types.EndType;
import info.ineighborhood.cardme.vcard.types.ExtendedType;
import info.ineighborhood.cardme.vcard.types.FormattedNameType;
import info.ineighborhood.cardme.vcard.types.GeographicPositionType;
import info.ineighborhood.cardme.vcard.types.KeyType;
import info.ineighborhood.cardme.vcard.types.LabelType;
import info.ineighborhood.cardme.vcard.types.LogoType;
import info.ineighborhood.cardme.vcard.types.MailerType;
import info.ineighborhood.cardme.vcard.types.NameType;
import info.ineighborhood.cardme.vcard.types.NicknameType;
import info.ineighborhood.cardme.vcard.types.NoteType;
import info.ineighborhood.cardme.vcard.types.OrganizationType;
import info.ineighborhood.cardme.vcard.types.PhotoType;
import info.ineighborhood.cardme.vcard.types.ProductIdType;
import info.ineighborhood.cardme.vcard.types.ProfileType;
import info.ineighborhood.cardme.vcard.types.RevisionType;
import info.ineighborhood.cardme.vcard.types.RoleType;
import info.ineighborhood.cardme.vcard.types.SortStringType;
import info.ineighborhood.cardme.vcard.types.SoundType;
import info.ineighborhood.cardme.vcard.types.SourceType;
import info.ineighborhood.cardme.vcard.types.TelephoneType;
import info.ineighborhood.cardme.vcard.types.TimeZoneType;
import info.ineighborhood.cardme.vcard.types.TitleType;
import info.ineighborhood.cardme.vcard.types.UIDType;
import info.ineighborhood.cardme.vcard.types.URLType;
import info.ineighborhood.cardme.vcard.types.VersionType;
import info.ineighborhood.cardme.vcard.types.media.AudioMediaType;
import info.ineighborhood.cardme.vcard.types.media.ImageMediaType;
import info.ineighborhood.cardme.vcard.types.media.KeyTextType;
import info.ineighborhood.cardme.vcard.types.parameters.AddressParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.EmailParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.KeyParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.LabelParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.LogoParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.PhotoParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.SoundParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.TelephoneParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.XAddressParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.XEmailParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.XLabelParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.XTelephoneParameterType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class VCardEngine {
    private static final Pattern VCF_BEGIN_PATTERN = Pattern.compile("\\p{Blank}*((BEGIN)|(begin))\\p{Blank}*:\\p{Blank}*((VCARD)|(vcard))\\p{Blank}*");
    private static final Pattern VCF_END_PATTERN = Pattern.compile("\\p{Blank}*((END)|(end))\\p{Blank}*:\\p{Blank}*((VCARD)|(vcard))\\p{Blank}*");
    private static final Pattern VCF_GEO_PATTERN = Pattern.compile("-?\\d{1,3}\\.\\d{1,6}\\;-?\\d{1,3}\\.\\d{1,6}");
    private CompatibilityMode compatMode = null;

    public VCardEngine() {
        this.compatMode = CompatibilityMode.RFC2426;
    }

    public VCardEngine(CompatibilityMode compatMode) {
        this.compatMode = compatMode;
    }

    public void setCompatibilityMode(CompatibilityMode compatMode) {
        this.compatMode = compatMode == null ? CompatibilityMode.RFC2426 : compatMode;
    }

    public CompatibilityMode getCompatibilityMode() {
        return this.compatMode;
    }

    public VCard parse(File vcardFile) throws IOException {
        String vcardStr = this.getContentFromFile(vcardFile);
        String unfoldedVcardStr = VCardUtils.unfoldVCard(vcardStr);
        return this.parseVCard(unfoldedVcardStr);
    }

    public VCard parse(String vcardString) throws IOException {
        String vcardStr = this.getContentFromString(vcardString);
        String unfoldedVcardStr = VCardUtils.unfoldVCard(vcardStr);
        return this.parseVCard(unfoldedVcardStr);
    }

    public List<VCard> parseManyInOneVCard(String vcardStr) {
        ArrayList<VCard> vcards = new ArrayList<VCard>();
        List<String> enumCards = this.enumerateVCards(vcardStr);
        for (String card : enumCards) {
            VCard vcard = this.parseVCard(card);
            vcards.add(vcard);
        }
        return vcards;
    }

    private List<String> enumerateVCards(String vcardString) {
        ArrayList<String> vcardStrings = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        String[] split = vcardString.split("\r?\n");
        boolean begin = false;
        boolean end = false;
        for (String s : split) {
            if (VCF_BEGIN_PATTERN.matcher(s).matches()) {
                begin = true;
            }
            if (VCF_END_PATTERN.matcher(s).matches()) {
                end = true;
            }
            if (begin && !end) {
                sb.append(s);
                sb.append('\n');
            }
            if (!end) continue;
            sb.append(s);
            sb.append('\n');
            begin = false;
            end = false;
            vcardStrings.add(sb.toString());
            sb = new StringBuilder();
        }
        return vcardStrings;
    }

    private VCard parseVCard(String vcardStr) {
        VCardImpl vcard = new VCardImpl();
        vcard.setThrowExceptions(false);
        List<String[]> arrayLines = this.splitLines(vcardStr);
        String[] vLine = null;
        for (int i = 0; i < arrayLines.size(); ++i) {
            vLine = arrayLines.get(i);
            String type = vLine[0].trim();
            String value = vLine.length > 1 ? vLine[1].trim() : null;
            String paramTypes = null;
            String group = null;
            if (type.indexOf(46) != -1) {
                group = type.substring(0, type.indexOf(46));
                type = type.substring(type.indexOf(46) + 1);
            }
            if (type.indexOf(59) != -1) {
                paramTypes = type.substring(type.indexOf(59) + 1).trim().toUpperCase();
                type = type.substring(0, type.indexOf(59)).trim();
            }
            try {
                this.parseLine(group, type.toUpperCase(), paramTypes, value, vcard);
                continue;
            }
            catch (VCardBuildException vbe) {
                if (vcard.isThrowExceptions()) {
                    throw new VCardException(vbe.getMessage(), vbe);
                }
                this.handleError(vcard, vbe.getMessage(), vbe, ErrorSeverity.WARNING);
            }
        }
        return vcard;
    }

    private void parseLine(String group, String type, String paramTypes, String value, VCardImpl vcard) throws VCardBuildException {
        VCardType vCardType = null;
        if (type.startsWith("X-")) {
            vCardType = VCardType.XTENDED;
        } else {
            try {
                type = type.replaceAll("-", "_");
                vCardType = VCardType.valueOf(type);
            }
            catch (IllegalArgumentException iae) {
                if (vcard.isThrowExceptions()) {
                    throw new VCardException(iae.getMessage(), iae);
                }
                this.handleError(vcard, "Unrecognizable type name \"" + type + "\"", iae, ErrorSeverity.WARNING);
                return;
            }
        }
        switch (vCardType) {
            case BEGIN: {
                this.parseBeginType(group, value, vcard);
                break;
            }
            case END: {
                this.parseEndType(group, value, vcard);
                break;
            }
            case VERSION: {
                this.parseVersionType(group, value, vcard);
                break;
            }
            case FN: {
                this.parseFnType(group, value, vcard);
                break;
            }
            case N: {
                this.parseNType(group, value, vcard);
                break;
            }
            case NICKNAME: {
                this.parseNicknameType(group, value, vcard);
                break;
            }
            case PHOTO: {
                this.parsePhotoType(group, value, paramTypes, vcard);
                break;
            }
            case BDAY: {
                this.parseBDayType(group, value, vcard);
                break;
            }
            case ADR: {
                this.parseAdrType(group, value, paramTypes, vcard);
                break;
            }
            case LABEL: {
                this.parseLabelType(group, value, paramTypes, vcard);
                break;
            }
            case TEL: {
                this.parseTelType(group, value, paramTypes, vcard);
                break;
            }
            case EMAIL: {
                this.parseEmailType(group, value, paramTypes, vcard);
                break;
            }
            case MAILER: {
                this.parseMailerType(group, value, vcard);
                break;
            }
            case TZ: {
                this.parseTzType(group, value, paramTypes, vcard);
                break;
            }
            case GEO: {
                this.parseGeoType(group, value, vcard);
                break;
            }
            case TITLE: {
                this.parseTitleType(group, value, vcard);
                break;
            }
            case ROLE: {
                this.parseRoleType(group, value, vcard);
                break;
            }
            case LOGO: {
                this.parseLogoType(group, value, paramTypes, vcard);
                break;
            }
            case AGENT: {
                break;
            }
            case ORG: {
                this.parseOrgType(group, value, vcard);
                break;
            }
            case CATEGORIES: {
                this.parseCategoriesType(group, value, vcard);
                break;
            }
            case NOTE: {
                this.parseNoteType(group, value, vcard);
                break;
            }
            case PRODID: {
                this.parseProdidType(group, value, vcard);
                break;
            }
            case REV: {
                this.parseRevType(group, value, vcard);
                break;
            }
            case SORT_STRING: {
                this.parseSortStringType(group, value, vcard);
                break;
            }
            case SOUND: {
                this.parseSoundType(group, value, paramTypes, vcard);
                break;
            }
            case UID: {
                this.parseUidType(group, value, vcard);
                break;
            }
            case URL: {
                this.parseUrlType(group, value, vcard);
                break;
            }
            case CLASS: {
                this.parseClassType(group, value, vcard);
                break;
            }
            case KEY: {
                this.parseKeyType(group, value, paramTypes, vcard);
                break;
            }
            case XTENDED: {
                this.parseXtendedType(group, value, type, vcard);
                break;
            }
            case NAME: {
                this.parseDisplayableNameType(group, value, vcard);
                break;
            }
            case PROFILE: {
                this.parseProfileType(group, value, vcard);
                break;
            }
            case SOURCE: {
                this.parseSourceType(group, value, vcard);
                break;
            }
            default: {
                throw new VCardBuildException("Unhandled VCard type \"" + vCardType.getType() + "\"");
            }
        }
    }

    private void parseBeginType(String group, String value, VCardImpl vcard) throws VCardBuildException {
        try {
            BeginType beginFeature = new BeginType();
            if (value.compareToIgnoreCase("VCARD") == 0) {
                if (group != null) {
                    beginFeature.setGroup(group);
                }
            } else {
                throw new VCardBuildException("Invalid value for \"BEGIN\" type. Must be \"VCARD\"");
            }
            vcard.setBegin(beginFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("BeginType (" + VCardType.BEGIN.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseEndType(String group, String value, VCardImpl vcard) throws VCardBuildException {
        try {
            EndType endFeature = new EndType();
            if (value.compareToIgnoreCase("VCARD") == 0) {
                if (group != null) {
                    endFeature.setGroup(group);
                }
            } else {
                throw new VCardException("Invalid value for \"END\" type. Must be \"VCARD\"");
            }
            vcard.setEnd(endFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("EndType (" + VCardType.END.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseVersionType(String group, String value, VCardImpl vcard) throws VCardBuildException {
        try {
            VersionType versionFeature = new VersionType();
            if (value.compareTo(VCardVersion.V3_0.getVersion()) == 0) {
                versionFeature.setVersion(VCardVersion.V3_0);
            } else if (value.compareTo(VCardVersion.V2_1.getVersion()) == 0) {
                versionFeature.setVersion(VCardVersion.V2_1);
            } else {
                throw new VCardException("Invalid value for \"VERSION\" type. Must be [3.0, 2.1]");
            }
            if (group != null) {
                versionFeature.setGroup(group);
            }
            vcard.setVersion(versionFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("VersionType (" + VCardType.VERSION.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseFnType(String group, String value, VCardImpl vcard) throws VCardBuildException {
        try {
            FormattedNameType formattedNameFeature = new FormattedNameType();
            if (VCardUtils.needsUnEscaping(value)) {
                formattedNameFeature.setFormattedName(VCardUtils.unescapeString(value));
            } else {
                formattedNameFeature.setFormattedName(value);
            }
            if (group != null) {
                formattedNameFeature.setGroup(group);
            }
            vcard.setFormattedName(formattedNameFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("FormattedNameType (" + VCardType.FN.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseNType(String group, String value, VCardImpl vcard) throws VCardBuildException {
        try {
            int i;
            NameType nameFeature = new NameType();
            String[] names = value.split(";", 5);
            if (names[0] != null) {
                if (VCardUtils.needsUnEscaping(names[0])) {
                    nameFeature.setFamilyName(VCardUtils.unescapeString(names[0]));
                } else {
                    nameFeature.setFamilyName(names[0]);
                }
            } else {
                throw new VCardBuildException("NameType (" + VCardType.FN.getType() + ") The family name field cannot be left empty.");
            }
            if (names[1] != null) {
                if (VCardUtils.needsUnEscaping(names[1])) {
                    nameFeature.setGivenName(VCardUtils.unescapeString(names[1]));
                } else {
                    nameFeature.setGivenName(names[1]);
                }
            } else {
                throw new VCardBuildException("NameType (" + VCardType.FN.getType() + ") The given name field cannot be left empty.");
            }
            if (names[2] != null) {
                String[] addNames = names[2].split(",");
                for (i = 0; i < addNames.length; ++i) {
                    if (VCardUtils.needsUnEscaping(addNames[i])) {
                        nameFeature.addAdditionalName(VCardUtils.unescapeString(addNames[i]));
                        continue;
                    }
                    nameFeature.addAdditionalName(addNames[i]);
                }
            }
            if (names[3] != null) {
                String[] prefixes = names[3].split(",");
                for (i = 0; i < prefixes.length; ++i) {
                    if (VCardUtils.needsUnEscaping(prefixes[i])) {
                        nameFeature.addHonorificPrefix(VCardUtils.unescapeString(prefixes[i]));
                        continue;
                    }
                    nameFeature.addHonorificPrefix(prefixes[i]);
                }
            }
            if (names[4] != null) {
                String[] suffixes = names[4].split(",");
                for (i = 0; i < suffixes.length; ++i) {
                    if (VCardUtils.needsUnEscaping(suffixes[i])) {
                        nameFeature.addHonorificSuffix(VCardUtils.unescapeString(suffixes[i]));
                        continue;
                    }
                    nameFeature.addHonorificSuffix(suffixes[i]);
                }
            }
            if (group != null) {
                nameFeature.setGroup(group);
            }
            vcard.setName(nameFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("NameType (" + VCardType.N.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseNicknameType(String group, String value, VCardImpl vcard) throws VCardBuildException {
        try {
            NicknameType nicknameFeature = new NicknameType();
            String[] nicknames = value.split(",");
            for (int i = 0; i < nicknames.length; ++i) {
                if (VCardUtils.needsUnEscaping(nicknames[i])) {
                    nicknameFeature.addNickname(VCardUtils.unescapeString(nicknames[i]));
                    continue;
                }
                nicknameFeature.addNickname(nicknames[i]);
            }
            if (group != null) {
                nicknameFeature.setGroup(group);
            }
            vcard.setNicknames(nicknameFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("NicknameType (" + VCardType.NICKNAME.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePhotoType(String group, String value, String paramTypes, VCardImpl vcard) throws VCardBuildException {
        try {
            PhotoType photoFeature = new PhotoType();
            String[] params = paramTypes.split(";");
            boolean isBinary = false;
            block15: for (int i = 0; i < params.length; ++i) {
                String[] paramType = null;
                switch (this.getCompatibilityMode()) {
                    case I_PHONE: 
                    case MAC_ADDRESS_BOOK: {
                        if (params[i].contains("=")) {
                            paramType = params[i].trim().split("=");
                            break;
                        }
                        if (params[i].equals(EncodingType.BASE64.getType())) {
                            paramType = new String[]{PhotoParameterType.ENCODING.getTypeName(), params[i]};
                            break;
                        }
                        if (params[i].equals(EncodingType.BINARY.getType())) {
                            paramType = new String[]{PhotoParameterType.ENCODING.getTypeName(), params[i]};
                            break;
                        }
                        if (params[i].equals("URI")) {
                            paramType = new String[]{PhotoParameterType.VALUE.getTypeName(), params[i]};
                            break;
                        }
                        paramType = new String[]{PhotoParameterType.TYPE.getTypeName(), params[i]};
                        break;
                    }
                    default: {
                        paramType = params[i].contains("=") ? params[i].trim().split("=") : new String[]{PhotoParameterType.TYPE.getTypeName(), params[i]};
                    }
                }
                PhotoParameterType photoParamType = PhotoParameterType.valueOf(paramType[0]);
                switch (photoParamType) {
                    case ENCODING: {
                        if (paramType[1].compareToIgnoreCase(EncodingType.BINARY.getType()) == 0) {
                            photoFeature.setEncodingType(EncodingType.BINARY);
                            isBinary = true;
                            continue block15;
                        }
                        if (paramType[1].compareToIgnoreCase(EncodingType.BASE64.getType()) == 0) {
                            photoFeature.setEncodingType(EncodingType.BINARY);
                            isBinary = true;
                            continue block15;
                        }
                        throw new VCardBuildException("PhotoType (" + VCardType.PHOTO.getType() + ") Invalid encoding type \"" + paramType[1] + "\"");
                    }
                    case TYPE: {
                        ImageMediaType mediaType = null;
                        try {
                            mediaType = ImageMediaType.valueOf(paramType[1]);
                            photoFeature.setImageMediaType(mediaType);
                            continue block15;
                        }
                        catch (IllegalArgumentException iae) {
                            mediaType = ImageMediaType.NON_STANDARD;
                            mediaType.setTypeName(paramType[1].trim());
                            mediaType.setIanaRegisteredName(paramType[1].trim());
                            mediaType.setExtension(paramType[1].trim());
                            continue block15;
                        }
                        finally {
                            photoFeature.setImageMediaType(mediaType);
                        }
                    }
                    case VALUE: {
                        if (paramType[1].compareToIgnoreCase("URI") == 0) {
                            photoFeature.setEncodingType(EncodingType.EIGHT_BIT);
                            isBinary = false;
                            continue block15;
                        }
                        throw new VCardBuildException("PhotoType (" + VCardType.PHOTO.getType() + ") Invalid value type \"" + paramType[1] + "\"");
                    }
                }
            }
            if (isBinary) {
                byte[] photoBytes = Base64Wrapper.decode(value);
                photoFeature.setCompression(true);
                photoFeature.setPhoto(photoBytes);
            } else {
                URI photoUri = new URI(value);
                photoFeature.setPhotoURI(photoUri);
            }
            if (group != null) {
                photoFeature.setGroup(group);
            }
            vcard.addPhoto(photoFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("PhotoType (" + VCardType.PHOTO.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseBDayType(String group, String value, VCardImpl vcard) throws VCardBuildException {
        try {
            BirthdayType birthdayFeature = new BirthdayType();
            if (value.matches("\\d\\d\\d\\d-\\d\\d-\\d\\d")) {
                String[] date = value.split("-");
                Calendar cal = Calendar.getInstance();
                cal.clear();
                cal.set(1, Integer.parseInt(date[0]));
                cal.set(2, Integer.parseInt(date[1]) - 1);
                cal.set(5, Integer.parseInt(date[2]));
                birthdayFeature.setBirthday(cal);
            } else if (value.matches("\\d\\d\\d\\d\\d\\d\\d\\d")) {
                String year = value.substring(0, 4);
                String month = value.substring(4, 6);
                String day = value.substring(6);
                Calendar cal = Calendar.getInstance();
                cal.clear();
                cal.set(1, Integer.parseInt(year));
                cal.set(2, Integer.parseInt(month) - 1);
                cal.set(5, Integer.parseInt(day));
                birthdayFeature.setBirthday(cal);
            } else if (value.matches("\\d\\d\\d\\d\\d\\d\\d\\dT\\d\\d\\d\\d\\d\\dZ")) {
                String year = value.substring(0, 4);
                String month = value.substring(4, 6);
                String day = value.substring(6, 8);
                String hour = value.substring(9, 11);
                String minute = value.substring(11, 13);
                String seconds = value.substring(13, 15);
                Calendar cal = Calendar.getInstance();
                cal.clear();
                cal.set(1, Integer.parseInt(year));
                cal.set(2, Integer.parseInt(month) - 1);
                cal.set(5, Integer.parseInt(day));
                cal.set(11, Integer.parseInt(hour));
                cal.set(12, Integer.parseInt(minute));
                cal.set(13, Integer.parseInt(seconds));
                birthdayFeature.setBirthday(cal);
            } else if (value.matches("\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d\\:\\d\\d\\:\\d\\dZ")) {
                String[] split = value.toUpperCase().substring(0, value.indexOf(90)).split("T");
                String[] date = split[0].split("-");
                String[] time = split[1].split(":");
                Calendar cal = Calendar.getInstance();
                cal.clear();
                cal.set(1, Integer.parseInt(date[0]));
                cal.set(2, Integer.parseInt(date[1]) - 1);
                cal.set(5, Integer.parseInt(date[2]));
                cal.set(11, Integer.parseInt(time[0]));
                cal.set(12, Integer.parseInt(time[1]));
                cal.set(13, Integer.parseInt(time[2]));
                birthdayFeature.setBirthday(cal);
            } else if (value.matches("\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d\\:\\d\\d\\:\\d\\d[-\\+]\\d\\d\\:\\d\\d")) {
                String[] split = value.toUpperCase().split("T");
                String[] date = split[0].split("-");
                String time = split[1];
                String hour = time.substring(0, 2);
                String minute = time.substring(3, 5);
                String seconds = time.substring(6, 8);
                String operator = time.substring(8, 9);
                String offsHour = time.substring(9, 11);
                String offsMinute = time.substring(12);
                Calendar cal = Calendar.getInstance();
                cal.clear();
                cal.set(1, Integer.parseInt(date[0]));
                cal.set(2, Integer.parseInt(date[1]) - 1);
                cal.set(5, Integer.parseInt(date[2]));
                cal.set(11, Integer.parseInt(hour));
                cal.set(12, Integer.parseInt(minute));
                cal.set(13, Integer.parseInt(seconds));
                if (operator.compareTo("-") == 0) {
                    offsHour = "-" + offsHour;
                }
                int offsetMillis = Integer.parseInt(offsHour) + Integer.parseInt(offsMinute) / 10;
                offsetMillis = offsetMillis * 60 * 60 * 1000;
                cal.set(15, offsetMillis);
                birthdayFeature.setBirthday(cal);
            } else {
                throw new VCardBuildException("BirthdayType (" + VCardType.BDAY.getType() + ") Birthday value is not a valid ISO-8601 text.");
            }
            if (group != null) {
                birthdayFeature.setGroup(group);
            }
            vcard.setBirthday(birthdayFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("BirthdayType (" + VCardType.BDAY.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseAdrType(String group, String value, String paramTypes, VCardImpl vcard) throws VCardBuildException {
        try {
            AddressType addressFeature = new AddressType();
            if (paramTypes != null) {
                int i;
                String[] list;
                if (paramTypes.indexOf(59) != -1) {
                    list = paramTypes.split(";");
                    for (i = 0; i < list.length; ++i) {
                        String paramType = list[i];
                        String paramValue = null;
                        paramValue = paramType.toUpperCase().contains("TYPE") ? paramType.substring(paramType.indexOf(61) + 1) : paramType;
                        try {
                            AddressParameterType addrParamType = AddressParameterType.valueOf(paramValue);
                            addressFeature.addAddressParameterType(addrParamType);
                            continue;
                        }
                        catch (IllegalArgumentException iae) {
                            XAddressParameterType xAddrType = null;
                            if (paramValue.indexOf(61) != -1) {
                                String[] pTmp = paramValue.split("=");
                                xAddrType = new XAddressParameterType(pTmp[0], pTmp[1]);
                                pTmp[0] = null;
                                pTmp[1] = null;
                            } else {
                                xAddrType = new XAddressParameterType(paramValue);
                            }
                            addressFeature.addExtendedAddressParameterType(xAddrType);
                        }
                    }
                } else {
                    list = paramTypes.substring(paramTypes.indexOf(61) + 1).split(",");
                    for (i = 0; i < list.length; ++i) {
                        String paramValue = list[i];
                        try {
                            AddressParameterType addrParamType = AddressParameterType.valueOf(paramValue);
                            addressFeature.addAddressParameterType(addrParamType);
                            continue;
                        }
                        catch (IllegalArgumentException iae) {
                            XAddressParameterType xAddrType = null;
                            if (paramValue.indexOf(61) != -1) {
                                String[] pTmp = paramValue.split("=");
                                xAddrType = new XAddressParameterType(pTmp[0], pTmp[1]);
                                pTmp[0] = null;
                                pTmp[1] = null;
                            } else {
                                xAddrType = new XAddressParameterType(paramValue);
                            }
                            addressFeature.addExtendedAddressParameterType(xAddrType);
                        }
                    }
                }
            }
            String[] address = value.split(";", 7);
            String postOfficeBox = address[0];
            String extendedAddress = address[1];
            String streetAddress = address[2];
            String locality = address[3];
            String region = address[4];
            String postalCode = address[5];
            String countryName = address[6];
            if (postOfficeBox != null) {
                if (VCardUtils.needsUnEscaping(postOfficeBox)) {
                    addressFeature.setPostOfficeBox(VCardUtils.unescapeString(postOfficeBox));
                } else {
                    addressFeature.setPostOfficeBox(postOfficeBox);
                }
            }
            if (extendedAddress != null) {
                if (VCardUtils.needsUnEscaping(extendedAddress)) {
                    addressFeature.setExtendedAddress(VCardUtils.unescapeString(extendedAddress));
                } else {
                    addressFeature.setExtendedAddress(extendedAddress);
                }
            }
            if (streetAddress != null) {
                if (VCardUtils.needsUnEscaping(streetAddress)) {
                    addressFeature.setStreetAddress(VCardUtils.unescapeString(streetAddress));
                } else {
                    addressFeature.setStreetAddress(streetAddress);
                }
            }
            if (locality != null) {
                if (VCardUtils.needsUnEscaping(locality)) {
                    addressFeature.setLocality(VCardUtils.unescapeString(locality));
                } else {
                    addressFeature.setLocality(locality);
                }
            }
            if (region != null) {
                if (VCardUtils.needsUnEscaping(region)) {
                    addressFeature.setRegion(VCardUtils.unescapeString(region));
                } else {
                    addressFeature.setRegion(region);
                }
            }
            if (postalCode != null) {
                if (VCardUtils.needsUnEscaping(postalCode)) {
                    addressFeature.setPostalCode(VCardUtils.unescapeString(postalCode));
                } else {
                    addressFeature.setPostalCode(postalCode);
                }
            }
            if (countryName != null) {
                if (VCardUtils.needsUnEscaping(countryName)) {
                    addressFeature.setCountryName(VCardUtils.unescapeString(countryName));
                } else {
                    addressFeature.setCountryName(countryName);
                }
            }
            if (group != null) {
                addressFeature.setGroup(group);
            }
            vcard.addAddress(addressFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("AddressType (" + VCardType.ADR.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseLabelType(String group, String value, String paramTypes, VCardImpl vcard) throws VCardBuildException {
        try {
            LabelType labelFeature = new LabelType();
            if (paramTypes != null) {
                int i;
                String[] list;
                if (paramTypes.indexOf(59) != -1) {
                    list = paramTypes.split(";");
                    for (i = 0; i < list.length; ++i) {
                        String paramType = list[i];
                        String paramValue = null;
                        paramValue = paramType.toUpperCase().contains("TYPE") ? paramType.substring(paramType.indexOf(61) + 1) : paramType;
                        try {
                            LabelParameterType labelParamType = LabelParameterType.valueOf(paramValue);
                            labelFeature.addLabelParameterType(labelParamType);
                            continue;
                        }
                        catch (IllegalArgumentException iae) {
                            XLabelParameterType xLabelType = null;
                            if (paramValue.indexOf(61) != -1) {
                                String[] pTmp = paramValue.split("=");
                                xLabelType = new XLabelParameterType(pTmp[0], pTmp[1]);
                                pTmp[0] = null;
                                pTmp[1] = null;
                            } else {
                                xLabelType = new XLabelParameterType(paramValue);
                            }
                            labelFeature.addExtendedLabelParameterType(xLabelType);
                        }
                    }
                } else {
                    list = paramTypes.substring(paramTypes.indexOf(61) + 1).split(",");
                    for (i = 0; i < list.length; ++i) {
                        String paramValue = list[i];
                        try {
                            LabelParameterType labelParamType = LabelParameterType.valueOf(paramValue);
                            labelFeature.addLabelParameterType(labelParamType);
                            continue;
                        }
                        catch (IllegalArgumentException iae) {
                            XLabelParameterType xLabelType = null;
                            if (paramValue.indexOf(61) != -1) {
                                String[] pTmp = paramValue.split("=");
                                xLabelType = new XLabelParameterType(pTmp[0], pTmp[1]);
                                pTmp[0] = null;
                                pTmp[1] = null;
                            } else {
                                xLabelType = new XLabelParameterType(paramValue);
                            }
                            labelFeature.addExtendedLabelParameterType(xLabelType);
                        }
                    }
                }
            }
            if (VCardUtils.needsUnEscaping(value)) {
                labelFeature.setLabel(VCardUtils.unescapeString(value));
            } else {
                labelFeature.setLabel(value);
            }
            if (group != null) {
                labelFeature.setGroup(group);
            }
            boolean match = false;
            Iterator<AddressFeature> addrIter = vcard.getAddresses();
            while (addrIter.hasNext() && !match) {
                AddressFeature addr = addrIter.next();
                List<AddressParameterType> aPrmList = addr.getAddressParameterTypesList();
                List<XAddressParameterType> aXPrmList = addr.getExtendedAddressParameterTypesList();
                Iterator<LabelParameterType> lPrmIter = labelFeature.getLabelParameterTypes();
                Iterator<XLabelParameterType> lXPrmIter = labelFeature.getExtendedLabelParameterTypes();
                int paramsMatched = 0;
                while (lPrmIter.hasNext()) {
                    LabelParameterType labelParamType = lPrmIter.next();
                    for (int i = 0; i < aPrmList.size(); ++i) {
                        if (!aPrmList.get(i).getType().equals(labelParamType.getType())) continue;
                        ++paramsMatched;
                    }
                }
                int xparamsMatched = 0;
                while (lXPrmIter.hasNext()) {
                    XLabelParameterType xlabelParamType = lXPrmIter.next();
                    for (int i = 0; i < aXPrmList.size(); ++i) {
                        if (!aXPrmList.get(i).getType().equals(xlabelParamType.getType())) continue;
                        ++xparamsMatched;
                    }
                }
                if (paramsMatched != labelFeature.getLabelParameterSize() || xparamsMatched != labelFeature.getExtendedLabelParameterSize()) continue;
                if (!vcard.hasLabel(addr)) {
                    vcard.setLabel(labelFeature, addr);
                } else {
                    vcard.addError("Label with duplicate parameter tpyes was detected and ignored. Label -> " + ((Object)labelFeature).toString(), ErrorSeverity.WARNING, new VCardBuildException("Duplicate label"));
                }
                match = true;
            }
        }
        catch (Exception ex) {
            throw new VCardBuildException("LabelType (" + VCardType.LABEL.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseTelType(String group, String value, String paramTypes, VCardImpl vcard) throws VCardBuildException {
        try {
            TelephoneType telephoneFeature = new TelephoneType();
            if (paramTypes != null) {
                if (paramTypes.indexOf(59) != -1) {
                    String[] list = paramTypes.split(";");
                    for (int i = 0; i < list.length; ++i) {
                        String paramType = list[i];
                        String paramValue = null;
                        paramValue = paramType.toUpperCase().contains("TYPE") ? paramType.substring(paramType.indexOf(61) + 1) : paramType;
                        try {
                            TelephoneParameterType telephoneParamType = TelephoneParameterType.valueOf(paramValue);
                            telephoneFeature.addTelephoneParameterType(telephoneParamType);
                            continue;
                        }
                        catch (IllegalArgumentException iae) {
                            XTelephoneParameterType xTelType = null;
                            if (paramValue.indexOf(61) != -1) {
                                String[] pTmp = paramValue.split("=");
                                xTelType = new XTelephoneParameterType(pTmp[0], pTmp[1]);
                                pTmp[0] = null;
                                pTmp[1] = null;
                            } else {
                                xTelType = new XTelephoneParameterType(paramValue);
                            }
                            telephoneFeature.addExtendedTelephoneParameterType(xTelType);
                        }
                    }
                } else {
                    String[] list = paramTypes.substring(paramTypes.indexOf(61) + 1).split(",");
                    for (int i = 0; i < list.length; ++i) {
                        String paramValue = list[i];
                        try {
                            TelephoneParameterType telephoneParamType = TelephoneParameterType.valueOf(paramValue);
                            telephoneFeature.addTelephoneParameterType(telephoneParamType);
                            continue;
                        }
                        catch (IllegalArgumentException iae) {
                            XTelephoneParameterType xTelType = null;
                            if (paramValue.indexOf(61) != -1) {
                                String[] pTmp = paramValue.split("=");
                                xTelType = new XTelephoneParameterType(pTmp[0], pTmp[1]);
                                pTmp[0] = null;
                                pTmp[1] = null;
                            } else {
                                xTelType = new XTelephoneParameterType(paramValue);
                            }
                            telephoneFeature.addExtendedTelephoneParameterType(xTelType);
                        }
                    }
                }
            }
            if (VCardUtils.needsUnEscaping(value)) {
                telephoneFeature.setTelephone(VCardUtils.unescapeString(value));
            } else {
                telephoneFeature.setTelephone(value);
            }
            if (group != null) {
                telephoneFeature.setGroup(group);
            }
            vcard.addTelephoneNumber(telephoneFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("TelephoneType (" + VCardType.TEL.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseEmailType(String group, String value, String paramTypes, VCardImpl vcard) throws VCardBuildException {
        try {
            EmailType emailFeature = new EmailType();
            if (paramTypes != null) {
                if (paramTypes.indexOf(59) != -1) {
                    String[] list = paramTypes.split(";");
                    for (int i = 0; i < list.length; ++i) {
                        String paramType = list[i];
                        String paramValue = null;
                        paramValue = paramType.toUpperCase().contains("TYPE") ? paramType.substring(paramType.indexOf(61) + 1) : paramType;
                        try {
                            EmailParameterType emailParamType = EmailParameterType.valueOf(paramValue);
                            emailFeature.addEmailParameterType(emailParamType);
                            continue;
                        }
                        catch (IllegalArgumentException iae) {
                            XEmailParameterType xEmailType = null;
                            if (paramValue.indexOf(61) != -1) {
                                String[] pTmp = paramValue.split("=");
                                xEmailType = new XEmailParameterType(pTmp[0], pTmp[1]);
                                pTmp[0] = null;
                                pTmp[1] = null;
                            } else {
                                xEmailType = new XEmailParameterType(paramValue);
                            }
                            emailFeature.addExtendedEmailParameterType(xEmailType);
                        }
                    }
                } else {
                    String[] list = paramTypes.substring(paramTypes.indexOf(61) + 1).split(",");
                    for (int i = 0; i < list.length; ++i) {
                        String paramValue = list[i];
                        try {
                            EmailParameterType emailParamType = EmailParameterType.valueOf(paramValue);
                            emailFeature.addEmailParameterType(emailParamType);
                            continue;
                        }
                        catch (IllegalArgumentException iae) {
                            XEmailParameterType xEmailType = null;
                            if (paramValue.indexOf(61) != -1) {
                                String[] pTmp = paramValue.split("=");
                                xEmailType = new XEmailParameterType(pTmp[0], pTmp[1]);
                                pTmp[0] = null;
                                pTmp[1] = null;
                            } else {
                                xEmailType = new XEmailParameterType(paramValue);
                            }
                            emailFeature.addExtendedEmailParameterType(xEmailType);
                        }
                    }
                }
            }
            emailFeature.setEmail(value);
            if (group != null) {
                emailFeature.setGroup(group);
            }
            vcard.addEmail(emailFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("EmailType (" + VCardType.EMAIL.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseMailerType(String group, String value, VCardImpl vcard) throws VCardBuildException {
        try {
            MailerType mailerFeature = new MailerType();
            if (VCardUtils.needsUnEscaping(value)) {
                mailerFeature.setMailer(VCardUtils.unescapeString(value));
            } else {
                mailerFeature.setMailer(value);
            }
            if (group != null) {
                mailerFeature.setGroup(group);
            }
            vcard.setMailer(mailerFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("MailerType (" + VCardType.MAILER.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseTzType(String group, String value, String paramTypes, VCardImpl vcard) throws VCardBuildException {
        try {
            TimeZoneType timeZoneFeature = new TimeZoneType();
            if (paramTypes != null) {
                String paramValue = paramTypes.substring(paramTypes.indexOf(61) + 1);
                if (paramValue.compareToIgnoreCase("TEXT") == 0) {
                    timeZoneFeature.setTextValue(value);
                }
            } else if (value.matches("-?\\d{3,4}")) {
                if (value.startsWith("-")) {
                    String hour = null;
                    String minute = null;
                    if (value.length() == 4) {
                        hour = value.substring(0, 2);
                        minute = value.substring(2);
                    } else if (value.length() == 5) {
                        hour = value.substring(0, 3);
                        minute = value.substring(3);
                    } else {
                        throw new VCardBuildException("TimeZoneType (" + VCardType.TZ.getType() + ") Timezone value is not a valid ISO-8601 text.");
                    }
                    int offsetMillis = Integer.parseInt(hour) + Integer.parseInt(minute) / 10;
                    offsetMillis = offsetMillis * 60 * 60 * 1000;
                    TimeZone tz = TimeZone.getDefault();
                    tz.setRawOffset(offsetMillis);
                    timeZoneFeature.setTimeZone(tz);
                } else {
                    String hour = null;
                    String minute = null;
                    if (value.length() == 3) {
                        hour = value.substring(0, 1);
                        minute = value.substring(1);
                    } else if (value.length() == 4) {
                        hour = value.substring(0, 2);
                        minute = value.substring(2);
                    } else {
                        throw new VCardBuildException("TimeZoneType (" + VCardType.TZ.getType() + ") Timezone value is not a valid ISO-8601 text.");
                    }
                    int offsetMillis = Integer.parseInt(hour) + Integer.parseInt(minute) / 10;
                    offsetMillis = offsetMillis * 60 * 60 * 1000;
                    TimeZone tz = TimeZone.getDefault();
                    tz.setRawOffset(offsetMillis);
                    timeZoneFeature.setTimeZone(tz);
                }
            } else if (value.matches("-?\\d{1,2}:\\d\\d")) {
                String[] split = value.split(":");
                String hour = split[0];
                String minute = split[1];
                int offsetMillis = Integer.parseInt(hour) + Integer.parseInt(minute) / 10;
                offsetMillis = offsetMillis * 60 * 60 * 1000;
                TimeZone tz = TimeZone.getDefault();
                tz.setRawOffset(offsetMillis);
                timeZoneFeature.setTimeZone(tz);
            } else {
                throw new VCardBuildException("TimeZoneType (" + VCardType.TZ.getType() + ") Timezone value is not a valid ISO-8601 text.");
            }
            if (group != null) {
                timeZoneFeature.setGroup(group);
            }
            vcard.setTimeZone(timeZoneFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("TimeZoneType (" + VCardType.TZ.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseGeoType(String group, String value, VCardImpl vcard) throws VCardBuildException {
        try {
            GeographicPositionType geographicPositionFeature = new GeographicPositionType();
            if (value.matches("-?\\d{1,3}\\.\\d{1,6}\\;-?\\d{1,3}\\.\\d{1,6}")) {
                String[] geo = value.split(";");
                String lat = geo[0];
                String lon = geo[1];
                geographicPositionFeature.setLatitude(Float.parseFloat(lat));
                geographicPositionFeature.setLongitude(Float.parseFloat(lon));
                if (group != null) {
                    geographicPositionFeature.setGroup(group);
                }
            } else {
                throw new VCardBuildException("GeographicPositionType (" + VCardType.GEO.getType() + ") GeographicPositionType is not valid.");
            }
            vcard.setGeographicPosition(geographicPositionFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("GeographicPositionType (" + VCardType.GEO.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseTitleType(String group, String value, VCardImpl vcard) throws VCardBuildException {
        try {
            TitleType titleFeature = new TitleType();
            if (VCardUtils.needsUnEscaping(value)) {
                titleFeature.setTitle(VCardUtils.unescapeString(value));
            } else {
                titleFeature.setTitle(value);
            }
            if (group != null) {
                titleFeature.setGroup(group);
            }
            vcard.setTitle(titleFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("TitleType (" + VCardType.TITLE.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseRoleType(String group, String value, VCardImpl vcard) throws VCardBuildException {
        try {
            RoleType roleFeature = new RoleType();
            if (VCardUtils.needsUnEscaping(value)) {
                roleFeature.setRole(VCardUtils.unescapeString(value));
            } else {
                roleFeature.setRole(value);
            }
            if (group != null) {
                roleFeature.setGroup(group);
            }
            vcard.setRole(roleFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("RoleType (" + VCardType.ROLE.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseLogoType(String group, String value, String paramTypes, VCardImpl vcard) throws VCardBuildException {
        try {
            LogoType logoFeature = new LogoType();
            String[] params = paramTypes.split(";");
            boolean isBinary = false;
            block15: for (int i = 0; i < params.length; ++i) {
                String[] paramType = null;
                switch (this.getCompatibilityMode()) {
                    case I_PHONE: 
                    case MAC_ADDRESS_BOOK: {
                        if (params[i].contains("=")) {
                            paramType = params[i].trim().split("=");
                            break;
                        }
                        if (params[i].equals(EncodingType.BASE64.getType())) {
                            paramType = new String[]{PhotoParameterType.ENCODING.getTypeName(), params[i]};
                            break;
                        }
                        if (params[i].equals(EncodingType.BINARY.getType())) {
                            paramType = new String[]{PhotoParameterType.ENCODING.getTypeName(), params[i]};
                            break;
                        }
                        if (params[i].equals("URI")) {
                            paramType = new String[]{PhotoParameterType.VALUE.getTypeName(), params[i]};
                            break;
                        }
                        paramType = new String[]{PhotoParameterType.TYPE.getTypeName(), params[i]};
                        break;
                    }
                    default: {
                        paramType = params[i].contains("=") ? params[i].trim().split("=") : new String[]{PhotoParameterType.TYPE.getTypeName(), params[i]};
                    }
                }
                LogoParameterType logoParamType = LogoParameterType.valueOf(paramType[0]);
                switch (logoParamType) {
                    case ENCODING: {
                        if (paramType[1].compareToIgnoreCase(EncodingType.BINARY.getType()) == 0) {
                            logoFeature.setEncodingType(EncodingType.BINARY);
                            isBinary = true;
                            continue block15;
                        }
                        if (paramType[1].compareToIgnoreCase(EncodingType.BASE64.getType()) == 0) {
                            logoFeature.setEncodingType(EncodingType.BINARY);
                            isBinary = true;
                            continue block15;
                        }
                        throw new VCardBuildException("LogoType (" + VCardType.LOGO.getType() + ") Invalid encoding type \"" + paramType[1] + "\"");
                    }
                    case TYPE: {
                        ImageMediaType mediaType = null;
                        try {
                            mediaType = ImageMediaType.valueOf(paramType[1]);
                            logoFeature.setImageMediaType(mediaType);
                            continue block15;
                        }
                        catch (IllegalArgumentException iae) {
                            mediaType = ImageMediaType.NON_STANDARD;
                            mediaType.setTypeName(paramType[1].trim());
                            mediaType.setIanaRegisteredName(paramType[1].trim());
                            mediaType.setExtension(paramType[1].trim());
                            continue block15;
                        }
                        finally {
                            logoFeature.setImageMediaType(mediaType);
                        }
                    }
                    case VALUE: {
                        if (paramType[1].compareToIgnoreCase("URI") == 0) {
                            logoFeature.setEncodingType(EncodingType.EIGHT_BIT);
                            isBinary = false;
                            continue block15;
                        }
                        throw new VCardBuildException("LogoType (" + VCardType.LOGO.getType() + ") Invalid value type \"" + paramType[1] + "\"");
                    }
                }
            }
            if (isBinary) {
                byte[] logoBytes = Base64Wrapper.decode(value);
                logoFeature.setCompression(true);
                logoFeature.setLogo(logoBytes);
            } else {
                URI logoUri = new URI(value);
                logoFeature.setLogoURI(logoUri);
            }
            if (group != null) {
                logoFeature.setGroup(group);
            }
            vcard.addLogo(logoFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("LogoType (" + VCardType.LOGO.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseOrgType(String group, String value, VCardImpl vcard) throws VCardBuildException {
        try {
            OrganizationType organizationFeature = new OrganizationType();
            if (value.contains("\\;")) {
                value = value.replaceAll("\\\\;", "!SEMI!");
            }
            String[] orgs = value.split(";");
            for (int i = 0; i < orgs.length; ++i) {
                if (VCardUtils.needsUnEscaping(orgs[i])) {
                    String unesc = VCardUtils.unescapeString(orgs[i]);
                    organizationFeature.addOrganization(unesc.replaceAll("\\!SEMI\\!", ";"));
                    continue;
                }
                organizationFeature.addOrganization(orgs[i].replaceAll("\\!SEMI\\!", ";"));
            }
            if (group != null) {
                organizationFeature.setGroup(group);
            }
            vcard.setOrganizations(organizationFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("OrganizationType (" + VCardType.ORG.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseCategoriesType(String group, String value, VCardImpl vcard) throws VCardBuildException {
        try {
            CategoriesType categoriesFeature = new CategoriesType();
            String[] categories = null;
            switch (this.compatMode) {
                case KDE_ADDRESS_BOOK: {
                    if (VCardUtils.needsUnEscaping(value)) {
                        categories = VCardUtils.unescapeString(value).split(",");
                        break;
                    }
                    categories = value.split(",");
                    break;
                }
                default: {
                    if (value.contains("\\,")) {
                        value = value.replaceAll("\\\\,", " ");
                    }
                    categories = value.split(",");
                }
            }
            for (int i = 0; i < categories.length; ++i) {
                if (VCardUtils.needsUnEscaping(categories[i])) {
                    categoriesFeature.addCategory(VCardUtils.unescapeString(categories[i]));
                    continue;
                }
                categoriesFeature.addCategory(categories[i]);
            }
            if (group != null) {
                categoriesFeature.setGroup(group);
            }
            vcard.setCategories(categoriesFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("CategoriesType (" + VCardType.CATEGORIES.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseNoteType(String group, String value, VCardImpl vcard) throws VCardBuildException {
        try {
            NoteType noteFeature = new NoteType();
            if (VCardUtils.needsUnEscaping(value)) {
                noteFeature.setNote(VCardUtils.unescapeString(value));
            } else {
                noteFeature.setNote(value);
            }
            if (group != null) {
                noteFeature.setGroup(group);
            }
            vcard.addNote(noteFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("NoteType (" + VCardType.NOTE.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseProdidType(String group, String value, VCardImpl vcard) throws VCardBuildException {
        try {
            ProductIdType productIdFeature = new ProductIdType();
            productIdFeature.setProductId(value);
            if (group != null) {
                productIdFeature.setGroup(group);
            }
            vcard.setProductId(productIdFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("ProductIdType (" + VCardType.PRODID.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseRevType(String group, String value, VCardImpl vcard) throws VCardBuildException {
        try {
            RevisionType revisionFeature = new RevisionType();
            if (value.matches("\\d\\d\\d\\d-\\d\\d-\\d\\d")) {
                String[] date = value.split("-");
                Calendar cal = Calendar.getInstance();
                cal.clear();
                cal.set(1, Integer.parseInt(date[0]));
                cal.set(2, Integer.parseInt(date[1]) - 1);
                cal.set(5, Integer.parseInt(date[2]));
                revisionFeature.setRevision(cal);
            } else if (value.matches("\\d\\d\\d\\d\\d\\d\\d\\d")) {
                String year = value.substring(0, 4);
                String month = value.substring(4, 6);
                String day = value.substring(6);
                Calendar cal = Calendar.getInstance();
                cal.clear();
                cal.set(1, Integer.parseInt(year));
                cal.set(2, Integer.parseInt(month) - 1);
                cal.set(5, Integer.parseInt(day));
                revisionFeature.setRevision(cal);
            } else if (value.matches("\\d\\d\\d\\d\\d\\d\\d\\dT\\d\\d\\d\\d\\d\\dZ")) {
                String year = value.substring(0, 4);
                String month = value.substring(4, 6);
                String day = value.substring(6, 8);
                String hour = value.substring(9, 11);
                String minute = value.substring(11, 13);
                String seconds = value.substring(13, 15);
                Calendar cal = Calendar.getInstance();
                cal.clear();
                cal.set(1, Integer.parseInt(year));
                cal.set(2, Integer.parseInt(month) - 1);
                cal.set(5, Integer.parseInt(day));
                cal.set(11, Integer.parseInt(hour));
                cal.set(12, Integer.parseInt(minute));
                cal.set(13, Integer.parseInt(seconds));
                revisionFeature.setRevision(cal);
            } else if (value.matches("\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d\\:\\d\\d\\:\\d\\dZ")) {
                String[] split = value.toUpperCase().substring(0, value.indexOf(90)).split("T");
                String[] date = split[0].split("-");
                String[] time = split[1].split(":");
                Calendar cal = Calendar.getInstance();
                cal.clear();
                cal.set(1, Integer.parseInt(date[0]));
                cal.set(2, Integer.parseInt(date[1]) - 1);
                cal.set(5, Integer.parseInt(date[2]));
                cal.set(11, Integer.parseInt(time[0]));
                cal.set(12, Integer.parseInt(time[1]));
                cal.set(13, Integer.parseInt(time[2]));
                revisionFeature.setRevision(cal);
            } else if (value.matches("\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d\\:\\d\\d\\:\\d\\d[-\\+]\\d\\d\\:\\d\\d")) {
                String[] split = value.toUpperCase().split("T");
                String[] date = split[0].split("-");
                String time = split[1];
                String hour = time.substring(0, 2);
                String minute = time.substring(3, 5);
                String seconds = time.substring(6, 8);
                String operator = time.substring(8, 9);
                String offsHour = time.substring(9, 11);
                String offsMinute = time.substring(12);
                Calendar cal = Calendar.getInstance();
                cal.clear();
                cal.set(1, Integer.parseInt(date[0]));
                cal.set(2, Integer.parseInt(date[1]) - 1);
                cal.set(5, Integer.parseInt(date[2]));
                cal.set(11, Integer.parseInt(hour));
                cal.set(12, Integer.parseInt(minute));
                cal.set(13, Integer.parseInt(seconds));
                if (operator.compareTo("-") == 0) {
                    offsHour = "-" + offsHour;
                }
                int offsetMillis = Integer.parseInt(offsHour) + Integer.parseInt(offsMinute) / 10;
                offsetMillis = offsetMillis * 60 * 60 * 1000;
                cal.set(15, offsetMillis);
                revisionFeature.setRevision(cal);
            } else {
                throw new VCardBuildException("RevisionType (" + VCardType.REV.getType() + ") Revision value is not a valid ISO-8601 text.");
            }
            if (group != null) {
                revisionFeature.setGroup(group);
            }
            vcard.setRevision(revisionFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("RevisionType (" + VCardType.REV.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseSortStringType(String group, String value, VCardImpl vcard) throws VCardBuildException {
        try {
            SortStringType sortStringFeature = new SortStringType();
            sortStringFeature.setSortString(value);
            if (group != null) {
                sortStringFeature.setGroup(group);
            }
            vcard.setSortString(sortStringFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("SortStringType (" + VCardType.SORT_STRING.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSoundType(String group, String value, String paramTypes, VCardImpl vcard) throws VCardBuildException {
        try {
            SoundType soundFeature = new SoundType();
            String[] params = paramTypes.split(";");
            boolean isBinary = false;
            block15: for (int i = 0; i < params.length; ++i) {
                String[] paramType = null;
                switch (this.getCompatibilityMode()) {
                    case I_PHONE: 
                    case MAC_ADDRESS_BOOK: {
                        if (params[i].contains("=")) {
                            paramType = params[i].trim().split("=");
                            break;
                        }
                        if (params[i].equals(EncodingType.BASE64.getType())) {
                            paramType = new String[]{PhotoParameterType.ENCODING.getTypeName(), params[i]};
                            break;
                        }
                        if (params[i].equals(EncodingType.BINARY.getType())) {
                            paramType = new String[]{PhotoParameterType.ENCODING.getTypeName(), params[i]};
                            break;
                        }
                        if (params[i].equals("URI")) {
                            paramType = new String[]{PhotoParameterType.VALUE.getTypeName(), params[i]};
                            break;
                        }
                        paramType = new String[]{PhotoParameterType.TYPE.getTypeName(), params[i]};
                        break;
                    }
                    default: {
                        paramType = params[i].contains("=") ? params[i].trim().split("=") : new String[]{PhotoParameterType.TYPE.getTypeName(), params[i]};
                    }
                }
                SoundParameterType soundParamType = SoundParameterType.valueOf(paramType[0]);
                switch (soundParamType) {
                    case ENCODING: {
                        if (paramType[1].compareToIgnoreCase(EncodingType.BINARY.getType()) == 0) {
                            soundFeature.setEncodingType(EncodingType.BINARY);
                            isBinary = true;
                            continue block15;
                        }
                        if (paramType[1].compareToIgnoreCase(EncodingType.BASE64.getType()) == 0) {
                            soundFeature.setEncodingType(EncodingType.BINARY);
                            isBinary = true;
                            continue block15;
                        }
                        throw new VCardBuildException("SoundType (" + VCardType.SOUND.getType() + ") Invalid encoding type \"" + paramType[1] + "\"");
                    }
                    case TYPE: {
                        AudioMediaType mediaType = null;
                        try {
                            mediaType = AudioMediaType.valueOf(paramType[1]);
                            soundFeature.setAudioMediaType(mediaType);
                            continue block15;
                        }
                        catch (IllegalArgumentException iae) {
                            mediaType = AudioMediaType.NON_STANDARD;
                            mediaType.setTypeName(paramType[1].trim());
                            mediaType.setIanaRegisteredName(paramType[1].trim());
                            mediaType.setExtension(paramType[1].trim());
                            continue block15;
                        }
                        finally {
                            soundFeature.setAudioMediaType(mediaType);
                        }
                    }
                    case VALUE: {
                        if (paramType[1].compareToIgnoreCase("URI") == 0) {
                            soundFeature.setEncodingType(EncodingType.EIGHT_BIT);
                            isBinary = false;
                            continue block15;
                        }
                        throw new VCardBuildException("SoundType (" + VCardType.SOUND.getType() + ") Invalid value type \"" + paramType[1] + "\"");
                    }
                }
            }
            if (isBinary) {
                byte[] soundBytes = Base64Wrapper.decode(value);
                soundFeature.setCompression(true);
                soundFeature.setSound(soundBytes);
            } else {
                URI soundUri = new URI(value);
                soundFeature.setSoundURI(soundUri);
            }
            if (group != null) {
                soundFeature.setGroup(group);
            }
            vcard.addSound(soundFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("SoundType (" + VCardType.SOUND.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseUidType(String group, String value, VCardImpl vcard) throws VCardBuildException {
        try {
            UIDType uidFeature = new UIDType();
            uidFeature.setUID(value);
            if (group != null) {
                uidFeature.setGroup(group);
            }
            vcard.setUID(uidFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("UIDType (" + VCardType.UID.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseUrlType(String group, String value, VCardImpl vcard) throws VCardBuildException {
        try {
            URLType urlFeature = new URLType();
            if (VCardUtils.needsUnEscaping(value)) {
                urlFeature.setURL(new URL(VCardUtils.unescapeString(value)));
            } else {
                urlFeature.setURL(new URL(value));
            }
            if (group != null) {
                urlFeature.setGroup(group);
            }
            vcard.addURL(urlFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("URLType (" + VCardType.URL.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseClassType(String group, String value, VCardImpl vcard) throws VCardBuildException {
        try {
            ClassType classFeature = new ClassType();
            classFeature.setSecurityClass(value);
            if (group != null) {
                classFeature.setGroup(group);
            }
            vcard.setSecurityClass(classFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("ClassType (" + VCardType.CLASS.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseKeyType(String group, String value, String paramTypes, VCardImpl vcard) throws VCardBuildException {
        try {
            KeyType keyFeature = new KeyType();
            String[] params = paramTypes.split(";");
            block14: for (int i = 0; i < params.length; ++i) {
                String[] paramType = null;
                switch (this.getCompatibilityMode()) {
                    case I_PHONE: 
                    case MAC_ADDRESS_BOOK: {
                        if (params[i].contains("=")) {
                            paramType = params[i].trim().split("=");
                            break;
                        }
                        if (params[i].equals(EncodingType.BASE64.getType())) {
                            paramType = new String[]{PhotoParameterType.ENCODING.getTypeName(), params[i]};
                            break;
                        }
                        if (params[i].equals(EncodingType.BINARY.getType())) {
                            paramType = new String[]{PhotoParameterType.ENCODING.getTypeName(), params[i]};
                            break;
                        }
                        if (params[i].equals("URI")) {
                            paramType = new String[]{PhotoParameterType.VALUE.getTypeName(), params[i]};
                            break;
                        }
                        paramType = new String[]{PhotoParameterType.TYPE.getTypeName(), params[i]};
                        break;
                    }
                    default: {
                        paramType = params[i].contains("=") ? params[i].trim().split("=") : new String[]{KeyParameterType.TYPE.getTypeName(), params[i]};
                    }
                }
                KeyParameterType keyParamType = KeyParameterType.valueOf(paramType[0]);
                switch (keyParamType) {
                    case ENCODING: {
                        if (paramType[1].compareToIgnoreCase(EncodingType.BINARY.getType()) == 0) {
                            keyFeature.setEncodingType(EncodingType.BINARY);
                            continue block14;
                        }
                        if (paramType[1].compareToIgnoreCase(EncodingType.BASE64.getType()) == 0) {
                            keyFeature.setEncodingType(EncodingType.BINARY);
                            continue block14;
                        }
                        throw new VCardBuildException("KeyType (" + VCardType.KEY.getType() + ") Invalid encoding type \"" + paramType[1] + "\"");
                    }
                    case TYPE: {
                        KeyTextType keyTextType = null;
                        try {
                            keyTextType = KeyTextType.valueOf(paramType[1]);
                            keyFeature.setKeyTextType(keyTextType);
                            continue block14;
                        }
                        catch (IllegalArgumentException iae) {
                            keyTextType = KeyTextType.NON_STANDARD;
                            keyTextType.setTypeName(paramType[1].trim());
                            keyTextType.setIanaRegisteredName(paramType[1].trim());
                            keyTextType.setExtension(paramType[1].trim());
                            continue block14;
                        }
                        finally {
                            keyFeature.setKeyTextType(keyTextType);
                        }
                    }
                }
            }
            byte[] keyBytes = Base64Wrapper.decode(value);
            keyFeature.setCompression(true);
            keyFeature.setKey(keyBytes);
            if (group != null) {
                keyFeature.setGroup(group);
            }
            vcard.addKey(keyFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("KeyType (" + VCardType.KEY.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseXtendedType(String group, String value, String typeName, VCardImpl vcard) throws VCardBuildException {
        try {
            ExtendedType extendedFeature = new ExtendedType();
            extendedFeature.setExtensionName(typeName);
            extendedFeature.setExtensionData(value);
            if (group != null) {
                extendedFeature.setGroup(group);
            }
            vcard.addExtendedType(extendedFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("ExtendedType (" + VCardType.XTENDED.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseDisplayableNameType(String group, String value, VCardImpl vcard) throws VCardBuildException {
        try {
            DisplayableNameType displayableNameFeature = new DisplayableNameType();
            displayableNameFeature.setName(value);
            if (group != null) {
                displayableNameFeature.setGroup(group);
            }
            vcard.setDisplayableNameFeature(displayableNameFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("DisplayableNameType (" + VCardType.NAME.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseProfileType(String group, String value, VCardImpl vcard) throws VCardBuildException {
        try {
            ProfileType profileFeature = new ProfileType();
            profileFeature.setProfile(value);
            if (group != null) {
                profileFeature.setGroup(group);
            }
            vcard.setProfile(profileFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("ProfileType (" + VCardType.PROFILE.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void parseSourceType(String group, String value, VCardImpl vcard) throws VCardBuildException {
        try {
            SourceType sourceFeature = new SourceType();
            sourceFeature.setSource(value);
            if (group != null) {
                sourceFeature.setGroup(group);
            }
            vcard.setSource(sourceFeature);
        }
        catch (Exception ex) {
            throw new VCardBuildException("SourceType (" + VCardType.SOURCE.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void handleError(VCardImpl vcard, String errorMessage, Throwable exception, ErrorSeverity severity) {
        VCardError vError = new VCardError();
        vError.setErrorMessage(errorMessage);
        vError.setSeverity(severity);
        if (exception != null) {
            vError.setError(exception);
        }
        vcard.addError(vError);
    }

    private List<String[]> splitLines(String vcardString) {
        String[] strArray = vcardString.split("\n");
        ArrayList<String[]> arrayLines = new ArrayList<String[]>(strArray.length);
        String line = null;
        for (int i = 0; i < strArray.length; ++i) {
            line = strArray[i];
            String[] subLine = line.split(":", 2);
            arrayLines.add(subLine);
        }
        return arrayLines;
    }

    private String getContentFromFile(File vcardFile) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(vcardFile));
        String line = "";
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            if (line.matches("$")) continue;
            sb.append(line);
            sb.append("\n");
        }
        br.close();
        return sb.toString();
    }

    private String getContentFromString(String vcardString) throws IOException {
        BufferedReader br = new BufferedReader(new StringReader(vcardString));
        String line = "";
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            if (line.matches("$")) continue;
            sb.append(line);
            sb.append("\n");
        }
        br.close();
        return sb.toString();
    }
}

