/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.io;

import info.ineighborhood.cardme.io.CompatibilityMode;
import info.ineighborhood.cardme.io.FoldingScheme;
import info.ineighborhood.cardme.util.Base64Wrapper;
import info.ineighborhood.cardme.util.ISOFormat;
import info.ineighborhood.cardme.util.ISOUtils;
import info.ineighborhood.cardme.util.VCardUtils;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCard;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.VCardVersion;
import info.ineighborhood.cardme.vcard.errors.ErrorSeverity;
import info.ineighborhood.cardme.vcard.errors.VCardBuildException;
import info.ineighborhood.cardme.vcard.errors.VCardError;
import info.ineighborhood.cardme.vcard.errors.VCardErrorHandling;
import info.ineighborhood.cardme.vcard.errors.VCardException;
import info.ineighborhood.cardme.vcard.features.AddressFeature;
import info.ineighborhood.cardme.vcard.features.AgentFeature;
import info.ineighborhood.cardme.vcard.features.BeginFeature;
import info.ineighborhood.cardme.vcard.features.BirthdayFeature;
import info.ineighborhood.cardme.vcard.features.CategoriesFeature;
import info.ineighborhood.cardme.vcard.features.ClassFeature;
import info.ineighborhood.cardme.vcard.features.DisplayableNameFeature;
import info.ineighborhood.cardme.vcard.features.EmailFeature;
import info.ineighborhood.cardme.vcard.features.EndFeature;
import info.ineighborhood.cardme.vcard.features.ExtendedFeature;
import info.ineighborhood.cardme.vcard.features.FormattedNameFeature;
import info.ineighborhood.cardme.vcard.features.GeographicPositionFeature;
import info.ineighborhood.cardme.vcard.features.KeyFeature;
import info.ineighborhood.cardme.vcard.features.LabelFeature;
import info.ineighborhood.cardme.vcard.features.LogoFeature;
import info.ineighborhood.cardme.vcard.features.MailerFeature;
import info.ineighborhood.cardme.vcard.features.NameFeature;
import info.ineighborhood.cardme.vcard.features.NicknameFeature;
import info.ineighborhood.cardme.vcard.features.NoteFeature;
import info.ineighborhood.cardme.vcard.features.OrganizationFeature;
import info.ineighborhood.cardme.vcard.features.PhotoFeature;
import info.ineighborhood.cardme.vcard.features.ProductIdFeature;
import info.ineighborhood.cardme.vcard.features.ProfileFeature;
import info.ineighborhood.cardme.vcard.features.RevisionFeature;
import info.ineighborhood.cardme.vcard.features.RoleFeature;
import info.ineighborhood.cardme.vcard.features.SortStringFeature;
import info.ineighborhood.cardme.vcard.features.SoundFeature;
import info.ineighborhood.cardme.vcard.features.SourceFeature;
import info.ineighborhood.cardme.vcard.features.TelephoneFeature;
import info.ineighborhood.cardme.vcard.features.TimeZoneFeature;
import info.ineighborhood.cardme.vcard.features.TitleFeature;
import info.ineighborhood.cardme.vcard.features.UIDFeature;
import info.ineighborhood.cardme.vcard.features.URLFeature;
import info.ineighborhood.cardme.vcard.features.VersionFeature;
import info.ineighborhood.cardme.vcard.types.parameters.AddressParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.EmailParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.LabelParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.TelephoneParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.TimeZoneParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.XAddressParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.XEmailParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.XLabelParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.XTelephoneParameterType;
import java.util.Iterator;

public class VCardWriter {
    private VCard vcard = null;
    private VCardVersion outputVersion = null;
    private FoldingScheme foldingScheme = null;
    private CompatibilityMode compatMode = null;
    private boolean isThrowsExceptions = true;

    public VCardWriter() throws VCardException {
        this(null, null, null);
    }

    public VCardWriter(VCardVersion outputVersion) throws VCardException {
        this(outputVersion, null, null);
    }

    public VCardWriter(VCardVersion outputVersion, FoldingScheme foldingScheme) throws VCardException {
        this(outputVersion, foldingScheme, null);
    }

    public VCardWriter(VCardVersion outputVersion, CompatibilityMode compatMode) throws VCardException {
        this(outputVersion, null, compatMode);
    }

    public VCardWriter(VCardVersion outputVersion, FoldingScheme foldingScheme, CompatibilityMode compatMode) throws VCardException {
        this.setOutputVersion(outputVersion);
        this.setFoldingScheme(foldingScheme);
        this.setCompatibilityMode(compatMode);
    }

    public VCard getVCard() {
        return this.vcard;
    }

    public void setVCard(VCard vcard) throws VCardException {
        if (vcard == null) {
            throw new VCardException("Cannot set a null vcard.");
        }
        this.vcard = vcard;
        if (vcard instanceof VCardErrorHandling) {
            this.isThrowsExceptions = ((VCardErrorHandling)((Object)vcard)).isThrowExceptions();
        }
    }

    public void setOutputVersion(VCardVersion outputVersion) throws VCardException {
        if (outputVersion == null) {
            this.outputVersion = VCardVersion.V3_0;
        } else {
            if (outputVersion == VCardVersion.V2_1 || outputVersion == VCardVersion.V4_0) {
                throw new VCardException("Version " + (Object)((Object)outputVersion) + " not supported.");
            }
            this.outputVersion = outputVersion;
        }
    }

    public void setFoldingScheme(FoldingScheme foldingScheme) {
        this.foldingScheme = foldingScheme == null ? FoldingScheme.MIME_DIR : foldingScheme;
    }

    public void setCompatibilityMode(CompatibilityMode compatMode) {
        this.compatMode = compatMode == null ? CompatibilityMode.RFC2426 : compatMode;
    }

    public String buildVCardString() {
        if (this.vcard == null) {
            throw new VCardException("Cannot build a null VCard.");
        }
        StringBuilder sb = new StringBuilder();
        try {
            this.buildBeginFeature(sb, this.vcard.getBegin());
        }
        catch (VCardBuildException vbe) {
            if (this.isThrowsExceptions) {
                throw new VCardException(vbe.getMessage(), vbe);
            }
            this.handleError(vbe.getMessage(), vbe, ErrorSeverity.FATAL);
        }
        try {
            this.buildVersionFeature(sb, this.vcard.getVersion());
        }
        catch (VCardBuildException vbe) {
            if (this.isThrowsExceptions) {
                throw new VCardException(vbe.getMessage(), vbe);
            }
            this.handleError(vbe.getMessage(), vbe, ErrorSeverity.FATAL);
        }
        try {
            this.buildNameFeature(sb, this.vcard.getName());
        }
        catch (VCardBuildException vbe) {
            if (this.isThrowsExceptions) {
                throw new VCardException(vbe.getMessage(), vbe);
            }
            this.handleError(vbe.getMessage(), vbe, ErrorSeverity.FATAL);
        }
        try {
            this.buildFormattedNameFeature(sb, this.vcard.getFormattedName());
        }
        catch (VCardBuildException vbe) {
            if (this.isThrowsExceptions) {
                throw new VCardException(vbe.getMessage(), vbe);
            }
            this.handleError(vbe.getMessage(), vbe, ErrorSeverity.FATAL);
        }
        if (this.vcard.hasDisplayableNameFeature()) {
            try {
                this.buildDisplayableNameFeature(sb, this.vcard.getDisplayableNameFeature());
            }
            catch (VCardBuildException vbe) {
                if (this.isThrowsExceptions) {
                    throw new VCardException(vbe.getMessage(), vbe);
                }
                this.handleError(vbe.getMessage(), vbe, ErrorSeverity.FATAL);
            }
        }
        if (this.vcard.hasProfile()) {
            try {
                this.buildProfileFeature(sb, this.vcard.getProfile());
            }
            catch (VCardBuildException vbe) {
                if (this.isThrowsExceptions) {
                    throw new VCardException(vbe.getMessage(), vbe);
                }
                this.handleError(vbe.getMessage(), vbe, ErrorSeverity.FATAL);
            }
        }
        if (this.vcard.hasSource()) {
            try {
                this.buildSourceFeature(sb, this.vcard.getSource());
            }
            catch (VCardBuildException vbe) {
                if (this.isThrowsExceptions) {
                    throw new VCardException(vbe.getMessage(), vbe);
                }
                this.handleError(vbe.getMessage(), vbe, ErrorSeverity.FATAL);
            }
        }
        if (this.vcard.hasNicknames()) {
            try {
                this.buildNicknames(sb, this.vcard.getNicknames());
            }
            catch (VCardBuildException vbe) {
                if (this.isThrowsExceptions) {
                    throw new VCardException(vbe.getMessage(), vbe);
                }
                this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
            }
        }
        if (this.vcard.hasTitle()) {
            try {
                this.buildTitleFeature(sb, this.vcard.getTitle());
            }
            catch (VCardBuildException vbe) {
                if (this.isThrowsExceptions) {
                    throw new VCardException(vbe.getMessage(), vbe);
                }
                this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
            }
        }
        if (this.vcard.hasRole()) {
            try {
                this.buildRoleFeature(sb, this.vcard.getRole());
            }
            catch (VCardBuildException vbe) {
                if (this.isThrowsExceptions) {
                    throw new VCardException(vbe.getMessage(), vbe);
                }
                this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
            }
        }
        if (this.vcard.hasGeographicPosition()) {
            try {
                this.buildGeographicPositionFeature(sb, this.vcard.getGeographicPosition());
            }
            catch (VCardBuildException vbe) {
                if (this.isThrowsExceptions) {
                    throw new VCardException(vbe.getMessage(), vbe);
                }
                this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
            }
        }
        if (this.vcard.hasOrganizations()) {
            try {
                this.buildOrganization(sb, this.vcard.getOrganizations());
            }
            catch (VCardBuildException vbe) {
                if (this.isThrowsExceptions) {
                    throw new VCardException(vbe.getMessage(), vbe);
                }
                this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
            }
        }
        if (this.vcard.hasMailer()) {
            try {
                this.buildMailerFeature(sb, this.vcard.getMailer());
            }
            catch (VCardBuildException vbe) {
                if (this.isThrowsExceptions) {
                    throw new VCardException(vbe.getMessage(), vbe);
                }
                this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
            }
        }
        if (this.vcard.hasTimeZone()) {
            try {
                this.buildTimeZoneFeature(sb, this.vcard.getTimeZone());
            }
            catch (VCardBuildException vbe) {
                if (this.isThrowsExceptions) {
                    throw new VCardException(vbe.getMessage(), vbe);
                }
                this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
            }
        }
        if (this.vcard.hasURLs()) {
            Iterator<URLFeature> urls = this.vcard.getURLs();
            while (urls.hasNext()) {
                URLFeature urlFeature = urls.next();
                try {
                    this.buildUrlFeature(sb, urlFeature);
                }
                catch (VCardBuildException vbe) {
                    if (this.isThrowsExceptions) {
                        throw new VCardException(vbe.getMessage(), vbe);
                    }
                    this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
                }
            }
        }
        if (this.vcard.hasRevision()) {
            try {
                this.buildRevisionFeature(sb, this.vcard.getRevision());
            }
            catch (VCardBuildException vbe) {
                if (this.isThrowsExceptions) {
                    throw new VCardException(vbe.getMessage(), vbe);
                }
                this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
            }
        }
        if (this.vcard.hasUID()) {
            try {
                this.buildUidFeature(sb, this.vcard.getUID());
            }
            catch (VCardBuildException vbe) {
                if (this.isThrowsExceptions) {
                    throw new VCardException(vbe.getMessage(), vbe);
                }
                this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
            }
        }
        if (this.vcard.hasBirthday()) {
            try {
                this.buildBirthdayFeature(sb, this.vcard.getBirthDay());
            }
            catch (VCardBuildException vbe) {
                if (this.isThrowsExceptions) {
                    throw new VCardException(vbe.getMessage(), vbe);
                }
                this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
            }
        }
        if (this.vcard.hasAddresses()) {
            Iterator<AddressFeature> addresses = this.vcard.getAddresses();
            while (addresses.hasNext()) {
                AddressFeature address = addresses.next();
                try {
                    this.buildAddressFeature(sb, address);
                }
                catch (VCardBuildException vbe) {
                    if (this.isThrowsExceptions) {
                        throw new VCardException(vbe.getMessage(), vbe);
                    }
                    this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
                }
                if (!this.vcard.hasLabel(address)) continue;
                LabelFeature label = this.vcard.getLabelFor(address);
                try {
                    this.buildLabelFeature(sb, label);
                }
                catch (VCardBuildException vbe) {
                    if (this.isThrowsExceptions) {
                        throw new VCardException(vbe.getMessage(), vbe);
                    }
                    this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
                }
            }
        }
        if (this.vcard.hasTelephoneNumbers()) {
            Iterator<TelephoneFeature> telephones = this.vcard.getTelephoneNumbers();
            while (telephones.hasNext()) {
                TelephoneFeature telephone = telephones.next();
                try {
                    this.buildTelephoneFeature(sb, telephone);
                }
                catch (VCardBuildException vbe) {
                    if (this.isThrowsExceptions) {
                        throw new VCardException(vbe.getMessage(), vbe);
                    }
                    this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
                }
            }
        }
        if (this.vcard.hasEmails()) {
            Iterator<EmailFeature> emails = this.vcard.getEmails();
            while (emails.hasNext()) {
                EmailFeature email = emails.next();
                try {
                    this.buildEmailFeature(sb, email);
                }
                catch (VCardBuildException vbe) {
                    if (this.isThrowsExceptions) {
                        throw new VCardException(vbe.getMessage(), vbe);
                    }
                    this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
                }
            }
        }
        if (this.vcard.hasNotes()) {
            Iterator<NoteFeature> notes = this.vcard.getNotes();
            while (notes.hasNext()) {
                NoteFeature note = notes.next();
                try {
                    this.buildNoteFeature(sb, note);
                }
                catch (VCardBuildException vbe) {
                    if (this.isThrowsExceptions) {
                        throw new VCardException(vbe.getMessage(), vbe);
                    }
                    this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
                }
            }
        }
        if (this.vcard.hasCategories()) {
            try {
                this.buildCategoriesFeature(sb, this.vcard.getCategories());
            }
            catch (VCardBuildException vbe) {
                if (this.isThrowsExceptions) {
                    throw new VCardException(vbe.getMessage(), vbe);
                }
                this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
            }
        }
        if (this.vcard.hasSecurityClass()) {
            try {
                this.buildClassFeature(sb, this.vcard.getSecurityClass());
            }
            catch (VCardBuildException vbe) {
                if (this.isThrowsExceptions) {
                    throw new VCardException(vbe.getMessage(), vbe);
                }
                this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
            }
        }
        if (this.vcard.hasProductId()) {
            try {
                this.buildProductIdFeature(sb, this.vcard.getProductId());
            }
            catch (VCardBuildException vbe) {
                if (this.isThrowsExceptions) {
                    throw new VCardException(vbe.getMessage(), vbe);
                }
                this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
            }
        }
        if (this.vcard.hasSortString()) {
            try {
                this.buildSortStringFeature(sb, this.vcard.getSortString());
            }
            catch (VCardBuildException vbe) {
                if (this.isThrowsExceptions) {
                    throw new VCardException(vbe.getMessage(), vbe);
                }
                this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
            }
        }
        if (this.vcard.hasKeys()) {
            Iterator<KeyFeature> keys = this.vcard.getKeys();
            while (keys.hasNext()) {
                KeyFeature key = keys.next();
                try {
                    this.buildKeyFeature(sb, key);
                }
                catch (VCardBuildException vbe) {
                    if (this.isThrowsExceptions) {
                        throw new VCardException(vbe.getMessage(), vbe);
                    }
                    this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
                }
            }
        }
        if (this.vcard.hasPhotos()) {
            Iterator<PhotoFeature> photos = this.vcard.getPhotos();
            while (photos.hasNext()) {
                PhotoFeature photo = photos.next();
                try {
                    this.buildPhotoFeature(sb, photo);
                }
                catch (VCardBuildException vbe) {
                    if (this.isThrowsExceptions) {
                        throw new VCardException(vbe.getMessage(), vbe);
                    }
                    this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
                }
            }
        }
        if (this.vcard.hasLogos()) {
            Iterator<LogoFeature> logos = this.vcard.getLogos();
            while (logos.hasNext()) {
                LogoFeature logo = logos.next();
                try {
                    this.buildLogoFeature(sb, logo);
                }
                catch (VCardBuildException vbe) {
                    if (this.isThrowsExceptions) {
                        throw new VCardException(vbe.getMessage(), vbe);
                    }
                    this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
                }
            }
        }
        if (this.vcard.hasSounds()) {
            Iterator<SoundFeature> sounds = this.vcard.getSounds();
            while (sounds.hasNext()) {
                SoundFeature sound = sounds.next();
                try {
                    this.buildSoundFeature(sb, sound);
                }
                catch (VCardBuildException vbe) {
                    if (this.isThrowsExceptions) {
                        throw new VCardException(vbe.getMessage(), vbe);
                    }
                    this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
                }
            }
        }
        if (this.vcard.hasAgents()) {
            Iterator<AgentFeature> agents = this.vcard.getAgents();
            while (agents.hasNext()) {
                AgentFeature agent = agents.next();
                try {
                    this.buildAgentFeature(sb, agent);
                }
                catch (VCardBuildException vbe) {
                    if (this.isThrowsExceptions) {
                        throw new VCardException(vbe.getMessage(), vbe);
                    }
                    this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
                }
            }
        }
        if (this.vcard.hasExtendedTypes()) {
            Iterator<ExtendedFeature> extensions = this.vcard.getExtendedTypes();
            while (extensions.hasNext()) {
                ExtendedFeature extension = extensions.next();
                try {
                    this.buildExtendedFeature(sb, extension);
                }
                catch (VCardBuildException vbe) {
                    if (this.isThrowsExceptions) {
                        throw new VCardException(vbe.getMessage(), vbe);
                    }
                    this.handleError(vbe.getMessage(), vbe, ErrorSeverity.WARNING);
                }
            }
        }
        try {
            this.buildEndFeature(sb, this.vcard.getEnd());
        }
        catch (VCardBuildException vbe) {
            if (this.isThrowsExceptions) {
                throw new VCardException(vbe.getMessage(), vbe);
            }
            this.handleError(vbe.getMessage(), vbe, ErrorSeverity.FATAL);
        }
        return sb.toString();
    }

    private void buildBeginFeature(StringBuilder sb, BeginFeature beginFeature) throws VCardBuildException {
        try {
            if (beginFeature != null) {
                if (beginFeature.hasGroup()) {
                    sb.append(beginFeature.getGroup());
                    sb.append(".");
                }
            } else {
                throw new VCardBuildException("Cannot continue because BeginFeature (" + VCardType.BEGIN.getType() + ") is null.");
            }
            sb.append(beginFeature.getTypeString());
            sb.append(":VCARD");
            sb.append("\r\n");
        }
        catch (Exception ex) {
            throw new VCardBuildException("BeginFeature (" + VCardType.BEGIN.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void buildEndFeature(StringBuilder sb, EndFeature endFeature) throws VCardBuildException {
        try {
            if (endFeature != null) {
                if (endFeature.hasGroup()) {
                    sb.append(endFeature.getGroup());
                    sb.append(".");
                }
            } else {
                throw new VCardBuildException("Cannot continue because EndFeature (" + VCardType.END.getType() + ") is null.");
            }
            sb.append(endFeature.getTypeString());
            sb.append(":VCARD");
            sb.append("\r\n");
        }
        catch (Exception ex) {
            throw new VCardBuildException("EndFeature (" + VCardType.END.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void buildVersionFeature(StringBuilder sb, VersionFeature versionFeature) throws VCardBuildException {
        try {
            if (versionFeature != null) {
                if (versionFeature.hasGroup()) {
                    sb.append(versionFeature.getGroup());
                    sb.append(".");
                }
            } else {
                throw new VCardBuildException("Cannot continue because VersionFeature (" + VCardType.VERSION.getType() + ") is null.");
            }
            sb.append(versionFeature.getTypeString());
            sb.append(":");
            sb.append(versionFeature.getVersion().getVersion());
            sb.append("\r\n");
        }
        catch (Exception ex) {
            throw new VCardBuildException("VersionFeature (" + VCardType.VERSION.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void buildNameFeature(StringBuilder sb, NameFeature nameFeature) throws VCardBuildException {
        try {
            StringBuilder tmpSb;
            if (nameFeature != null) {
                tmpSb = new StringBuilder();
                if (nameFeature.hasGroup()) {
                    tmpSb.append(nameFeature.getGroup());
                    tmpSb.append(".");
                }
                tmpSb.append(nameFeature.getTypeString());
                tmpSb.append(":");
                if (nameFeature.hasFamilyName()) {
                    tmpSb.append(VCardUtils.escapeString(nameFeature.getFamilyName()));
                }
                tmpSb.append(";");
                if (nameFeature.hasGivenName()) {
                    tmpSb.append(VCardUtils.escapeString(nameFeature.getGivenName()));
                }
                tmpSb.append(";");
                if (nameFeature.hasAdditionalNames()) {
                    Iterator<String> additionalNames = nameFeature.getAdditionalNames();
                    while (additionalNames.hasNext()) {
                        String addName = additionalNames.next();
                        tmpSb.append(VCardUtils.escapeString(addName));
                        tmpSb.append(",");
                    }
                    tmpSb.deleteCharAt(tmpSb.length() - 1);
                }
                tmpSb.append(";");
                if (nameFeature.hasHonorificPrefixes()) {
                    Iterator<String> prefixes = nameFeature.getHonorificPrefixes();
                    while (prefixes.hasNext()) {
                        String prefix = prefixes.next();
                        tmpSb.append(VCardUtils.escapeString(prefix));
                        tmpSb.append(",");
                    }
                    tmpSb.deleteCharAt(tmpSb.length() - 1);
                }
                tmpSb.append(";");
                if (nameFeature.hasHonorificSuffixes()) {
                    Iterator<String> suffixes = nameFeature.getHonorificSuffixes();
                    while (suffixes.hasNext()) {
                        String suffix = suffixes.next();
                        tmpSb.append(VCardUtils.escapeString(suffix));
                        tmpSb.append(",");
                    }
                    tmpSb.deleteCharAt(tmpSb.length() - 1);
                }
            } else {
                throw new VCardBuildException("NameFeature (" + VCardType.N.getType() + ") cannot be left null.");
            }
            String tmpNameLine = tmpSb.toString();
            String foldedNameLine = VCardUtils.foldLine(tmpNameLine, this.foldingScheme);
            sb.append(foldedNameLine);
            sb.append("\r\n");
        }
        catch (Exception ex) {
            throw new VCardBuildException("NameFeature (" + VCardType.N.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void buildFormattedNameFeature(StringBuilder sb, FormattedNameFeature formattedNameFeature) throws VCardBuildException {
        try {
            StringBuilder tmpSb;
            String formattedName;
            if (formattedNameFeature != null) {
                formattedName = formattedNameFeature.getFormattedName();
                tmpSb = new StringBuilder();
                if (formattedNameFeature.hasGroup()) {
                    tmpSb.append(formattedNameFeature.getGroup());
                    tmpSb.append(".");
                }
            } else {
                throw new VCardBuildException("FormattedNameFeature (" + VCardType.FN.getType() + ") cannot be left null.");
            }
            tmpSb.append(formattedNameFeature.getTypeString());
            tmpSb.append(":");
            tmpSb.append(VCardUtils.escapeString(formattedName));
            String tmpFormattedNameLine = tmpSb.toString();
            String foldedFormattedNameLine = VCardUtils.foldLine(tmpFormattedNameLine, this.foldingScheme);
            sb.append(foldedFormattedNameLine);
            sb.append("\r\n");
        }
        catch (Exception ex) {
            throw new VCardBuildException("FormattedNameFeature (" + VCardType.FN.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void buildDisplayableNameFeature(StringBuilder sb, DisplayableNameFeature displayableNameFeature) throws VCardBuildException {
        try {
            StringBuilder tmpSb;
            String displayableName;
            if (displayableNameFeature != null) {
                displayableName = displayableNameFeature.getName();
                tmpSb = new StringBuilder();
                if (displayableNameFeature.hasGroup()) {
                    tmpSb.append(displayableNameFeature.getGroup());
                    tmpSb.append(".");
                }
            } else {
                throw new VCardBuildException("DisplayableNameFeature (" + VCardType.NAME.getType() + ") cannot be left null.");
            }
            tmpSb.append(displayableNameFeature.getTypeString());
            tmpSb.append(":");
            tmpSb.append(VCardUtils.escapeString(displayableName));
            String tmpDisplayableNameLine = tmpSb.toString();
            String foldedDisplayableNameLine = VCardUtils.foldLine(tmpDisplayableNameLine, this.foldingScheme);
            sb.append(foldedDisplayableNameLine);
            sb.append("\r\n");
        }
        catch (Exception ex) {
            throw new VCardBuildException("DisplayableNameFeature (" + VCardType.NAME.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void buildProfileFeature(StringBuilder sb, ProfileFeature profileFeature) throws VCardBuildException {
        try {
            StringBuilder tmpSb;
            String profile;
            if (profileFeature != null) {
                profile = profileFeature.getProfile();
                tmpSb = new StringBuilder();
                if (profileFeature.hasGroup()) {
                    tmpSb.append(profileFeature.getGroup());
                    tmpSb.append(".");
                }
            } else {
                throw new VCardBuildException("ProfileFeature (" + VCardType.PROFILE.getType() + ") cannot be left null.");
            }
            tmpSb.append(profileFeature.getTypeString());
            tmpSb.append(":");
            tmpSb.append(VCardUtils.escapeString(profile));
            String tmpProfileLine = tmpSb.toString();
            String foldedProfileLine = VCardUtils.foldLine(tmpProfileLine, this.foldingScheme);
            sb.append(foldedProfileLine);
            sb.append("\r\n");
        }
        catch (Exception ex) {
            throw new VCardBuildException("ProfileFeature (" + VCardType.PROFILE.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void buildSourceFeature(StringBuilder sb, SourceFeature sourceFeature) throws VCardBuildException {
        try {
            StringBuilder tmpSb;
            String source;
            if (sourceFeature != null) {
                source = sourceFeature.getSource();
                tmpSb = new StringBuilder();
                if (sourceFeature.hasGroup()) {
                    tmpSb.append(sourceFeature.getGroup());
                    tmpSb.append(".");
                }
            } else {
                throw new VCardBuildException("SourceFeature (" + VCardType.SOURCE.getType() + ") cannot be left null.");
            }
            tmpSb.append(sourceFeature.getTypeString());
            tmpSb.append(":");
            tmpSb.append(VCardUtils.escapeString(source));
            String tmpSourceLine = tmpSb.toString();
            String foldedSourceLine = VCardUtils.foldLine(tmpSourceLine, this.foldingScheme);
            sb.append(foldedSourceLine);
            sb.append("\r\n");
        }
        catch (Exception ex) {
            throw new VCardBuildException("SourceFeature (" + VCardType.SOURCE.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void buildTitleFeature(StringBuilder sb, TitleFeature titleFeature) throws VCardBuildException {
        block4: {
            try {
                if (titleFeature == null) break block4;
                if (titleFeature.hasTitle()) {
                    String title = titleFeature.getTitle();
                    StringBuilder tmpSb = new StringBuilder();
                    if (titleFeature.hasGroup()) {
                        tmpSb.append(titleFeature.getGroup());
                        tmpSb.append(".");
                    }
                    tmpSb.append(titleFeature.getTypeString());
                    tmpSb.append(":");
                    tmpSb.append(VCardUtils.escapeString(title));
                    String tmpTitleLine = tmpSb.toString();
                    String foldedTitleLine = VCardUtils.foldLine(tmpTitleLine, this.foldingScheme);
                    sb.append(foldedTitleLine);
                    sb.append("\r\n");
                    break block4;
                }
                throw new VCardBuildException("TitleFeature (" + VCardType.TITLE.getType() + ") exists but is emtpy.");
            }
            catch (Exception ex) {
                throw new VCardBuildException("TitleFeature (" + VCardType.TITLE.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
            }
        }
    }

    private void buildRoleFeature(StringBuilder sb, RoleFeature roleFeature) throws VCardBuildException {
        block4: {
            try {
                if (roleFeature == null) break block4;
                if (roleFeature.hasRole()) {
                    String role = roleFeature.getRole();
                    StringBuilder tmpSb = new StringBuilder();
                    if (roleFeature.hasGroup()) {
                        tmpSb.append(roleFeature.getGroup());
                        tmpSb.append(".");
                    }
                    tmpSb.append(roleFeature.getTypeString());
                    tmpSb.append(":");
                    tmpSb.append(VCardUtils.escapeString(role));
                    String tmpRoleLine = tmpSb.toString();
                    String foldedRoleLine = VCardUtils.foldLine(tmpRoleLine, this.foldingScheme);
                    sb.append(foldedRoleLine);
                    sb.append("\r\n");
                    break block4;
                }
                throw new VCardBuildException("RoleFeature (" + VCardType.ROLE.getType() + ") exists but is empty.");
            }
            catch (Exception ex) {
                throw new VCardBuildException("RoleFeature (" + VCardType.ROLE.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
            }
        }
    }

    private void buildGeographicPositionFeature(StringBuilder sb, GeographicPositionFeature geographicPositionFeature) throws VCardBuildException {
        try {
            if (geographicPositionFeature != null) {
                StringBuilder tmpSb = new StringBuilder();
                if (geographicPositionFeature.hasGroup()) {
                    tmpSb.append(geographicPositionFeature.getGroup());
                    tmpSb.append(".");
                }
                tmpSb.append(geographicPositionFeature.getTypeString());
                tmpSb.append(":");
                tmpSb.append(VCardUtils.getGeographicPositionFormatter().format(geographicPositionFeature.getLatitude()));
                tmpSb.append(";");
                tmpSb.append(VCardUtils.getGeographicPositionFormatter().format(geographicPositionFeature.getLongitude()));
                String tmpGeoLine = tmpSb.toString();
                String foldedGeoLine = VCardUtils.foldLine(tmpGeoLine, this.foldingScheme);
                sb.append(foldedGeoLine);
                sb.append("\r\n");
            }
        }
        catch (Exception ex) {
            throw new VCardBuildException("GeographicPositionFeature (" + VCardType.GEO.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void buildOrganization(StringBuilder sb, OrganizationFeature organizationFeature) throws VCardBuildException {
        block5: {
            try {
                if (organizationFeature == null) break block5;
                if (organizationFeature.hasOrganizations()) {
                    StringBuilder tmpSb = new StringBuilder();
                    if (organizationFeature.hasGroup()) {
                        tmpSb.append(organizationFeature.getGroup());
                        tmpSb.append(".");
                    }
                    tmpSb.append(organizationFeature.getTypeString());
                    tmpSb.append(":");
                    Iterator<String> orgs = organizationFeature.getOrganizations();
                    while (orgs.hasNext()) {
                        String org = orgs.next();
                        tmpSb.append(VCardUtils.escapeString(org));
                        tmpSb.append(";");
                    }
                    tmpSb.deleteCharAt(tmpSb.length() - 1);
                    String tmpOrgLine = tmpSb.toString();
                    String foldedOrgLine = VCardUtils.foldLine(tmpOrgLine, this.foldingScheme);
                    sb.append(foldedOrgLine);
                    sb.append("\r\n");
                    break block5;
                }
                throw new VCardBuildException("OrganizationFeature (" + VCardType.ORG.getType() + ") exists but is empty.");
            }
            catch (Exception ex) {
                throw new VCardBuildException("OrganizationFeature (" + VCardType.ORG.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
            }
        }
    }

    private void buildMailerFeature(StringBuilder sb, MailerFeature mailerFeature) throws VCardBuildException {
        block4: {
            try {
                if (mailerFeature == null) break block4;
                if (mailerFeature.hasMailer()) {
                    StringBuilder tmpSb = new StringBuilder();
                    if (mailerFeature.hasGroup()) {
                        tmpSb.append(mailerFeature.getGroup());
                        tmpSb.append(".");
                    }
                    tmpSb.append(mailerFeature.getTypeString());
                    tmpSb.append(":");
                    tmpSb.append(VCardUtils.escapeString(mailerFeature.getMailer()));
                    String tmpMailerLine = tmpSb.toString();
                    String foldedMailerLine = VCardUtils.foldLine(tmpMailerLine, this.foldingScheme);
                    sb.append(foldedMailerLine);
                    sb.append("\r\n");
                    break block4;
                }
                throw new VCardBuildException("MailerFeature (" + VCardType.MAILER.getType() + ") exists but is empty.");
            }
            catch (Exception ex) {
                throw new VCardBuildException("MailerFeature (" + VCardType.MAILER.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
            }
        }
    }

    private void buildTimeZoneFeature(StringBuilder sb, TimeZoneFeature timeZoneFeature) throws VCardBuildException {
        try {
            if (timeZoneFeature != null) {
                StringBuilder tmpSb = new StringBuilder();
                if (timeZoneFeature.hasGroup()) {
                    tmpSb.append(timeZoneFeature.getGroup());
                    tmpSb.append(".");
                }
                tmpSb.append(timeZoneFeature.getTypeString());
                if (timeZoneFeature.getTimeZone() == null && timeZoneFeature.getTextValue() != null) {
                    tmpSb.append(";");
                    tmpSb.append(TimeZoneParameterType.VALUE.getType());
                    tmpSb.append("=TEXT:");
                    tmpSb.append(timeZoneFeature.getTextValue());
                } else {
                    tmpSb.append(":");
                    tmpSb.append(timeZoneFeature.getIso8601Offset());
                }
                String tmpTimeZoneLine = tmpSb.toString();
                String foldedTimeZoneLine = VCardUtils.foldLine(tmpTimeZoneLine, this.foldingScheme);
                sb.append(foldedTimeZoneLine);
                sb.append("\r\n");
            }
        }
        catch (Exception ex) {
            throw new VCardBuildException("TimeZoneFeature (" + VCardType.TZ.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void buildUrlFeature(StringBuilder sb, URLFeature urlFeature) throws VCardBuildException {
        block6: {
            try {
                if (urlFeature == null) break block6;
                if (urlFeature.hasURL()) {
                    StringBuilder tmpSb = new StringBuilder();
                    if (urlFeature.hasGroup()) {
                        tmpSb.append(urlFeature.getGroup());
                        tmpSb.append(".");
                    }
                    tmpSb.append(urlFeature.getTypeString());
                    tmpSb.append(":");
                    String url = urlFeature.getURL().toString();
                    if (VCardUtils.needsEscaping(url)) {
                        tmpSb.append(VCardUtils.escapeString(url));
                    } else {
                        tmpSb.append(url);
                    }
                    String tmpUrlLine = tmpSb.toString();
                    String foldedUrlLine = VCardUtils.foldLine(tmpUrlLine, this.foldingScheme);
                    sb.append(foldedUrlLine);
                    sb.append("\r\n");
                    break block6;
                }
                throw new VCardBuildException("URLFeature (" + VCardType.URL.getType() + ") exists but is empty.");
            }
            catch (Exception ex) {
                throw new VCardBuildException("URLFeature (" + VCardType.URL.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
            }
        }
    }

    private void buildRevisionFeature(StringBuilder sb, RevisionFeature revisionFeature) throws VCardBuildException {
        block4: {
            try {
                if (revisionFeature == null) break block4;
                if (revisionFeature.hasRevision()) {
                    StringBuilder tmpSb = new StringBuilder();
                    if (revisionFeature.hasGroup()) {
                        tmpSb.append(revisionFeature.getGroup());
                        tmpSb.append(".");
                    }
                    tmpSb.append(revisionFeature.getTypeString());
                    tmpSb.append(":");
                    tmpSb.append(ISOUtils.toISO8601_UTC_Time(revisionFeature.getRevision(), ISOFormat.ISO8601_EXTENDED));
                    String tmpRevisionLine = tmpSb.toString();
                    String foldedRevisionLine = VCardUtils.foldLine(tmpRevisionLine, this.foldingScheme);
                    sb.append(foldedRevisionLine);
                    sb.append("\r\n");
                    break block4;
                }
                throw new VCardBuildException("RevisionFeature (" + VCardType.REV.getType() + ") exists but is empty.");
            }
            catch (Exception ex) {
                throw new VCardBuildException("RevisionFeature (" + VCardType.REV.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
            }
        }
    }

    private void buildUidFeature(StringBuilder sb, UIDFeature uidFeature) throws VCardBuildException {
        block4: {
            try {
                if (uidFeature == null) break block4;
                if (uidFeature.hasUID()) {
                    StringBuilder tmpSb = new StringBuilder();
                    if (uidFeature.hasGroup()) {
                        tmpSb.append(uidFeature.getGroup());
                        tmpSb.append(".");
                    }
                    tmpSb.append(uidFeature.getTypeString());
                    tmpSb.append(":");
                    tmpSb.append(uidFeature.getUID());
                    String tmpUidLine = tmpSb.toString();
                    String foldedUidLine = VCardUtils.foldLine(tmpUidLine, this.foldingScheme);
                    sb.append(foldedUidLine);
                    sb.append("\r\n");
                    break block4;
                }
                throw new VCardBuildException("UIDFeature (" + VCardType.UID.getType() + ") exists but is empty.");
            }
            catch (Exception ex) {
                throw new VCardBuildException("UIDFeature (" + VCardType.UID.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
            }
        }
    }

    private void buildBirthdayFeature(StringBuilder sb, BirthdayFeature birthdayFeature) throws VCardBuildException {
        try {
            if (birthdayFeature != null) {
                StringBuilder tmpSb = new StringBuilder();
                if (birthdayFeature.hasGroup()) {
                    tmpSb.append(birthdayFeature.getGroup());
                    tmpSb.append(".");
                }
                tmpSb.append(birthdayFeature.getTypeString());
                tmpSb.append(":");
                tmpSb.append(ISOUtils.toISO8601_Date(birthdayFeature.getBirthday(), ISOFormat.ISO8601_EXTENDED));
                String tmpBdayLine = tmpSb.toString();
                String foldedBdayLine = VCardUtils.foldLine(tmpBdayLine, this.foldingScheme);
                sb.append(foldedBdayLine);
                sb.append("\r\n");
            }
        }
        catch (Exception ex) {
            throw new VCardBuildException("BirthdayFeature (" + VCardType.BDAY.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void buildAddressFeature(StringBuilder sb, AddressFeature addressFeature) throws VCardBuildException {
        try {
            if (addressFeature != null) {
                StringBuilder tmpSb = new StringBuilder();
                if (addressFeature.hasGroup()) {
                    tmpSb.append(addressFeature.getGroup());
                    tmpSb.append(".");
                }
                tmpSb.append(addressFeature.getTypeString());
                if (addressFeature.hasAddressParameterTypes()) {
                    tmpSb.append(";");
                    Iterator<AddressParameterType> paramTypes = addressFeature.getAddressParameterTypes();
                    switch (addressFeature.getParameterTypeStyle()) {
                        case PARAMETER_LIST: {
                            AddressParameterType addrType;
                            while (paramTypes.hasNext()) {
                                addrType = paramTypes.next();
                                tmpSb.append("TYPE=");
                                tmpSb.append(addrType.getType());
                                tmpSb.append(";");
                            }
                            break;
                        }
                        case PARAMETER_VALUE_LIST: {
                            AddressParameterType addrType;
                            tmpSb.append("TYPE=");
                            while (paramTypes.hasNext()) {
                                addrType = paramTypes.next();
                                tmpSb.append(addrType.getType());
                                tmpSb.append(",");
                            }
                            break;
                        }
                    }
                    tmpSb.deleteCharAt(tmpSb.length() - 1);
                }
                if (addressFeature.hasExtendedAddressParameterTypes()) {
                    Iterator<XAddressParameterType> xParamTypes = addressFeature.getExtendedAddressParameterTypes();
                    switch (addressFeature.getParameterTypeStyle()) {
                        case PARAMETER_LIST: {
                            XAddressParameterType xAddrType;
                            tmpSb.append(";");
                            while (xParamTypes.hasNext()) {
                                xAddrType = xParamTypes.next();
                                tmpSb.append("TYPE=");
                                tmpSb.append(xAddrType.getXtendedTypeName());
                                if (xAddrType.hasXtendedTypeValue()) {
                                    tmpSb.append("=");
                                    tmpSb.append(xAddrType.getXtendedTypeValue());
                                }
                                tmpSb.append(";");
                            }
                            break;
                        }
                        case PARAMETER_VALUE_LIST: {
                            XAddressParameterType xAddrType;
                            if (addressFeature.hasAddressParameterTypes()) {
                                tmpSb.append(",");
                            } else {
                                tmpSb.append(";TYPE=");
                            }
                            while (xParamTypes.hasNext()) {
                                xAddrType = xParamTypes.next();
                                tmpSb.append(xAddrType.getXtendedTypeName());
                                if (xAddrType.hasXtendedTypeValue()) {
                                    tmpSb.append("=");
                                    tmpSb.append(xAddrType.getXtendedTypeValue());
                                }
                                tmpSb.append(",");
                            }
                            break;
                        }
                    }
                    tmpSb.deleteCharAt(tmpSb.length() - 1);
                }
                tmpSb.append(":");
                if (addressFeature.hasPostOfficebox()) {
                    tmpSb.append(VCardUtils.escapeString(addressFeature.getPostOfficeBox()));
                }
                tmpSb.append(";");
                if (addressFeature.hasExtendedAddress()) {
                    tmpSb.append(VCardUtils.escapeString(addressFeature.getExtendedAddress()));
                }
                tmpSb.append(";");
                if (addressFeature.hasStreetAddress()) {
                    tmpSb.append(VCardUtils.escapeString(addressFeature.getStreetAddress()));
                }
                tmpSb.append(";");
                if (addressFeature.hasLocality()) {
                    tmpSb.append(VCardUtils.escapeString(addressFeature.getLocality()));
                }
                tmpSb.append(";");
                if (addressFeature.hasRegion()) {
                    tmpSb.append(VCardUtils.escapeString(addressFeature.getRegion()));
                }
                tmpSb.append(";");
                if (addressFeature.hasPostalCode()) {
                    tmpSb.append(VCardUtils.escapeString(addressFeature.getPostalCode()));
                }
                tmpSb.append(";");
                if (addressFeature.hasCountryName()) {
                    tmpSb.append(VCardUtils.escapeString(addressFeature.getCountryName()));
                }
                String tmpAddressLine = tmpSb.toString();
                String foldedAddressLine = VCardUtils.foldLine(tmpAddressLine, this.foldingScheme);
                sb.append(foldedAddressLine);
                sb.append("\r\n");
            }
        }
        catch (Exception ex) {
            throw new VCardBuildException("AddressFeature (" + VCardType.ADR.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
        }
    }

    private void buildLabelFeature(StringBuilder sb, LabelFeature labelFeature) throws VCardBuildException {
        block22: {
            try {
                if (labelFeature == null) break block22;
                if (labelFeature.hasLabel()) {
                    StringBuilder tmpSb = new StringBuilder();
                    if (labelFeature.hasGroup()) {
                        tmpSb.append(labelFeature.getGroup());
                        tmpSb.append(".");
                    }
                    tmpSb.append(labelFeature.getTypeString());
                    if (labelFeature.hasLabelParameterTypes()) {
                        tmpSb.append(";");
                        Iterator<LabelParameterType> paramTypes = labelFeature.getLabelParameterTypes();
                        switch (labelFeature.getParameterTypeStyle()) {
                            case PARAMETER_LIST: {
                                LabelParameterType labelType;
                                while (paramTypes.hasNext()) {
                                    labelType = paramTypes.next();
                                    tmpSb.append("TYPE=");
                                    tmpSb.append(labelType.getType());
                                    tmpSb.append(";");
                                }
                                break;
                            }
                            case PARAMETER_VALUE_LIST: {
                                LabelParameterType labelType;
                                tmpSb.append("TYPE=");
                                while (paramTypes.hasNext()) {
                                    labelType = paramTypes.next();
                                    tmpSb.append(labelType.getType());
                                    tmpSb.append(",");
                                }
                                break;
                            }
                        }
                        tmpSb.deleteCharAt(tmpSb.length() - 1);
                    }
                    if (labelFeature.hasExtendedLabelParameterTypes()) {
                        Iterator<XLabelParameterType> xParamTypes = labelFeature.getExtendedLabelParameterTypes();
                        switch (labelFeature.getParameterTypeStyle()) {
                            case PARAMETER_LIST: {
                                XLabelParameterType xLabelType;
                                tmpSb.append(";");
                                while (xParamTypes.hasNext()) {
                                    xLabelType = xParamTypes.next();
                                    tmpSb.append("TYPE=");
                                    tmpSb.append(xLabelType.getXtendedTypeName());
                                    if (xLabelType.hasXtendedTypeValue()) {
                                        tmpSb.append("=");
                                        tmpSb.append(xLabelType.getXtendedTypeValue());
                                    }
                                    tmpSb.append(";");
                                }
                                break;
                            }
                            case PARAMETER_VALUE_LIST: {
                                XLabelParameterType xLabelType;
                                if (labelFeature.hasLabelParameterTypes()) {
                                    tmpSb.append(",");
                                } else {
                                    tmpSb.append(";TYPE=");
                                }
                                while (xParamTypes.hasNext()) {
                                    xLabelType = xParamTypes.next();
                                    tmpSb.append(xLabelType.getXtendedTypeName());
                                    if (xLabelType.hasXtendedTypeValue()) {
                                        tmpSb.append("=");
                                        tmpSb.append(xLabelType.getXtendedTypeValue());
                                    }
                                    tmpSb.append(",");
                                }
                                break;
                            }
                        }
                        tmpSb.deleteCharAt(tmpSb.length() - 1);
                    }
                    tmpSb.append(":");
                    tmpSb.append(VCardUtils.escapeString(labelFeature.getLabel()));
                    String tmpLabelLine = tmpSb.toString();
                    String foldedLabelLine = VCardUtils.foldLine(tmpLabelLine, this.foldingScheme);
                    sb.append(foldedLabelLine);
                    sb.append("\r\n");
                    break block22;
                }
                throw new VCardBuildException("LabelFeature (" + VCardType.LABEL.getType() + ") exists but is empty.");
            }
            catch (Exception ex) {
                throw new VCardBuildException("LablelFeature (" + VCardType.LABEL.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
            }
        }
    }

    private void buildTelephoneFeature(StringBuilder sb, TelephoneFeature telephoneFeature) throws VCardBuildException {
        block22: {
            try {
                if (telephoneFeature == null) break block22;
                if (telephoneFeature.hasTelephone()) {
                    StringBuilder tmpSb = new StringBuilder();
                    if (telephoneFeature.hasGroup()) {
                        tmpSb.append(telephoneFeature.getGroup());
                        tmpSb.append(".");
                    }
                    tmpSb.append(telephoneFeature.getTypeString());
                    if (telephoneFeature.hasTelephoneParameterTypes()) {
                        tmpSb.append(";");
                        Iterator<TelephoneParameterType> paramTypes = telephoneFeature.getTelephoneParameterTypes();
                        switch (telephoneFeature.getParameterTypeStyle()) {
                            case PARAMETER_LIST: {
                                TelephoneParameterType teleType;
                                while (paramTypes.hasNext()) {
                                    teleType = paramTypes.next();
                                    tmpSb.append("TYPE=");
                                    tmpSb.append(teleType.getType());
                                    tmpSb.append(";");
                                }
                                break;
                            }
                            case PARAMETER_VALUE_LIST: {
                                TelephoneParameterType teleType;
                                tmpSb.append("TYPE=");
                                while (paramTypes.hasNext()) {
                                    teleType = paramTypes.next();
                                    tmpSb.append(teleType.getType());
                                    tmpSb.append(",");
                                }
                                break;
                            }
                        }
                        tmpSb.deleteCharAt(tmpSb.length() - 1);
                    }
                    if (telephoneFeature.hasExtendedTelephoneParameterTypes()) {
                        Iterator<XTelephoneParameterType> xParamTypes = telephoneFeature.getExtendedTelephoneParameterTypes();
                        switch (telephoneFeature.getParameterTypeStyle()) {
                            case PARAMETER_LIST: {
                                XTelephoneParameterType xTelType;
                                tmpSb.append(";");
                                while (xParamTypes.hasNext()) {
                                    xTelType = xParamTypes.next();
                                    tmpSb.append("TYPE=");
                                    tmpSb.append(xTelType.getXtendedTypeName());
                                    if (xTelType.hasXtendedTypeValue()) {
                                        tmpSb.append("=");
                                        tmpSb.append(xTelType.getXtendedTypeValue());
                                    }
                                    tmpSb.append(";");
                                }
                                break;
                            }
                            case PARAMETER_VALUE_LIST: {
                                XTelephoneParameterType xTelType;
                                if (telephoneFeature.hasTelephoneParameterTypes()) {
                                    tmpSb.append(",");
                                } else {
                                    tmpSb.append(";TYPE=");
                                }
                                while (xParamTypes.hasNext()) {
                                    xTelType = xParamTypes.next();
                                    tmpSb.append(xTelType.getXtendedTypeName());
                                    if (xTelType.hasXtendedTypeValue()) {
                                        tmpSb.append("=");
                                        tmpSb.append(xTelType.getXtendedTypeValue());
                                    }
                                    tmpSb.append(",");
                                }
                                break;
                            }
                        }
                        tmpSb.deleteCharAt(tmpSb.length() - 1);
                    }
                    tmpSb.append(":");
                    tmpSb.append(telephoneFeature.getTelephone());
                    String tmpTelephoneLine = tmpSb.toString();
                    String foldedTelephoneLine = VCardUtils.foldLine(tmpTelephoneLine, this.foldingScheme);
                    sb.append(foldedTelephoneLine);
                    sb.append("\r\n");
                    break block22;
                }
                throw new VCardBuildException("TelephoneFeature (" + VCardType.TEL.getType() + ") exists but is empty.");
            }
            catch (Exception ex) {
                throw new VCardBuildException("TelephoneFeature (" + VCardType.TEL.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
            }
        }
    }

    private void buildEmailFeature(StringBuilder sb, EmailFeature emailFeature) throws VCardBuildException {
        block22: {
            try {
                if (emailFeature == null) break block22;
                if (emailFeature.hasEmail()) {
                    StringBuilder tmpSb = new StringBuilder();
                    if (emailFeature.hasGroup()) {
                        tmpSb.append(emailFeature.getGroup());
                        tmpSb.append(".");
                    }
                    tmpSb.append(emailFeature.getTypeString());
                    if (emailFeature.hasEmailParameterTypes()) {
                        tmpSb.append(";");
                        Iterator<EmailParameterType> paramTypes = emailFeature.getEmailParameterTypes();
                        switch (emailFeature.getParameterTypeStyle()) {
                            case PARAMETER_LIST: {
                                while (paramTypes.hasNext()) {
                                    EmailParameterType emailParamType = paramTypes.next();
                                    tmpSb.append("TYPE=");
                                    tmpSb.append(emailParamType.getType());
                                    tmpSb.append(";");
                                }
                                break;
                            }
                            case PARAMETER_VALUE_LIST: {
                                tmpSb.append("TYPE=");
                                while (paramTypes.hasNext()) {
                                    EmailParameterType teleType = paramTypes.next();
                                    tmpSb.append(teleType.getType());
                                    tmpSb.append(",");
                                }
                                break;
                            }
                        }
                        tmpSb.deleteCharAt(tmpSb.length() - 1);
                    }
                    if (emailFeature.hasExtendedEmailParameterTypes()) {
                        Iterator<XEmailParameterType> xParamTypes = emailFeature.getExtendedEmailParameterTypes();
                        switch (emailFeature.getParameterTypeStyle()) {
                            case PARAMETER_LIST: {
                                XEmailParameterType xEmailType;
                                tmpSb.append(";");
                                while (xParamTypes.hasNext()) {
                                    xEmailType = xParamTypes.next();
                                    tmpSb.append("TYPE=");
                                    tmpSb.append(xEmailType.getXtendedTypeName());
                                    if (xEmailType.hasXtendedTypeValue()) {
                                        tmpSb.append("=");
                                        tmpSb.append(xEmailType.getXtendedTypeValue());
                                    }
                                    tmpSb.append(";");
                                }
                                break;
                            }
                            case PARAMETER_VALUE_LIST: {
                                XEmailParameterType xEmailType;
                                if (emailFeature.hasEmailParameterTypes()) {
                                    tmpSb.append(",");
                                } else {
                                    tmpSb.append(";TYPE=");
                                }
                                while (xParamTypes.hasNext()) {
                                    xEmailType = xParamTypes.next();
                                    tmpSb.append(xEmailType.getXtendedTypeName());
                                    if (xEmailType.hasXtendedTypeValue()) {
                                        tmpSb.append("=");
                                        tmpSb.append(xEmailType.getXtendedTypeValue());
                                    }
                                    tmpSb.append(",");
                                }
                                break;
                            }
                        }
                        tmpSb.deleteCharAt(tmpSb.length() - 1);
                    }
                    tmpSb.append(":");
                    tmpSb.append(emailFeature.getEmail());
                    String tmpEmailLine = tmpSb.toString();
                    String foldedEmailLine = VCardUtils.foldLine(tmpEmailLine, this.foldingScheme);
                    sb.append(foldedEmailLine);
                    sb.append("\r\n");
                    break block22;
                }
                throw new VCardBuildException("EmailFeature (" + VCardType.EMAIL.getType() + ") exists but is empty.");
            }
            catch (Exception ex) {
                throw new VCardBuildException("EmailFeature (" + VCardType.EMAIL.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
            }
        }
    }

    private void buildNoteFeature(StringBuilder sb, NoteFeature noteFeature) throws VCardBuildException {
        block4: {
            try {
                if (noteFeature == null) break block4;
                if (noteFeature.hasNote()) {
                    StringBuilder tmpSb = new StringBuilder();
                    if (noteFeature.hasGroup()) {
                        tmpSb.append(noteFeature.getGroup());
                        tmpSb.append(".");
                    }
                    tmpSb.append(noteFeature.getTypeString());
                    tmpSb.append(":");
                    tmpSb.append(VCardUtils.escapeString(noteFeature.getNote()));
                    String tmpNoteLine = tmpSb.toString();
                    String foldedNoteLine = VCardUtils.foldLine(tmpNoteLine, this.foldingScheme);
                    sb.append(foldedNoteLine);
                    sb.append("\r\n");
                    break block4;
                }
                throw new VCardBuildException("NoteFeature (" + VCardType.NOTE.getType() + ") exists but is empty.");
            }
            catch (Exception ex) {
                throw new VCardBuildException("NoteFeature (" + VCardType.NOTE.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
            }
        }
    }

    private void buildNicknames(StringBuilder sb, NicknameFeature nicknameFeature) throws VCardBuildException {
        block5: {
            try {
                if (nicknameFeature == null) break block5;
                if (nicknameFeature.hasNicknames()) {
                    StringBuilder tmpSb = new StringBuilder();
                    if (nicknameFeature.hasGroup()) {
                        tmpSb.append(nicknameFeature.getGroup());
                        tmpSb.append(".");
                    }
                    tmpSb.append(nicknameFeature.getTypeString());
                    tmpSb.append(":");
                    Iterator<String> nicknames = nicknameFeature.getNicknames();
                    while (nicknames.hasNext()) {
                        String nickname = nicknames.next();
                        tmpSb.append(nickname);
                        tmpSb.append(",");
                    }
                    tmpSb.deleteCharAt(tmpSb.length() - 1);
                    String tmpNicknameLine = tmpSb.toString();
                    String foldedNicknameLine = VCardUtils.foldLine(tmpNicknameLine, this.foldingScheme);
                    sb.append(foldedNicknameLine);
                    sb.append("\r\n");
                    break block5;
                }
                throw new VCardBuildException("NicknameFeature (" + VCardType.NICKNAME.getType() + ") exists but is empty.");
            }
            catch (Exception ex) {
                throw new VCardBuildException("NicknameFeature (" + VCardType.NICKNAME.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
            }
        }
    }

    private void buildCategoriesFeature(StringBuilder sb, CategoriesFeature categoriesFeature) throws VCardBuildException {
        block8: {
            try {
                if (categoriesFeature == null) break block8;
                if (categoriesFeature.hasCategories()) {
                    StringBuilder tmpSb = new StringBuilder();
                    if (categoriesFeature.hasGroup()) {
                        tmpSb.append(categoriesFeature.getGroup());
                        tmpSb.append(".");
                    }
                    tmpSb.append(categoriesFeature.getTypeString());
                    tmpSb.append(":");
                    Iterator<String> categories = categoriesFeature.getCategories();
                    block5: while (categories.hasNext()) {
                        String category = categories.next();
                        tmpSb.append(category);
                        switch (this.compatMode) {
                            case KDE_ADDRESS_BOOK: {
                                tmpSb.append("\\,");
                                continue block5;
                            }
                        }
                        tmpSb.append(",");
                    }
                    tmpSb.deleteCharAt(tmpSb.length() - 1);
                    String tmpCategoryLine = tmpSb.toString();
                    String foldedCategoryLine = VCardUtils.foldLine(tmpCategoryLine, this.foldingScheme);
                    sb.append(foldedCategoryLine);
                    sb.append("\r\n");
                    break block8;
                }
                throw new VCardBuildException("CategoriesFeature (" + VCardType.CATEGORIES.getType() + ") exists but is empty.");
            }
            catch (Exception ex) {
                throw new VCardBuildException("CategoriesFeature (" + VCardType.CATEGORIES.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
            }
        }
    }

    private void buildClassFeature(StringBuilder sb, ClassFeature classFeature) throws VCardBuildException {
        block4: {
            try {
                if (classFeature == null) break block4;
                if (classFeature.hasSecurityClass()) {
                    StringBuilder tmpSb = new StringBuilder();
                    if (classFeature.hasGroup()) {
                        tmpSb.append(classFeature.getGroup());
                        tmpSb.append(".");
                    }
                    tmpSb.append(classFeature.getTypeString());
                    tmpSb.append(":");
                    tmpSb.append(classFeature.getSecurityClass());
                    String tmpClassLine = tmpSb.toString();
                    String foldedClassLine = VCardUtils.foldLine(tmpClassLine, this.foldingScheme);
                    sb.append(foldedClassLine);
                    sb.append("\r\n");
                    break block4;
                }
                throw new VCardBuildException("ClassFeature (" + VCardType.CLASS.getType() + ") exists but is empty.");
            }
            catch (Exception ex) {
                throw new VCardBuildException("ClassFeature (" + VCardType.CLASS.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
            }
        }
    }

    private void buildProductIdFeature(StringBuilder sb, ProductIdFeature productIdFeature) throws VCardBuildException {
        block4: {
            try {
                if (productIdFeature == null) break block4;
                if (productIdFeature.hasProductId()) {
                    StringBuilder tmpSb = new StringBuilder();
                    if (productIdFeature.hasGroup()) {
                        tmpSb.append(productIdFeature.getGroup());
                        tmpSb.append(".");
                    }
                    tmpSb.append(productIdFeature.getTypeString());
                    tmpSb.append(":");
                    tmpSb.append(productIdFeature.getProductId());
                    String tmpProductIdLine = tmpSb.toString();
                    String foldedProductIdLine = VCardUtils.foldLine(tmpProductIdLine, this.foldingScheme);
                    sb.append(foldedProductIdLine);
                    sb.append("\r\n");
                    break block4;
                }
                throw new VCardBuildException("ProductIdFeature (" + VCardType.PRODID.getType() + ") exists but is empty.");
            }
            catch (Exception ex) {
                throw new VCardBuildException("ProductIdFeature (" + VCardType.PRODID.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
            }
        }
    }

    private void buildSortStringFeature(StringBuilder sb, SortStringFeature sortStringFeature) throws VCardBuildException {
        block4: {
            try {
                if (sortStringFeature == null) break block4;
                if (sortStringFeature.hasSortString()) {
                    StringBuilder tmpSb = new StringBuilder();
                    if (sortStringFeature.hasGroup()) {
                        tmpSb.append(sortStringFeature.getGroup());
                        tmpSb.append(".");
                    }
                    tmpSb.append(sortStringFeature.getTypeString());
                    tmpSb.append(":");
                    tmpSb.append(sortStringFeature.getSortString());
                    String tmpSortStringLine = tmpSb.toString();
                    String foldedSortStringLine = VCardUtils.foldLine(tmpSortStringLine, this.foldingScheme);
                    sb.append(foldedSortStringLine);
                    sb.append("\r\n");
                    break block4;
                }
                throw new VCardBuildException("SortStringFeature (" + VCardType.SORT_STRING.getType() + ") exists but is empty.");
            }
            catch (Exception ex) {
                throw new VCardBuildException("SortStringFeature (" + VCardType.SORT_STRING.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
            }
        }
    }

    private void buildKeyFeature(StringBuilder sb, KeyFeature keyFeature) throws VCardBuildException {
        block19: {
            try {
                if (keyFeature == null) break block19;
                if (keyFeature.hasKey()) {
                    StringBuilder tmpSb = new StringBuilder();
                    if (keyFeature.hasGroup()) {
                        tmpSb.append(keyFeature.getGroup());
                        tmpSb.append(".");
                    }
                    tmpSb.append(keyFeature.getTypeString());
                    tmpSb.append(";");
                    String foldedKeyLine = null;
                    tmpSb.append("ENCODING=");
                    switch (this.compatMode) {
                        case MAC_ADDRESS_BOOK: {
                            tmpSb.append(EncodingType.BASE64.getType());
                            break;
                        }
                        case KDE_ADDRESS_BOOK: 
                        case EVOLUTION: 
                        case MS_OUTLOOK: 
                        case RFC2426: 
                        case I_PHONE: {
                            tmpSb.append(keyFeature.getEncodingType().getType());
                        }
                    }
                    if (keyFeature.hasKeyTextType()) {
                        tmpSb.append(";");
                        tmpSb.append("TYPE=");
                        tmpSb.append(keyFeature.getKeyTextType().getTypeName());
                    }
                    tmpSb.append(":");
                    switch (this.compatMode) {
                        case MAC_ADDRESS_BOOK: {
                            String b64str = null;
                            try {
                                byte[] keyBytes = keyFeature.getKey();
                                b64str = keyFeature.isSetCompression() ? Base64Wrapper.encode(keyBytes, Base64Wrapper.OPTIONS.GZIP_COMPRESSION) : Base64Wrapper.encode(keyBytes);
                            }
                            catch (Exception ex) {
                                throw new VCardBuildException(ex.getMessage(), ex);
                            }
                            String tmpKeyLine = tmpSb.toString();
                            String foldedKeyLine2 = VCardUtils.foldLine(tmpKeyLine, this.foldingScheme);
                            foldedKeyLine = VCardUtils.foldLine(b64str, this.foldingScheme);
                            sb.append(foldedKeyLine2);
                            sb.append("\r\n");
                            sb.append(FoldingScheme.MAC_ADDRESS_BOOK.getIndent());
                            break;
                        }
                        case KDE_ADDRESS_BOOK: 
                        case EVOLUTION: 
                        case MS_OUTLOOK: 
                        case RFC2426: 
                        case I_PHONE: {
                            try {
                                byte[] keyBytes = keyFeature.getKey();
                                if (keyFeature.isSetCompression()) {
                                    tmpSb.append(Base64Wrapper.encode(keyBytes, Base64Wrapper.OPTIONS.GZIP_COMPRESSION));
                                } else {
                                    tmpSb.append(Base64Wrapper.encode(keyBytes));
                                }
                            }
                            catch (Exception ex) {
                                throw new VCardBuildException(ex.getMessage(), ex);
                            }
                            String tmpKeyLine = tmpSb.toString();
                            foldedKeyLine = VCardUtils.foldLine(tmpKeyLine, this.foldingScheme);
                            break;
                        }
                    }
                    sb.append(foldedKeyLine);
                    sb.append("\r\n");
                    break block19;
                }
                throw new VCardBuildException("KeyFeature (" + VCardType.KEY.getType() + ") exists but is empty.");
            }
            catch (Exception ex) {
                throw new VCardBuildException("KeyFeature (" + VCardType.KEY.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
            }
        }
    }

    private void buildPhotoFeature(StringBuilder sb, PhotoFeature photoFeature) throws VCardBuildException {
        block23: {
            try {
                if (photoFeature == null) break block23;
                if (photoFeature.hasPhoto()) {
                    StringBuilder tmpSb = new StringBuilder();
                    if (photoFeature.hasGroup()) {
                        tmpSb.append(photoFeature.getGroup());
                        tmpSb.append(".");
                    }
                    tmpSb.append(photoFeature.getTypeString());
                    tmpSb.append(";");
                    String foldedPhotoLine = null;
                    if (photoFeature.isURI()) {
                        tmpSb.append("VALUE=URI:");
                        tmpSb.append(photoFeature.getPhotoURI().getPath());
                        String tmpPhotoLine = tmpSb.toString();
                        foldedPhotoLine = VCardUtils.foldLine(tmpPhotoLine, this.foldingScheme);
                    } else if (photoFeature.isInline()) {
                        tmpSb.append("ENCODING=");
                        switch (this.compatMode) {
                            case MAC_ADDRESS_BOOK: {
                                tmpSb.append(EncodingType.BASE64.getType());
                                break;
                            }
                            case KDE_ADDRESS_BOOK: 
                            case EVOLUTION: 
                            case MS_OUTLOOK: 
                            case RFC2426: 
                            case I_PHONE: {
                                tmpSb.append(photoFeature.getEncodingType().getType());
                            }
                        }
                        if (photoFeature.hasImageMediaType()) {
                            tmpSb.append(";");
                            tmpSb.append("TYPE=");
                            tmpSb.append(photoFeature.getImageMediaType().getTypeName());
                        }
                        tmpSb.append(":");
                        switch (this.compatMode) {
                            case MAC_ADDRESS_BOOK: {
                                String b64str = null;
                                try {
                                    byte[] photoBytes = photoFeature.getPhoto();
                                    b64str = photoFeature.isSetCompression() ? Base64Wrapper.encode(photoBytes, Base64Wrapper.OPTIONS.GZIP_COMPRESSION) : Base64Wrapper.encode(photoBytes);
                                }
                                catch (Exception ex) {
                                    throw new VCardBuildException(ex.getMessage(), ex);
                                }
                                String tmpPhotoLine = tmpSb.toString();
                                String foldedPhotoLine2 = VCardUtils.foldLine(tmpPhotoLine, this.foldingScheme);
                                foldedPhotoLine = VCardUtils.foldLine(b64str, this.foldingScheme);
                                sb.append(foldedPhotoLine2);
                                sb.append("\r\n");
                                sb.append(FoldingScheme.MAC_ADDRESS_BOOK.getIndent());
                                break;
                            }
                            case KDE_ADDRESS_BOOK: 
                            case EVOLUTION: 
                            case MS_OUTLOOK: 
                            case RFC2426: 
                            case I_PHONE: {
                                try {
                                    byte[] photoBytes = photoFeature.getPhoto();
                                    if (photoFeature.isSetCompression()) {
                                        tmpSb.append(Base64Wrapper.encode(photoBytes, Base64Wrapper.OPTIONS.GZIP_COMPRESSION));
                                    } else {
                                        tmpSb.append(Base64Wrapper.encode(photoBytes));
                                    }
                                }
                                catch (Exception ex) {
                                    throw new VCardBuildException(ex.getMessage(), ex);
                                }
                                String tmpPhotoLine = tmpSb.toString();
                                foldedPhotoLine = VCardUtils.foldLine(tmpPhotoLine, this.foldingScheme);
                                break;
                            }
                        }
                    } else {
                        throw new VCardBuildException("PhotoFeature (" + VCardType.PHOTO.getType() + ") is not URI and not Inline, cannot proceed, must be one or the other.");
                    }
                    sb.append(foldedPhotoLine);
                    sb.append("\r\n");
                    break block23;
                }
                throw new VCardBuildException("PhotoFeature (" + VCardType.PHOTO.getType() + ") exists but is empty.");
            }
            catch (Exception ex) {
                throw new VCardBuildException("PhotoFeature (" + VCardType.PHOTO.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
            }
        }
    }

    private void buildLogoFeature(StringBuilder sb, LogoFeature logoFeature) throws VCardBuildException {
        block23: {
            try {
                if (logoFeature == null) break block23;
                if (logoFeature.hasLogo()) {
                    StringBuilder tmpSb = new StringBuilder();
                    if (logoFeature.hasGroup()) {
                        tmpSb.append(logoFeature.getGroup());
                        tmpSb.append(".");
                    }
                    tmpSb.append(logoFeature.getTypeString());
                    tmpSb.append(";");
                    String foldedLogoLine = null;
                    if (logoFeature.isURI()) {
                        tmpSb.append("VALUE=URI:");
                        tmpSb.append(logoFeature.getLogoURI().getPath());
                        String tmpLogoLine = tmpSb.toString();
                        foldedLogoLine = VCardUtils.foldLine(tmpLogoLine, this.foldingScheme);
                    } else if (logoFeature.isInline()) {
                        tmpSb.append("ENCODING=");
                        switch (this.compatMode) {
                            case MAC_ADDRESS_BOOK: {
                                tmpSb.append(EncodingType.BASE64.getType());
                                break;
                            }
                            case KDE_ADDRESS_BOOK: 
                            case EVOLUTION: 
                            case MS_OUTLOOK: 
                            case RFC2426: 
                            case I_PHONE: {
                                tmpSb.append(logoFeature.getEncodingType().getType());
                            }
                        }
                        if (logoFeature.hasImageMediaType()) {
                            tmpSb.append(";");
                            tmpSb.append("TYPE=");
                            tmpSb.append(logoFeature.getImageMediaType().getTypeName());
                        }
                        tmpSb.append(":");
                        switch (this.compatMode) {
                            case MAC_ADDRESS_BOOK: {
                                String b64str = null;
                                try {
                                    byte[] logoBytes = logoFeature.getLogo();
                                    b64str = logoFeature.isSetCompression() ? Base64Wrapper.encode(logoBytes, Base64Wrapper.OPTIONS.GZIP_COMPRESSION) : Base64Wrapper.encode(logoBytes);
                                }
                                catch (Exception ex) {
                                    throw new VCardBuildException(ex.getMessage(), ex);
                                }
                                String tmpLogoLine = tmpSb.toString();
                                String foldedPhotoLine2 = VCardUtils.foldLine(tmpLogoLine, this.foldingScheme);
                                foldedLogoLine = VCardUtils.foldLine(b64str, this.foldingScheme);
                                sb.append(foldedPhotoLine2);
                                sb.append("\r\n");
                                sb.append(FoldingScheme.MAC_ADDRESS_BOOK.getIndent());
                                break;
                            }
                            case KDE_ADDRESS_BOOK: 
                            case EVOLUTION: 
                            case MS_OUTLOOK: 
                            case RFC2426: 
                            case I_PHONE: {
                                try {
                                    byte[] photoBytes = logoFeature.getLogo();
                                    if (logoFeature.isSetCompression()) {
                                        tmpSb.append(Base64Wrapper.encode(photoBytes, Base64Wrapper.OPTIONS.GZIP_COMPRESSION));
                                    } else {
                                        tmpSb.append(Base64Wrapper.encode(photoBytes));
                                    }
                                }
                                catch (Exception ex) {
                                    throw new VCardBuildException(ex.getMessage(), ex);
                                }
                                String tmpLogoLine = tmpSb.toString();
                                foldedLogoLine = VCardUtils.foldLine(tmpLogoLine, this.foldingScheme);
                                break;
                            }
                        }
                    } else {
                        throw new VCardBuildException("LogoFeature (" + VCardType.LOGO.getType() + ") is not URI and not Inline, cannot proceed, must be one or the other.");
                    }
                    sb.append(foldedLogoLine);
                    sb.append("\r\n");
                    break block23;
                }
                throw new VCardBuildException("LogoFeature (" + VCardType.LOGO.getType() + ") exists but is empty.");
            }
            catch (Exception ex) {
                throw new VCardBuildException("LogoFeature (" + VCardType.LOGO.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
            }
        }
    }

    private void buildSoundFeature(StringBuilder sb, SoundFeature soundFeature) throws VCardBuildException {
        block23: {
            try {
                if (soundFeature == null) break block23;
                if (soundFeature.hasSound()) {
                    StringBuilder tmpSb = new StringBuilder();
                    if (soundFeature.hasGroup()) {
                        tmpSb.append(soundFeature.getGroup());
                        tmpSb.append(".");
                    }
                    tmpSb.append(soundFeature.getTypeString());
                    tmpSb.append(";");
                    String foldedSoundLine = null;
                    if (soundFeature.isURI()) {
                        tmpSb.append("VALUE=URI:");
                        tmpSb.append(soundFeature.getSoundURI().getPath());
                        String tmpSoundLine = tmpSb.toString();
                        foldedSoundLine = VCardUtils.foldLine(tmpSoundLine, this.foldingScheme);
                    } else if (soundFeature.isInline()) {
                        tmpSb.append("ENCODING=");
                        switch (this.compatMode) {
                            case MAC_ADDRESS_BOOK: {
                                tmpSb.append(EncodingType.BASE64.getType());
                                break;
                            }
                            case KDE_ADDRESS_BOOK: 
                            case EVOLUTION: 
                            case MS_OUTLOOK: 
                            case RFC2426: 
                            case I_PHONE: {
                                tmpSb.append(soundFeature.getEncodingType().getType());
                            }
                        }
                        if (soundFeature.hasAudioMediaType()) {
                            tmpSb.append(";");
                            tmpSb.append("TYPE=");
                            tmpSb.append(soundFeature.getAudioMediaType().getTypeName());
                        }
                        tmpSb.append(":");
                        switch (this.compatMode) {
                            case MAC_ADDRESS_BOOK: {
                                String b64str = null;
                                try {
                                    byte[] soundBytes = soundFeature.getSound();
                                    b64str = soundFeature.isSetCompression() ? Base64Wrapper.encode(soundBytes, Base64Wrapper.OPTIONS.GZIP_COMPRESSION) : Base64Wrapper.encode(soundBytes);
                                }
                                catch (Exception ex) {
                                    throw new VCardBuildException(ex.getMessage(), ex);
                                }
                                String tmpSoundLine = tmpSb.toString();
                                String foldedSoundLine2 = VCardUtils.foldLine(tmpSoundLine, this.foldingScheme);
                                foldedSoundLine = VCardUtils.foldLine(b64str, this.foldingScheme);
                                sb.append(foldedSoundLine2);
                                sb.append("\r\n");
                                sb.append(FoldingScheme.MAC_ADDRESS_BOOK.getIndent());
                                break;
                            }
                            case KDE_ADDRESS_BOOK: 
                            case EVOLUTION: 
                            case MS_OUTLOOK: 
                            case RFC2426: 
                            case I_PHONE: {
                                try {
                                    byte[] soundBytes = soundFeature.getSound();
                                    if (soundFeature.isSetCompression()) {
                                        tmpSb.append(Base64Wrapper.encode(soundBytes, Base64Wrapper.OPTIONS.GZIP_COMPRESSION));
                                    } else {
                                        tmpSb.append(Base64Wrapper.encode(soundBytes));
                                    }
                                }
                                catch (Exception ex) {
                                    throw new VCardBuildException(ex.getMessage(), ex);
                                }
                                String tmpSoundLine = tmpSb.toString();
                                foldedSoundLine = VCardUtils.foldLine(tmpSoundLine, this.foldingScheme);
                                break;
                            }
                        }
                    } else {
                        throw new VCardBuildException("SoundFeature (" + VCardType.SOUND.getType() + ") is not URI and not Inline, cannot proceed, must be one or the other.");
                    }
                    sb.append(foldedSoundLine);
                    sb.append("\r\n");
                    break block23;
                }
                throw new VCardBuildException("SoundFeature (" + VCardType.SOUND.getType() + ") exists but is empty.");
            }
            catch (Exception ex) {
                throw new VCardBuildException("SoundFeature (" + VCardType.SOUND.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
            }
        }
    }

    private void buildAgentFeature(StringBuilder sb, AgentFeature agentFeature) throws VCardBuildException {
        block10: {
            try {
                if (agentFeature == null) break block10;
                if (agentFeature.hasAgent()) {
                    StringBuilder tmpSb = new StringBuilder();
                    if (agentFeature.hasGroup()) {
                        tmpSb.append(agentFeature.getGroup());
                        tmpSb.append(".");
                    }
                    tmpSb.append(agentFeature.getTypeString());
                    if (agentFeature.isURI()) {
                        tmpSb.append(";");
                        tmpSb.append("VALUE=URI:");
                        tmpSb.append(agentFeature.getAgentURI().getPath());
                        break block10;
                    }
                    if (agentFeature.isInline()) {
                        tmpSb.append(":");
                        VCard agentVCard = agentFeature.getAgent();
                        if (agentVCard instanceof VCardErrorHandling) {
                            ((VCardErrorHandling)((Object)agentVCard)).setThrowExceptions(true);
                        }
                        try {
                            VCardWriter writer = new VCardWriter();
                            writer.setCompatibilityMode(this.compatMode);
                            writer.setFoldingScheme(this.foldingScheme);
                            writer.setOutputVersion(this.outputVersion);
                            writer.setVCard(agentVCard);
                            String agentVCardStr = writer.buildVCardString();
                            tmpSb.append(VCardUtils.escapeString(agentVCardStr));
                        }
                        catch (VCardException ve) {
                            throw new VCardBuildException(ve.getMessage(), ve);
                        }
                        catch (Exception ex) {
                            throw new VCardBuildException(ex.getMessage(), ex);
                        }
                        String tmpAgentLine = tmpSb.toString();
                        String foldedAgentLine = VCardUtils.foldLine(tmpAgentLine, this.foldingScheme);
                        sb.append(foldedAgentLine);
                        sb.append("\r\n");
                        break block10;
                    }
                    throw new VCardBuildException("AgentFeature (" + VCardType.AGENT.getType() + ") is not URI and not Inline, cannot proceed, must be one or the other.");
                }
                throw new VCardBuildException("AgentFeature (" + VCardType.AGENT.getType() + ") exists but is empty.");
            }
            catch (Exception ex) {
                throw new VCardBuildException("AgentFeature (" + VCardType.AGENT.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
            }
        }
    }

    private void buildExtendedFeature(StringBuilder sb, ExtendedFeature extendedFeature) throws VCardBuildException {
        block4: {
            try {
                if (extendedFeature == null) break block4;
                if (extendedFeature.hasExtension()) {
                    StringBuilder tmpSb = new StringBuilder();
                    if (extendedFeature.hasGroup()) {
                        tmpSb.append(extendedFeature.getGroup());
                        tmpSb.append(".");
                    }
                    tmpSb.append(extendedFeature.getExtensionName());
                    tmpSb.append(":");
                    tmpSb.append(extendedFeature.getExtensionData());
                    String tmpExtendedLine = tmpSb.toString();
                    String foldedExtendedLine = VCardUtils.foldLine(tmpExtendedLine, this.foldingScheme);
                    sb.append(foldedExtendedLine);
                    sb.append("\r\n");
                    break block4;
                }
                throw new VCardBuildException("ExtendedFeature (" + extendedFeature.getExtensionName() + ") exists but is empty.");
            }
            catch (Exception ex) {
                throw new VCardBuildException("ExtendedFeature (" + VCardType.XTENDED.getType() + ") [" + ex.getClass().getName() + "] " + ex.getMessage(), ex);
            }
        }
    }

    public boolean hasErrors() {
        if (this.vcard instanceof VCardErrorHandling) {
            return ((VCardErrorHandling)((Object)this.vcard)).hasErrors();
        }
        return false;
    }

    private void handleError(String errorMessage, ErrorSeverity severity) {
        this.handleError(errorMessage, null, severity);
    }

    private void handleError(String errorMessage, Throwable exception, ErrorSeverity severity) {
        VCardError vError = new VCardError();
        vError.setErrorMessage(errorMessage);
        vError.setSeverity(severity);
        if (exception != null) {
            vError.setError(exception);
        }
        ((VCardErrorHandling)((Object)this.vcard)).addError(vError);
    }

    public void reset() {
        this.setOutputVersion(null);
        this.setFoldingScheme(null);
        this.setCompatibilityMode(null);
        this.vcard = null;
    }
}

