/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.util;

import info.ineighborhood.cardme.util.ISOFormat;
import java.util.Calendar;
import java.util.TimeZone;

public final class ISOUtils {
    public static final String ISO8601_UTC_TIME_BASIC_REGEX = "\\d\\d\\d\\d\\d\\d\\d\\dT\\d\\d\\d\\d\\d\\dZ";
    public static final String ISO8601_UTC_TIME_EXTENDED_REGEX = "\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d\\:\\d\\d\\:\\d\\dZ";
    public static final String ISO8601_TIME_EXTENDED_REGEX = "\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d\\:\\d\\d\\:\\d\\d[-\\+]\\d\\d\\:\\d\\d";
    public static final String ISO8601_DATE_BASIC_REGEX = "\\d\\d\\d\\d\\d\\d\\d\\d";
    public static final String ISO8601_DATE_EXTENDED_REGEX = "\\d\\d\\d\\d-\\d\\d-\\d\\d";
    public static final String ISO8601_TIMEZONE_BASIC_REGEX = "-?\\d{3,4}";
    public static final String ISO8601_TIMEZONE_EXTENDED_REGEX = "-?\\d{1,2}:\\d\\d";

    private ISOUtils() {
    }

    public static String toISO8601_UTC_Time(Calendar time, ISOFormat format) {
        StringBuilder builder = new StringBuilder();
        switch (format) {
            case ISO8601_BASIC: {
                builder.append(ISOUtils.toISO8601_Date(time, format));
                builder.append("T");
                ISOUtils.paddTwoDigits(builder, time.get(11));
                ISOUtils.paddTwoDigits(builder, time.get(12));
                ISOUtils.paddTwoDigits(builder, time.get(13));
                break;
            }
            case ISO8601_EXTENDED: {
                builder.append(ISOUtils.toISO8601_Date(time, format));
                builder.append("T");
                ISOUtils.paddTwoDigits(builder, time.get(11));
                builder.append(":");
                ISOUtils.paddTwoDigits(builder, time.get(12));
                builder.append(":");
                ISOUtils.paddTwoDigits(builder, time.get(13));
                builder.append("Z");
            }
        }
        return builder.toString();
    }

    public static String toISO8601_Date(Calendar date, ISOFormat format) {
        StringBuilder builder = new StringBuilder();
        switch (format) {
            case ISO8601_BASIC: {
                builder.append(date.get(1));
                ISOUtils.paddTwoDigits(builder, date.get(2) + 1);
                ISOUtils.paddTwoDigits(builder, date.get(5));
                break;
            }
            case ISO8601_EXTENDED: {
                builder.append(date.get(1));
                builder.append("-");
                ISOUtils.paddTwoDigits(builder, date.get(2) + 1);
                builder.append("-");
                ISOUtils.paddTwoDigits(builder, date.get(5));
            }
        }
        return builder.toString();
    }

    public static String toISO8601_TimeZone(TimeZone timeZone, ISOFormat format) {
        StringBuilder sb = new StringBuilder();
        double offset = timeZone.getRawOffset() / 1000 / 60 / 60;
        String sOffset = String.valueOf(offset);
        if (sOffset.indexOf(".") != -1) {
            int num = Integer.parseInt(sOffset.substring(sOffset.indexOf(".") + 1));
            if (num > 4) {
                sb.append(sOffset.substring(0, sOffset.indexOf(".")));
                switch (format) {
                    case ISO8601_BASIC: {
                        sb.append("30");
                        break;
                    }
                    case ISO8601_EXTENDED: {
                        sb.append(":30");
                    }
                }
            } else {
                sb.append(sOffset.substring(0, sOffset.indexOf(".")));
                switch (format) {
                    case ISO8601_BASIC: {
                        sb.append("00");
                        break;
                    }
                    case ISO8601_EXTENDED: {
                        sb.append(":00");
                    }
                }
            }
        } else {
            sb.append(sOffset);
            switch (format) {
                case ISO8601_BASIC: {
                    sb.append("00");
                    break;
                }
                case ISO8601_EXTENDED: {
                    sb.append(":00");
                }
            }
        }
        return sb.toString();
    }

    private static void paddTwoDigits(StringBuilder sb, int number) {
        if (number < 10) {
            sb.append("0");
            sb.append(number);
        } else {
            sb.append(number);
        }
    }
}

