/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.util;

public final class StringUtil {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private StringUtil() {
    }

    public static int countInstanceOf(String target, char instance) {
        return StringUtil.countInstanceOf(target, String.valueOf(instance));
    }

    public static int countInstanceOf(String target, String instance) {
        int fieldNum = 0;
        int pos = 0;
        int val = 0;
        boolean stop = false;
        while (!stop) {
            val = target.indexOf(instance, pos);
            if (val != -1) {
                ++fieldNum;
                pos = val + 1;
                continue;
            }
            stop = true;
        }
        return fieldNum;
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            sb.append(new char[]{HEX_CHARS[b >> 4 & 0xF], HEX_CHARS[b & 0xF]});
        }
        return sb.toString();
    }

    public static String formatException(Throwable ex) {
        StringBuilder sb = new StringBuilder();
        sb.append(ex.getMessage());
        sb.append("\n");
        StackTraceElement[] trace = ex.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            sb.append("\t");
            sb.append(trace[i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String padStringWith(String string, int length, char charToPad) {
        int len;
        if (string.length() == length) {
            return string;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(string);
        for (int i = len = sb.length(); i < length; ++i) {
            sb.insert(0, charToPad);
        }
        return sb.toString();
    }
}

