/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.Timer;

public final class Util {
    private Util() {
    }

    public static <E> List<E> asList(E[] array) {
        ArrayList<E> list = new ArrayList<E>(array.length);
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    public static int generateHashCode(String ... args) {
        int i;
        int length = 0;
        char[] cArray = null;
        if (args.length == 1) {
            length = args[0].length();
            cArray = args[0].toCharArray();
        } else {
            for (int i2 = 0; i2 < args.length; ++i2) {
                length += args[i2].length();
            }
            cArray = new char[length];
            int incrementer = 0;
            for (i = 0; i < args.length; ++i) {
                String str = args[i];
                for (int j = 0; j < str.length(); ++j) {
                    cArray[incrementer] = str.charAt(j);
                    ++incrementer;
                }
            }
        }
        int h = 0;
        for (i = 0; i < cArray.length; ++i) {
            h = 31 * h + cArray[i];
        }
        return h;
    }

    public static byte[] getFileAsBytes(File file) throws IOException {
        byte[] bytes = new byte[(int)file.length()];
        BufferedReader br = new BufferedReader(new FileReader(file));
        int i = 0;
        int b = -1;
        while ((b = br.read()) != -1) {
            bytes[i] = (byte)b;
            ++i;
        }
        br.close();
        return bytes;
    }

    public static void center(Window w) {
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int windowWidth = w.getWidth();
        int windowHeight = w.getHeight();
        if (windowHeight > screenHeight) {
            return;
        }
        if (windowWidth > screenWidth) {
            return;
        }
        int x = (screenWidth - windowWidth) / 2;
        int y = (screenHeight - windowHeight) / 2;
        w.setLocation(x, y);
    }

    public static void maximizeFrame(Frame frame) {
        frame.setExtendedState(6);
    }

    public static void iconifyFrame(Frame frame) {
        frame.setExtendedState(1);
    }

    public static void restoreFrame(Frame frame) {
        frame.setExtendedState(0);
    }

    public static int getScreenHeight() {
        return Toolkit.getDefaultToolkit().getScreenSize().height;
    }

    public static int getScreenWidth() {
        return Toolkit.getDefaultToolkit().getScreenSize().width;
    }

    public static void showSplashWindow(String message, Font messageFont, int duration, Dimension windowSize, Window frameOwner) {
        JLabel saved = new JLabel(message);
        saved.setHorizontalAlignment(0);
        saved.setOpaque(true);
        saved.setFont(messageFont);
        final JWindow window = new JWindow(frameOwner);
        window.add((Component)saved, "Center");
        window.setSize(windowSize);
        saved.setBorder(BorderFactory.createEtchedBorder(0));
        Util.center(window);
        window.setVisible(true);
        Timer timer = new Timer(duration, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                window.setVisible(false);
                window.dispose();
            }
        });
        timer.setRepeats(false);
        timer.start();
    }
}

