/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.util;

import info.ineighborhood.cardme.io.FoldingScheme;
import java.text.NumberFormat;

public final class VCardUtils {
    public static final String CR = "\r";
    public static final String LF = "\n";
    public static final String HT = "\t";
    public static final String SP = " ";
    public static final String CRLF = "\r\n";
    public static final String LABEL_DELIMETER = "=";
    private static final char[] NEED_ESCAPING = new char[]{',', ';', ':', '\\', '\n'};
    private static final String[] NEED_UNESCAPING = new String[]{"\\n", "\\N", "\\\\\\", "\\,", "\\;", "\\:"};
    private static final NumberFormat GEO_NUM_FORMATTER = NumberFormat.getNumberInstance();

    private VCardUtils() {
        GEO_NUM_FORMATTER.setMinimumFractionDigits(6);
        GEO_NUM_FORMATTER.setMaximumFractionDigits(6);
        GEO_NUM_FORMATTER.setMaximumIntegerDigits(6);
        GEO_NUM_FORMATTER.setMinimumIntegerDigits(1);
        GEO_NUM_FORMATTER.setGroupingUsed(false);
    }

    public static boolean needsEscaping(String text) {
        boolean needs = false;
        for (int i = 0; i < NEED_ESCAPING.length; ++i) {
            if (text.indexOf(NEED_ESCAPING[i]) == -1) continue;
            needs = true;
            break;
        }
        return needs;
    }

    public static boolean needsUnEscaping(String text) {
        boolean needs = false;
        for (int i = 0; i < NEED_UNESCAPING.length; ++i) {
            if (text.indexOf(NEED_UNESCAPING[i]) == -1) continue;
            needs = true;
            break;
        }
        return needs;
    }

    public static String unescapeString(String text) {
        String unescaped = text.replaceAll("\\\\n", LF);
        unescaped = unescaped.replaceAll("\\\\N", LF);
        unescaped = unescaped.replaceAll("\\\\\\\\", "\\\\");
        unescaped = unescaped.replaceAll("\\\\,", ",");
        unescaped = unescaped.replaceAll("\\\\;", ";");
        unescaped = unescaped.replaceAll("\\\\:", ":");
        return unescaped;
    }

    public static String escapeString(String text) {
        if (!VCardUtils.needsEscaping(text)) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text.length());
        block7: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\n': {
                    sb.append('\\');
                    sb.append('n');
                    continue block7;
                }
                case '\\': {
                    sb.append('\\');
                    sb.append('\\');
                    continue block7;
                }
                case ',': {
                    sb.append('\\');
                    sb.append(',');
                    continue block7;
                }
                case ';': {
                    sb.append('\\');
                    sb.append(';');
                    continue block7;
                }
                case ':': {
                    sb.append('\\');
                    sb.append(':');
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static boolean needsFolding(String line) {
        return VCardUtils.needsFolding(line, FoldingScheme.MIME_DIR);
    }

    public static boolean needsFolding(String line, FoldingScheme foldingScheme) {
        if (foldingScheme.getMaxChars() < 0) {
            return false;
        }
        return line.length() > foldingScheme.getMaxChars();
    }

    public static String unfoldVCard(String vcardString) {
        String unfold1 = vcardString.replaceAll("=\n\\p{Blank}+", "");
        String unfold2 = unfold1.replaceAll("\n\\p{Blank}+", "");
        return unfold2;
    }

    public static String foldLine(String thisLine) {
        return VCardUtils.foldLine(thisLine, FoldingScheme.MIME_DIR);
    }

    public static String foldLine(String thisLine, FoldingScheme foldingScheme) {
        return VCardUtils.foldLine(thisLine, CRLF, foldingScheme);
    }

    public static String foldLine(String thisLine, String eolDelimeter, FoldingScheme foldingScheme) {
        if (!VCardUtils.needsFolding(thisLine, foldingScheme)) {
            return thisLine;
        }
        boolean loop = true;
        boolean first = true;
        int crnt = 0;
        int prev = 0;
        StringBuilder builder = new StringBuilder();
        while (loop) {
            prev = crnt;
            if ((crnt += foldingScheme.getMaxChars()) > thisLine.length()) {
                if (prev < thisLine.length()) {
                    if (!first) {
                        builder.append(foldingScheme.getIndent());
                    }
                    builder.append(thisLine.substring(prev).trim());
                    if (eolDelimeter != null) {
                        builder.append(eolDelimeter);
                    }
                }
                loop = false;
                continue;
            }
            if (!first) {
                builder.append(foldingScheme.getIndent());
            } else {
                first = false;
            }
            builder.append(thisLine.substring(prev, crnt).trim());
            if (eolDelimeter == null) continue;
            builder.append(eolDelimeter);
        }
        return builder.toString().trim();
    }

    public static NumberFormat getGeographicPositionFormatter() {
        return GEO_NUM_FORMATTER;
    }
}

