/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard;

import info.ineighborhood.cardme.db.MarkType;
import info.ineighborhood.cardme.db.Persistable;
import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.ProblemSeverity;
import info.ineighborhood.cardme.vcard.VCard;
import info.ineighborhood.cardme.vcard.VCardVersion;
import info.ineighborhood.cardme.vcard.errors.ErrorSeverity;
import info.ineighborhood.cardme.vcard.errors.VCardError;
import info.ineighborhood.cardme.vcard.errors.VCardErrorHandling;
import info.ineighborhood.cardme.vcard.errors.VCardException;
import info.ineighborhood.cardme.vcard.features.AddressFeature;
import info.ineighborhood.cardme.vcard.features.AgentFeature;
import info.ineighborhood.cardme.vcard.features.BeginFeature;
import info.ineighborhood.cardme.vcard.features.BirthdayFeature;
import info.ineighborhood.cardme.vcard.features.CategoriesFeature;
import info.ineighborhood.cardme.vcard.features.ClassFeature;
import info.ineighborhood.cardme.vcard.features.DisplayableNameFeature;
import info.ineighborhood.cardme.vcard.features.EmailFeature;
import info.ineighborhood.cardme.vcard.features.EndFeature;
import info.ineighborhood.cardme.vcard.features.ExtendedFeature;
import info.ineighborhood.cardme.vcard.features.FormattedNameFeature;
import info.ineighborhood.cardme.vcard.features.GeographicPositionFeature;
import info.ineighborhood.cardme.vcard.features.KeyFeature;
import info.ineighborhood.cardme.vcard.features.LabelFeature;
import info.ineighborhood.cardme.vcard.features.LogoFeature;
import info.ineighborhood.cardme.vcard.features.MailerFeature;
import info.ineighborhood.cardme.vcard.features.NameFeature;
import info.ineighborhood.cardme.vcard.features.NicknameFeature;
import info.ineighborhood.cardme.vcard.features.NoteFeature;
import info.ineighborhood.cardme.vcard.features.OrganizationFeature;
import info.ineighborhood.cardme.vcard.features.PhotoFeature;
import info.ineighborhood.cardme.vcard.features.ProductIdFeature;
import info.ineighborhood.cardme.vcard.features.ProfileFeature;
import info.ineighborhood.cardme.vcard.features.RevisionFeature;
import info.ineighborhood.cardme.vcard.features.RoleFeature;
import info.ineighborhood.cardme.vcard.features.SortStringFeature;
import info.ineighborhood.cardme.vcard.features.SoundFeature;
import info.ineighborhood.cardme.vcard.features.SourceFeature;
import info.ineighborhood.cardme.vcard.features.TelephoneFeature;
import info.ineighborhood.cardme.vcard.features.TimeZoneFeature;
import info.ineighborhood.cardme.vcard.features.TitleFeature;
import info.ineighborhood.cardme.vcard.features.TypeTools;
import info.ineighborhood.cardme.vcard.features.UIDFeature;
import info.ineighborhood.cardme.vcard.features.URLFeature;
import info.ineighborhood.cardme.vcard.features.VersionFeature;
import info.ineighborhood.cardme.vcard.types.VersionType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VCardImpl
implements VCard,
VCardErrorHandling,
Persistable,
Serializable {
    private String id = null;
    private MarkType markType = MarkType.UNMARKED;
    private BeginFeature begin = null;
    private EndFeature end = null;
    private DisplayableNameFeature displayableName = null;
    private ProfileFeature profile = null;
    private SourceFeature source = null;
    private FormattedNameFeature formattedName = null;
    private NameFeature name = null;
    private NicknameFeature nicknames = null;
    private List<PhotoFeature> photos = null;
    private BirthdayFeature birthday = null;
    private List<AddressFeature> addresses = null;
    private Map<AddressFeature, LabelFeature> addressLabelMap = null;
    private List<TelephoneFeature> telephoneNumbers = null;
    private List<EmailFeature> emailAddresses = null;
    private MailerFeature mailer = null;
    private TimeZoneFeature timeZone = null;
    private GeographicPositionFeature geographicPosition = null;
    private TitleFeature title = null;
    private RoleFeature role = null;
    private List<LogoFeature> logos = null;
    private List<AgentFeature> agents = null;
    private OrganizationFeature organizations = null;
    private CategoriesFeature categories = null;
    private List<NoteFeature> notes = null;
    private ProductIdFeature productId = null;
    private RevisionFeature revision = null;
    private SortStringFeature sortString = null;
    private List<SoundFeature> sounds = null;
    private UIDFeature uid = null;
    private List<URLFeature> urls = null;
    private VersionFeature version = null;
    private ClassFeature securityClass = null;
    private List<KeyFeature> keys = null;
    private List<ExtendedFeature> extendedTypes = null;
    private boolean isValid = true;
    private boolean isThrowsExceptions = true;
    private ProblemSeverity problemSeverity = ProblemSeverity.NONE;
    private List<VCardError> errors = null;

    public VCardImpl() {
        this.version = new VersionType(VCardVersion.V3_0);
        this.photos = new ArrayList<PhotoFeature>();
        this.addresses = new ArrayList<AddressFeature>();
        this.addressLabelMap = new HashMap<AddressFeature, LabelFeature>();
        this.telephoneNumbers = new ArrayList<TelephoneFeature>();
        this.emailAddresses = new ArrayList<EmailFeature>();
        this.logos = new ArrayList<LogoFeature>();
        this.agents = new ArrayList<AgentFeature>();
        this.notes = new ArrayList<NoteFeature>();
        this.sounds = new ArrayList<SoundFeature>();
        this.urls = new ArrayList<URLFeature>();
        this.keys = new ArrayList<KeyFeature>();
        this.extendedTypes = new ArrayList<ExtendedFeature>();
        this.errors = new ArrayList<VCardError>();
    }

    @Override
    public BeginFeature getBegin() {
        return this.begin;
    }

    @Override
    public EndFeature getEnd() {
        return this.end;
    }

    @Override
    public DisplayableNameFeature getDisplayableNameFeature() {
        return this.displayableName;
    }

    @Override
    public ProfileFeature getProfile() {
        return this.profile;
    }

    @Override
    public SourceFeature getSource() {
        return this.source;
    }

    @Override
    public boolean hasBegin() {
        return this.begin != null;
    }

    @Override
    public boolean hasEnd() {
        return this.end != null;
    }

    @Override
    public boolean hasDisplayableNameFeature() {
        return this.displayableName != null;
    }

    @Override
    public boolean hasProfile() {
        return this.profile != null;
    }

    @Override
    public boolean hasSource() {
        return this.source != null;
    }

    @Override
    public void setBegin(BeginFeature begin) throws NullPointerException {
        if (begin == null) {
            throw new NullPointerException("begin cannot be set to null.");
        }
        this.begin = begin;
    }

    @Override
    public void setEnd(EndFeature end) throws NullPointerException {
        if (end == null) {
            throw new NullPointerException("end cannot be set to null.");
        }
        this.end = end;
    }

    @Override
    public void setDisplayableNameFeature(DisplayableNameFeature name) {
        this.displayableName = name;
    }

    @Override
    public void setProfile(ProfileFeature profile) {
        this.profile = profile;
    }

    @Override
    public void setSource(SourceFeature source) {
        this.source = source;
    }

    @Override
    public FormattedNameFeature getFormattedName() {
        return this.formattedName;
    }

    @Override
    public void setFormattedName(FormattedNameFeature formattedName) throws NullPointerException {
        if (formattedName == null) {
            throw new NullPointerException("formattedName cannot be set to null.");
        }
        this.formattedName = formattedName;
    }

    @Override
    public NameFeature getName() {
        return this.name;
    }

    @Override
    public void setName(NameFeature name) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("name cannot be set to null.");
        }
        this.name = name;
    }

    @Override
    public void setNicknames(NicknameFeature nicknames) {
        this.nicknames = nicknames;
    }

    @Override
    public NicknameFeature getNicknames() {
        return this.nicknames;
    }

    @Override
    public boolean hasNicknames() {
        return this.nicknames != null;
    }

    @Override
    public Iterator<PhotoFeature> getPhotos() {
        return this.photos.iterator();
    }

    @Override
    public void addPhoto(PhotoFeature photo) throws NullPointerException {
        if (photo == null) {
            throw new NullPointerException("Cannot add a null photo.");
        }
        this.photos.add(photo);
    }

    @Override
    public void removePhoto(PhotoFeature photo) throws NullPointerException {
        if (photo == null) {
            throw new NullPointerException("Cannot remove a null photo.");
        }
        this.photos.remove(photo);
    }

    @Override
    public boolean containsPhoto(PhotoFeature photo) {
        if (photo == null) {
            return false;
        }
        return this.photos.contains(photo);
    }

    @Override
    public void addAllPhotos(Collection<PhotoFeature> photos) throws NullPointerException {
        if (photos == null) {
            throw new NullPointerException("Cannot add a null collection of photos.");
        }
        this.photos.addAll(photos);
    }

    @Override
    public void clearPhotos() {
        this.photos.clear();
    }

    @Override
    public boolean hasPhotos() {
        return !this.photos.isEmpty();
    }

    @Override
    public BirthdayFeature getBirthDay() {
        return this.birthday;
    }

    @Override
    public void setBirthday(BirthdayFeature birthday) {
        this.birthday = birthday;
    }

    @Override
    public boolean hasBirthday() {
        return this.birthday != null;
    }

    @Override
    public Iterator<AddressFeature> getAddresses() {
        return this.addresses.iterator();
    }

    @Override
    public void addAddress(AddressFeature address) throws NullPointerException {
        if (address == null) {
            throw new NullPointerException("Cannot add a null address.");
        }
        this.addresses.add(address);
    }

    @Override
    public void removeAddress(AddressFeature address) throws NullPointerException {
        if (address == null) {
            throw new NullPointerException("Cannot remove a null address.");
        }
        this.addresses.remove(address);
    }

    @Override
    public boolean containsAddress(AddressFeature address) {
        if (address == null) {
            return false;
        }
        return this.addresses.contains(address);
    }

    @Override
    public void addAllAddresses(Collection<AddressFeature> addresses) throws NullPointerException {
        if (addresses == null) {
            throw new NullPointerException("Cannot add a null collection of addresses.");
        }
        this.addresses.addAll(addresses);
    }

    @Override
    public void clearAddresses() {
        this.addresses.clear();
    }

    @Override
    public boolean hasAddresses() {
        return !this.addresses.isEmpty();
    }

    @Override
    public Iterator<LabelFeature> getLables() {
        return this.addressLabelMap.values().iterator();
    }

    @Override
    public LabelFeature getLabelFor(AddressFeature address) {
        if (address == null) {
            return null;
        }
        if (this.addressLabelMap.containsKey(address)) {
            return this.addressLabelMap.get(address);
        }
        return null;
    }

    @Override
    public void setLabel(LabelFeature label, AddressFeature forAddress) throws NullPointerException, VCardException {
        if (label == null) {
            throw new NullPointerException("Cannot set a null label for an address.");
        }
        if (forAddress == null) {
            throw new NullPointerException("Cannot set a label for a null address.");
        }
        if (!this.addresses.contains(forAddress)) {
            throw new VCardException("Trying to set a label for a non-existing address.");
        }
        this.addressLabelMap.put(forAddress, label);
    }

    @Override
    public void removeLabel(LabelFeature label, AddressFeature forAddress) throws NullPointerException, VCardException {
        if (label == null) {
            throw new NullPointerException("Cannot remove a null label from an address.");
        }
        if (forAddress == null) {
            throw new NullPointerException("Cannot remove a label from a null address.");
        }
        if (!this.addresses.contains(forAddress)) {
            throw new VCardException("Trying to remove a label for a non-existing address.");
        }
        this.addressLabelMap.remove(forAddress);
    }

    @Override
    public boolean hasLabel(AddressFeature address) {
        if (address == null) {
            return false;
        }
        return this.addressLabelMap.containsKey(address);
    }

    @Override
    public void clearLabels() {
        this.addressLabelMap.clear();
    }

    @Override
    public boolean containsLabel(LabelFeature label) {
        if (label == null) {
            return false;
        }
        return this.addressLabelMap.containsValue(label);
    }

    @Override
    public Iterator<TelephoneFeature> getTelephoneNumbers() {
        return this.telephoneNumbers.iterator();
    }

    @Override
    public void addTelephoneNumber(TelephoneFeature phoneNumber) throws NullPointerException {
        if (phoneNumber == null) {
            throw new NullPointerException("Cannot add a null phone number.");
        }
        this.telephoneNumbers.add(phoneNumber);
    }

    @Override
    public void removeTelephoneNumber(TelephoneFeature phoneNumber) throws NullPointerException {
        if (phoneNumber == null) {
            throw new NullPointerException("Cannot remove a null phone number.");
        }
        this.telephoneNumbers.remove(phoneNumber);
    }

    @Override
    public boolean containsTelephoneNumber(TelephoneFeature phoneNumber) {
        if (phoneNumber == null) {
            return false;
        }
        return this.telephoneNumbers.contains(phoneNumber);
    }

    @Override
    public void addAllTelephoneNumber(Collection<TelephoneFeature> phoneNumbers) throws NullPointerException {
        if (phoneNumbers == null) {
            throw new NullPointerException("Cannot add a null collection of phone numbers.");
        }
        this.telephoneNumbers.addAll(phoneNumbers);
    }

    @Override
    public void clearTelephoneNumbers() {
        this.telephoneNumbers.clear();
    }

    @Override
    public boolean hasTelephoneNumbers() {
        return !this.telephoneNumbers.isEmpty();
    }

    @Override
    public Iterator<EmailFeature> getEmails() {
        return this.emailAddresses.iterator();
    }

    @Override
    public void addEmail(EmailFeature email) throws NullPointerException {
        if (email == null) {
            throw new NullPointerException("Cannot add a null email.");
        }
        this.emailAddresses.add(email);
    }

    @Override
    public void removeEmail(EmailFeature email) throws NullPointerException {
        if (email == null) {
            throw new NullPointerException("Cannot remove a null email.");
        }
        this.emailAddresses.remove(email);
    }

    @Override
    public boolean containsEmail(EmailFeature email) {
        if (email == null) {
            return false;
        }
        return this.emailAddresses.contains(email);
    }

    @Override
    public void addAllEmails(Collection<EmailFeature> emailAddresses) throws NullPointerException {
        if (emailAddresses == null) {
            throw new NullPointerException("Cannot add a null collection of emails.");
        }
        this.emailAddresses.addAll(emailAddresses);
    }

    @Override
    public void clearEmails() {
        this.emailAddresses.clear();
    }

    @Override
    public boolean hasEmails() {
        return !this.emailAddresses.isEmpty();
    }

    @Override
    public MailerFeature getMailer() {
        return this.mailer;
    }

    @Override
    public void setMailer(MailerFeature mailer) {
        this.mailer = mailer;
    }

    @Override
    public boolean hasMailer() {
        return this.mailer != null;
    }

    @Override
    public TimeZoneFeature getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void setTimeZone(TimeZoneFeature timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public boolean hasTimeZone() {
        return this.timeZone != null;
    }

    @Override
    public GeographicPositionFeature getGeographicPosition() {
        return this.geographicPosition;
    }

    @Override
    public void setGeographicPosition(GeographicPositionFeature geographicPosition) {
        this.geographicPosition = geographicPosition;
    }

    @Override
    public boolean hasGeographicPosition() {
        return this.geographicPosition != null;
    }

    @Override
    public TitleFeature getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(TitleFeature title) {
        this.title = title;
    }

    @Override
    public boolean hasTitle() {
        return this.title != null;
    }

    @Override
    public RoleFeature getRole() {
        return this.role;
    }

    @Override
    public void setRole(RoleFeature role) {
        this.role = role;
    }

    @Override
    public boolean hasRole() {
        return this.role != null;
    }

    @Override
    public Iterator<LogoFeature> getLogos() {
        return this.logos.iterator();
    }

    @Override
    public void addLogo(LogoFeature logo) throws NullPointerException {
        if (logo == null) {
            throw new NullPointerException("Cannot add a null logo.");
        }
        this.logos.add(logo);
    }

    @Override
    public void removeLogo(LogoFeature logo) throws NullPointerException {
        if (logo == null) {
            throw new NullPointerException("Cannot remove a null logo.");
        }
        this.logos.remove(logo);
    }

    @Override
    public boolean containsLogo(LogoFeature logo) {
        if (logo == null) {
            return false;
        }
        return this.logos.contains(logo);
    }

    @Override
    public void addAllLogos(Collection<LogoFeature> logos) throws NullPointerException {
        if (logos == null) {
            throw new NullPointerException("Cannot add a null collection of logos.");
        }
        this.logos.addAll(logos);
    }

    @Override
    public void clearLogos() {
        this.logos.clear();
    }

    @Override
    public boolean hasLogos() {
        return !this.logos.isEmpty();
    }

    @Override
    public Iterator<AgentFeature> getAgents() {
        return this.agents.iterator();
    }

    @Override
    public void addAgent(AgentFeature agent) throws NullPointerException {
        if (agent == null) {
            throw new NullPointerException("Cannot add a null agent.");
        }
        this.agents.add(agent);
    }

    @Override
    public void removeAgent(AgentFeature agent) throws NullPointerException {
        if (agent == null) {
            throw new NullPointerException("Cannot remove a null agent.");
        }
        this.agents.remove(agent);
    }

    @Override
    public boolean containsAgent(AgentFeature agent) {
        return this.agents.contains(agent);
    }

    @Override
    public void addAllAgents(Collection<AgentFeature> agents) throws NullPointerException {
        if (agents == null) {
            throw new NullPointerException("Cannot add a null collection of agents.");
        }
        this.agents.addAll(agents);
    }

    @Override
    public void clearAgents() {
        this.agents.clear();
    }

    @Override
    public boolean hasAgents() {
        return !this.agents.isEmpty();
    }

    @Override
    public OrganizationFeature getOrganizations() {
        return this.organizations;
    }

    @Override
    public void setOrganizations(OrganizationFeature organizations) throws NullPointerException {
        this.organizations = organizations;
    }

    @Override
    public boolean hasOrganizations() {
        return this.organizations != null;
    }

    @Override
    public CategoriesFeature getCategories() {
        return this.categories;
    }

    @Override
    public void setCategories(CategoriesFeature categories) {
        this.categories = categories;
    }

    @Override
    public boolean hasCategories() {
        return this.categories != null;
    }

    @Override
    public Iterator<NoteFeature> getNotes() {
        return this.notes.iterator();
    }

    @Override
    public void addNote(NoteFeature note) throws NullPointerException {
        if (note == null) {
            throw new NullPointerException("Cannot add a null note.");
        }
        this.notes.add(note);
    }

    @Override
    public void removeNote(NoteFeature note) throws NullPointerException {
        if (note == null) {
            throw new NullPointerException("Cannot remove a null note.");
        }
        this.notes.remove(note);
    }

    @Override
    public boolean containsNote(NoteFeature note) {
        return this.notes.contains(note);
    }

    @Override
    public void addAllNotes(Collection<NoteFeature> notes) {
        if (notes == null) {
            throw new NullPointerException("Cannot add a null collection of notes.");
        }
        this.notes.addAll(notes);
    }

    @Override
    public void clearNotes() {
        this.notes.clear();
    }

    @Override
    public boolean hasNotes() {
        return !this.notes.isEmpty();
    }

    @Override
    public ProductIdFeature getProductId() {
        return this.productId;
    }

    @Override
    public void setProductId(ProductIdFeature productId) {
        this.productId = productId;
    }

    @Override
    public boolean hasProductId() {
        return this.productId != null;
    }

    @Override
    public RevisionFeature getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(RevisionFeature revision) {
        this.revision = revision;
    }

    @Override
    public boolean hasRevision() {
        return this.revision != null;
    }

    @Override
    public SortStringFeature getSortString() {
        return this.sortString;
    }

    @Override
    public void setSortString(SortStringFeature sortString) {
        this.sortString = sortString;
    }

    @Override
    public boolean hasSortString() {
        return this.sortString != null;
    }

    @Override
    public Iterator<SoundFeature> getSounds() {
        return this.sounds.iterator();
    }

    @Override
    public void addSound(SoundFeature sound) throws NullPointerException {
        if (sound == null) {
            throw new NullPointerException("Cannot add a null sound.");
        }
        this.sounds.add(sound);
    }

    @Override
    public void removeSound(SoundFeature sound) throws NullPointerException {
        if (sound == null) {
            throw new NullPointerException("Cannot remove a null sound.");
        }
        this.sounds.remove(sound);
    }

    @Override
    public boolean containsSound(SoundFeature sound) {
        if (sound == null) {
            return false;
        }
        return this.sounds.contains(sound);
    }

    @Override
    public void addAllSounds(Collection<SoundFeature> sounds) throws NullPointerException {
        if (sounds == null) {
            throw new NullPointerException("Cannot add a null collection of sounds.");
        }
        this.sounds.addAll(sounds);
    }

    @Override
    public void clearSounds() {
        this.sounds.clear();
    }

    @Override
    public boolean hasSounds() {
        return !this.sounds.isEmpty();
    }

    @Override
    public UIDFeature getUID() {
        return this.uid;
    }

    @Override
    public void setUID(UIDFeature uid) {
        this.uid = uid;
    }

    @Override
    public boolean hasUID() {
        return this.uid != null;
    }

    @Override
    public Iterator<URLFeature> getURLs() {
        return this.urls.iterator();
    }

    @Override
    public void addURL(URLFeature url) throws NullPointerException {
        if (url == null) {
            throw new NullPointerException("Cannot add a null URL.");
        }
        this.urls.add(url);
    }

    @Override
    public void removeURL(URLFeature url) throws NullPointerException {
        if (url == null) {
            throw new NullPointerException("Cannot remove a null URL.");
        }
        this.urls.remove(url);
    }

    @Override
    public boolean containsURL(URLFeature url) {
        if (url == null) {
            return false;
        }
        return this.urls.contains(url);
    }

    @Override
    public void addAllURLs(Collection<URLFeature> urls) throws NullPointerException {
        if (urls == null) {
            throw new NullPointerException("Cannot add a null collection of urls.");
        }
        this.urls.addAll(urls);
    }

    @Override
    public void clearURLs() {
        this.urls.clear();
    }

    @Override
    public boolean hasURLs() {
        return !this.urls.isEmpty();
    }

    @Override
    public VersionFeature getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(VersionFeature version) throws NullPointerException {
        if (version == null) {
            throw new NullPointerException("version cannot be null.");
        }
        this.version = version;
    }

    @Override
    public ClassFeature getSecurityClass() {
        return this.securityClass;
    }

    @Override
    public void setSecurityClass(ClassFeature securityClass) {
        this.securityClass = securityClass;
    }

    @Override
    public boolean hasSecurityClass() {
        return this.securityClass != null;
    }

    @Override
    public Iterator<KeyFeature> getKeys() {
        return this.keys.iterator();
    }

    @Override
    public void addKey(KeyFeature key) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("Cannot add a null key.");
        }
        this.keys.add(key);
    }

    @Override
    public void removeKey(KeyFeature key) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("Cannot remove a null key.");
        }
        this.keys.remove(key);
    }

    @Override
    public boolean containsKey(KeyFeature key) {
        if (key == null) {
            return false;
        }
        return this.keys.contains(key);
    }

    @Override
    public void addAllKeys(Collection<KeyFeature> keys) throws NullPointerException {
        if (keys == null) {
            throw new NullPointerException("Cannot add a null collection of keys.");
        }
        this.keys.addAll(keys);
    }

    @Override
    public void clearKeys() {
        this.keys.clear();
    }

    @Override
    public boolean hasKeys() {
        return !this.keys.isEmpty();
    }

    @Override
    public Iterator<ExtendedFeature> getExtendedTypes() {
        return this.extendedTypes.iterator();
    }

    @Override
    public void addExtendedType(ExtendedFeature extension) throws NullPointerException {
        if (extension == null) {
            throw new NullPointerException("Cannot add a null extension.");
        }
        this.extendedTypes.add(extension);
    }

    @Override
    public void removeExtendedType(ExtendedFeature extension) throws NullPointerException {
        if (extension == null) {
            throw new NullPointerException("Cannot remove a null extension.");
        }
        this.extendedTypes.remove(extension);
    }

    @Override
    public boolean containsExtendedType(ExtendedFeature extension) {
        if (extension == null) {
            return false;
        }
        return this.extendedTypes.contains(extension);
    }

    @Override
    public void addAllExtendedTypes(Collection<ExtendedFeature> extensions) throws NullPointerException {
        if (extensions == null) {
            throw new NullPointerException("Cannot add a null collection of extensions.");
        }
        this.extendedTypes.addAll(extensions);
    }

    @Override
    public void clearExtendedTypes() {
        this.extendedTypes.clear();
    }

    @Override
    public boolean hasExtendedTypes() {
        return !this.extendedTypes.isEmpty();
    }

    @Override
    public void clear() {
        this.name.clearAdditionalNames();
        this.name.clearHonorificPrefixes();
        this.name.clearHonorificSuffixes();
        this.name.setFamilyName("");
        this.name.setGivenName("");
        this.formattedName.setFormattedName("");
        this.nicknames = null;
        this.photos.clear();
        this.birthday = null;
        this.addresses.clear();
        this.addressLabelMap.clear();
        this.telephoneNumbers.clear();
        this.emailAddresses.clear();
        this.mailer = null;
        this.timeZone = null;
        this.geographicPosition = null;
        this.title = null;
        this.role = null;
        this.logos.clear();
        this.agents.clear();
        this.organizations = null;
        this.categories = null;
        this.notes.clear();
        this.productId = null;
        this.revision = null;
        this.sortString = null;
        this.sounds.clear();
        this.uid = null;
        this.urls.clear();
        this.version.setVersion(VCardVersion.V3_0);
        this.securityClass = null;
        this.keys.clear();
        this.extendedTypes.clear();
        this.clearErrors();
    }

    @Override
    public List<VCardError> getErrors() {
        return this.errors;
    }

    @Override
    public ProblemSeverity getProblemSeverity() {
        return this.problemSeverity;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void setThrowExceptions(boolean isThrowsExceptions) {
        this.isThrowsExceptions = isThrowsExceptions;
    }

    @Override
    public boolean isThrowExceptions() {
        return this.isThrowsExceptions;
    }

    @Override
    public void addError(VCardError error) {
        if (error != null) {
            this.errors.add(error);
            if (this.isValid) {
                this.isValid = false;
            }
            switch (error.getSeverity()) {
                case FATAL: {
                    switch (this.problemSeverity) {
                        case NONE: 
                        case HINT: 
                        case WARNING: {
                            this.problemSeverity = ProblemSeverity.ERROR;
                        }
                    }
                    break;
                }
                case WARNING: {
                    switch (this.problemSeverity) {
                        case NONE: 
                        case HINT: {
                            this.problemSeverity = ProblemSeverity.WARNING;
                        }
                    }
                    break;
                }
                case NONE: {
                    this.problemSeverity = ProblemSeverity.NONE;
                }
            }
        }
    }

    @Override
    public void addError(String errorMessage, ErrorSeverity severity, Throwable error) {
        if (error != null && severity != null) {
            this.addError(new VCardError(errorMessage, error, severity));
        }
    }

    @Override
    public void clearErrors() {
        this.errors.clear();
        this.problemSeverity = ProblemSeverity.NONE;
        this.isValid = true;
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public MarkType getMarkType() {
        return this.markType;
    }

    @Override
    public void mark(MarkType markType) {
        this.markType = markType;
    }

    @Override
    public void unmark() {
        this.markType = MarkType.UNMARKED;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof VCardImpl) {
                return this == obj || ((VCardImpl)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.begin != null) {
            sb.append(this.begin.toString());
            sb.append(",");
        }
        if (this.end != null) {
            sb.append(this.end.toString());
            sb.append(",");
        }
        if (this.displayableName != null) {
            sb.append(this.displayableName.toString());
            sb.append(",");
        }
        if (this.profile != null) {
            sb.append(this.profile.toString());
            sb.append(",");
        }
        if (this.source != null) {
            sb.append(this.source.toString());
            sb.append(",");
        }
        if (this.formattedName != null) {
            sb.append(this.formattedName.toString());
            sb.append(",");
        }
        if (this.name != null) {
            sb.append(this.name.toString());
            sb.append(",");
        }
        if (this.nicknames != null) {
            sb.append(this.nicknames.toString());
            sb.append(",");
        }
        if (!this.photos.isEmpty()) {
            for (PhotoFeature photo : this.photos) {
                sb.append(photo.toString());
                sb.append(",");
            }
        }
        if (this.birthday != null) {
            sb.append(this.birthday.toString());
            sb.append(",");
        }
        if (!this.addresses.isEmpty()) {
            for (AddressFeature address : this.addresses) {
                sb.append(address.toString());
                sb.append(",");
            }
        }
        if (!this.addressLabelMap.isEmpty()) {
            Iterator<LabelFeature> iter = this.addressLabelMap.values().iterator();
            while (iter.hasNext()) {
                sb.append(iter.next().toString());
                sb.append(",");
            }
        }
        if (!this.telephoneNumbers.isEmpty()) {
            for (TelephoneFeature telephoneNumber : this.telephoneNumbers) {
                sb.append(telephoneNumber.toString());
                sb.append(",");
            }
        }
        if (!this.emailAddresses.isEmpty()) {
            for (EmailFeature emailAddresse : this.emailAddresses) {
                sb.append(emailAddresse.toString());
                sb.append(",");
            }
        }
        if (this.mailer != null) {
            sb.append(this.mailer.toString());
            sb.append(",");
        }
        if (this.timeZone != null) {
            sb.append(this.timeZone.toString());
            sb.append(",");
        }
        if (this.geographicPosition != null) {
            sb.append(this.geographicPosition.toString());
            sb.append(",");
        }
        if (this.title != null) {
            sb.append(this.title.toString());
            sb.append(",");
        }
        if (this.role != null) {
            sb.append(this.role.toString());
            sb.append(",");
        }
        if (!this.logos.isEmpty()) {
            for (LogoFeature logo : this.logos) {
                sb.append(logo.toString());
                sb.append(",");
            }
        }
        if (!this.agents.isEmpty()) {
            for (AgentFeature agent : this.agents) {
                sb.append(agent.toString());
                sb.append(",");
            }
        }
        if (this.organizations != null) {
            sb.append(this.organizations.toString());
            sb.append(",");
        }
        if (this.categories != null) {
            sb.append(this.categories.toString());
            sb.append(",");
        }
        if (!this.notes.isEmpty()) {
            for (NoteFeature note : this.notes) {
                sb.append(note.toString());
                sb.append(",");
            }
        }
        if (this.productId != null) {
            sb.append(this.productId.toString());
            sb.append(",");
        }
        if (this.revision != null) {
            sb.append(this.revision.toString());
            sb.append(",");
        }
        if (this.sortString != null) {
            sb.append(this.sortString.toString());
            sb.append(",");
        }
        if (!this.sounds.isEmpty()) {
            for (SoundFeature sound : this.sounds) {
                sb.append(sound.toString());
            }
        }
        if (this.uid != null) {
            sb.append(this.uid.toString());
            sb.append(",");
        }
        if (!this.urls.isEmpty()) {
            for (URLFeature url : this.urls) {
                sb.append(url.toString());
                sb.append(",");
            }
        }
        if (this.version != null) {
            sb.append(this.version.toString());
            sb.append(",");
        }
        if (this.securityClass != null) {
            sb.append(this.securityClass.toString());
            sb.append(",");
        }
        if (!this.keys.isEmpty()) {
            for (KeyFeature key : this.keys) {
                sb.append(key.toString());
                sb.append(",");
            }
        }
        if (!this.extendedTypes.isEmpty()) {
            for (ExtendedFeature extendedType : this.extendedTypes) {
                sb.append(extendedType.toString());
                sb.append(",");
            }
        }
        sb.append(this.problemSeverity.toString());
        sb.append(",");
        if (!this.errors.isEmpty()) {
            for (VCardError error : this.errors) {
                sb.append(error.toString());
                sb.append(",");
            }
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public VCard clone() {
        Iterator<TypeTools> iter;
        VCardImpl cloned = new VCardImpl();
        if (this.begin != null) {
            cloned.setBegin(this.begin.clone());
        }
        if (this.end != null) {
            cloned.setEnd(this.end.clone());
        }
        if (this.displayableName != null) {
            cloned.setDisplayableNameFeature(this.displayableName.clone());
        }
        if (this.profile != null) {
            cloned.setProfile(this.profile.clone());
        }
        if (this.source != null) {
            cloned.setSource(this.source.clone());
        }
        if (this.formattedName != null) {
            cloned.setFormattedName(this.formattedName.clone());
        }
        if (this.name != null) {
            cloned.setName(this.name.clone());
        }
        if (this.hasNicknames()) {
            cloned.setNicknames(this.nicknames.clone());
        }
        if (this.hasPhotos()) {
            iter = this.getPhotos();
            while (iter.hasNext()) {
                PhotoFeature photo = iter.next();
                cloned.addPhoto(photo.clone());
            }
        }
        if (this.hasBirthday()) {
            cloned.setBirthday(this.birthday.clone());
        }
        if (this.hasAddresses()) {
            iter = this.getAddresses();
            while (iter.hasNext()) {
                AddressFeature address = (AddressFeature)iter.next();
                AddressFeature clonedAddress = address.clone();
                cloned.addAddress(clonedAddress);
                if (!this.hasLabel(address)) continue;
                LabelFeature label = this.getLabelFor(address);
                cloned.setLabel(label.clone(), clonedAddress);
            }
        }
        if (this.hasTelephoneNumbers()) {
            iter = this.getTelephoneNumbers();
            while (iter.hasNext()) {
                TelephoneFeature telephone = (TelephoneFeature)iter.next();
                cloned.addTelephoneNumber(telephone.clone());
            }
        }
        if (this.hasEmails()) {
            iter = this.getEmails();
            while (iter.hasNext()) {
                EmailFeature email = (EmailFeature)iter.next();
                cloned.addEmail(email.clone());
            }
        }
        if (this.hasMailer()) {
            cloned.setMailer(this.mailer.clone());
        }
        if (this.hasTimeZone()) {
            cloned.setTimeZone(this.timeZone.clone());
        }
        if (this.hasGeographicPosition()) {
            cloned.setGeographicPosition(this.geographicPosition.clone());
        }
        if (this.hasTitle()) {
            cloned.setTitle(this.title.clone());
        }
        if (this.hasRole()) {
            cloned.setRole(this.role.clone());
        }
        if (this.hasLogos()) {
            iter = this.getLogos();
            while (iter.hasNext()) {
                LogoFeature logo = (LogoFeature)iter.next();
                cloned.addLogo(logo.clone());
            }
        }
        if (this.hasAgents()) {
            iter = this.getAgents();
            while (iter.hasNext()) {
                AgentFeature agent = (AgentFeature)iter.next();
                cloned.addAgent(agent.clone());
            }
        }
        if (this.hasOrganizations()) {
            cloned.setOrganizations(this.organizations.clone());
        }
        if (this.hasCategories()) {
            cloned.setCategories(this.categories.clone());
        }
        if (this.hasNotes()) {
            iter = this.getNotes();
            while (iter.hasNext()) {
                NoteFeature note = (NoteFeature)iter.next();
                cloned.addNote(note.clone());
            }
        }
        if (this.hasProductId()) {
            cloned.setProductId(this.productId.clone());
        }
        if (this.hasRevision()) {
            cloned.setRevision(this.revision.clone());
        }
        if (this.hasSortString()) {
            cloned.setSortString(this.sortString.clone());
        }
        if (this.hasSounds()) {
            iter = this.getSounds();
            while (iter.hasNext()) {
                SoundFeature sound = (SoundFeature)iter.next();
                cloned.addSound(sound.clone());
            }
        }
        if (this.hasUID()) {
            cloned.setUID(this.uid.clone());
        }
        if (this.hasURLs()) {
            iter = this.getURLs();
            while (iter.hasNext()) {
                URLFeature url = (URLFeature)iter.next();
                cloned.addURL(url.clone());
            }
        }
        if (this.version != null) {
            cloned.setVersion(this.version.clone());
        }
        if (this.hasSecurityClass()) {
            cloned.setSecurityClass(this.securityClass.clone());
        }
        if (this.hasKeys()) {
            iter = this.getKeys();
            while (iter.hasNext()) {
                KeyFeature key = (KeyFeature)iter.next();
                cloned.addKey(key.clone());
            }
        }
        if (this.hasExtendedTypes()) {
            iter = this.getExtendedTypes();
            while (iter.hasNext()) {
                ExtendedFeature extension = (ExtendedFeature)iter.next();
                cloned.addExtendedType(extension.clone());
            }
        }
        cloned.setThrowExceptions(this.isThrowsExceptions);
        if (this.hasErrors()) {
            List<VCardError> errs = this.getErrors();
            for (VCardError err : errs) {
                cloned.addError(err.clone());
            }
        }
        if (this.id != null) {
            cloned.setID(this.id);
        }
        return cloned;
    }
}

