/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.errors;

import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.errors.ErrorSeverity;

public class VCardError
implements Cloneable {
    private String errorMessage = null;
    private ErrorSeverity severity = ErrorSeverity.NONE;
    private Throwable error = null;

    public VCardError() {
    }

    public VCardError(Throwable error, ErrorSeverity severity) {
        this(null, error, severity);
    }

    public VCardError(String errorMessage, Throwable error, ErrorSeverity severity) {
        this.setErrorMessage(errorMessage);
        this.setError(error);
        this.setSeverity(severity);
    }

    public String getErrorMessage() {
        if (this.errorMessage == null) {
            return this.error.getMessage();
        }
        return this.errorMessage;
    }

    public ErrorSeverity getSeverity() {
        return this.severity;
    }

    public Throwable getError() {
        return this.error;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public void setSeverity(ErrorSeverity severity) {
        this.severity = severity;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof VCardError) {
                return this == obj || ((VCardError)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.errorMessage != null) {
            sb.append(this.errorMessage);
            sb.append(",");
        }
        sb.append(this.severity.toString());
        sb.append(",");
        if (this.error != null) {
            sb.append(this.error.getMessage());
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    public VCardError clone() {
        VCardError cloned = new VCardError();
        if (this.errorMessage != null) {
            cloned.setErrorMessage(new String(this.errorMessage));
        }
        if (this.error != null) {
            cloned.setError(new Throwable(this.error));
        }
        cloned.setSeverity(this.severity);
        return cloned;
    }
}

