/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.AddressFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.parameters.AddressParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;
import info.ineighborhood.cardme.vcard.types.parameters.XAddressParameterType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class AddressType
extends Type
implements AddressFeature {
    private String postOfficeBox = null;
    private String extendedAddress = null;
    private String streetAddress = null;
    private String locality = null;
    private String region = null;
    private String postalCode = null;
    private String countryName = null;
    private List<AddressParameterType> addressParameterTypes = new ArrayList<AddressParameterType>();
    private List<XAddressParameterType> xtendedAddressParameterTypes = new ArrayList<XAddressParameterType>();

    public AddressType() {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
    }

    @Override
    public String getPostOfficeBox() {
        return this.postOfficeBox;
    }

    @Override
    public String getExtendedAddress() {
        return this.extendedAddress;
    }

    @Override
    public String getStreetAddress() {
        return this.streetAddress;
    }

    @Override
    public String getLocality() {
        return this.locality;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public String getPostalCode() {
        return this.postalCode;
    }

    @Override
    public String getCountryName() {
        return this.countryName;
    }

    @Override
    public void setStreetAddress(String streetAddress) {
        this.streetAddress = streetAddress;
    }

    @Override
    public void setPostOfficeBox(String postOfficeBox) {
        this.postOfficeBox = postOfficeBox;
    }

    @Override
    public void setExtendedAddress(String extendedAddress) {
        this.extendedAddress = extendedAddress;
    }

    @Override
    public void setLocality(String locality) {
        this.locality = locality;
    }

    @Override
    public void setRegion(String region) {
        this.region = region;
    }

    @Override
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    @Override
    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    @Override
    public Iterator<AddressParameterType> getAddressParameterTypes() {
        return this.addressParameterTypes.listIterator();
    }

    @Override
    public List<AddressParameterType> getAddressParameterTypesList() {
        return Collections.unmodifiableList(this.addressParameterTypes);
    }

    @Override
    public int getAddressParameterSize() {
        return this.addressParameterTypes.size();
    }

    @Override
    public void addAddressParameterType(AddressParameterType addressParameterType) {
        this.addressParameterTypes.add(addressParameterType);
    }

    @Override
    public void removeAddressParameterType(AddressParameterType addressParameterType) {
        this.addressParameterTypes.remove((Object)addressParameterType);
    }

    @Override
    public boolean containsAddressParameterType(AddressParameterType addressParameterType) {
        return this.addressParameterTypes.contains((Object)addressParameterType);
    }

    @Override
    public void clearAddressParameterTypes() {
        this.addressParameterTypes.clear();
    }

    @Override
    public Iterator<XAddressParameterType> getExtendedAddressParameterTypes() {
        return this.xtendedAddressParameterTypes.listIterator();
    }

    @Override
    public List<XAddressParameterType> getExtendedAddressParameterTypesList() {
        return Collections.unmodifiableList(this.xtendedAddressParameterTypes);
    }

    @Override
    public int getExtendedAddressParameterSize() {
        return this.xtendedAddressParameterTypes.size();
    }

    @Override
    public void addExtendedAddressParameterType(XAddressParameterType xtendedAddressParameterType) {
        this.xtendedAddressParameterTypes.add(xtendedAddressParameterType);
    }

    @Override
    public void removeExtendedAddressParameterType(XAddressParameterType xtendedAddressParameterType) {
        this.xtendedAddressParameterTypes.remove(xtendedAddressParameterType);
    }

    @Override
    public boolean containsExtendedAddressParameterType(XAddressParameterType xtendedAddressParameterType) {
        return this.xtendedAddressParameterTypes.contains(xtendedAddressParameterType);
    }

    @Override
    public boolean hasExtendedAddressParameterTypes() {
        return !this.xtendedAddressParameterTypes.isEmpty();
    }

    @Override
    public boolean hasPostOfficebox() {
        return this.postOfficeBox != null;
    }

    @Override
    public boolean hasExtendedAddress() {
        return this.extendedAddress != null;
    }

    @Override
    public boolean hasLocality() {
        return this.locality != null;
    }

    @Override
    public boolean hasRegion() {
        return this.region != null;
    }

    @Override
    public boolean hasPostalCode() {
        return this.postalCode != null;
    }

    @Override
    public boolean hasCountryName() {
        return this.countryName != null;
    }

    @Override
    public boolean hasStreetAddress() {
        return this.streetAddress != null;
    }

    @Override
    public boolean hasAddressParameterTypes() {
        return !this.addressParameterTypes.isEmpty();
    }

    @Override
    public String getTypeString() {
        return VCardType.ADR.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof AddressType) {
                return this == obj || ((AddressType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (this.postOfficeBox != null) {
            sb.append(this.postOfficeBox);
            sb.append(",");
        }
        if (this.extendedAddress != null) {
            sb.append(this.extendedAddress);
            sb.append(",");
        }
        if (this.streetAddress != null) {
            sb.append(this.streetAddress);
            sb.append(",");
        }
        if (this.locality != null) {
            sb.append(this.locality);
            sb.append(",");
        }
        if (this.region != null) {
            sb.append(this.region);
            sb.append(",");
        }
        if (this.postalCode != null) {
            sb.append(this.postalCode);
            sb.append(",");
        }
        if (this.countryName != null) {
            sb.append(this.countryName);
            sb.append(",");
        }
        if (!this.addressParameterTypes.isEmpty()) {
            for (i = 0; i < this.addressParameterTypes.size(); ++i) {
                sb.append(this.addressParameterTypes.get(i).getType());
                sb.append(",");
            }
        }
        if (!this.xtendedAddressParameterTypes.isEmpty()) {
            for (i = 0; i < this.xtendedAddressParameterTypes.size(); ++i) {
                sb.append(this.xtendedAddressParameterTypes.get(i).getType());
                sb.append(",");
            }
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public AddressFeature clone() {
        AddressType cloned = new AddressType();
        if (this.postOfficeBox != null) {
            cloned.setPostOfficeBox(this.postOfficeBox);
        }
        if (this.extendedAddress != null) {
            cloned.setExtendedAddress(this.extendedAddress);
        }
        if (this.streetAddress != null) {
            cloned.setExtendedAddress(this.streetAddress);
        }
        if (this.locality != null) {
            cloned.setLocality(this.locality);
        }
        if (this.region != null) {
            cloned.setRegion(this.region);
        }
        if (this.postalCode != null) {
            cloned.setPostalCode(this.postalCode);
        }
        if (this.countryName != null) {
            cloned.setCountryName(this.countryName);
        }
        if (!this.addressParameterTypes.isEmpty()) {
            for (AddressParameterType addressParameterType : this.addressParameterTypes) {
                cloned.addAddressParameterType(addressParameterType);
            }
        }
        if (!this.xtendedAddressParameterTypes.isEmpty()) {
            for (XAddressParameterType xtendedAddressParameterType : this.xtendedAddressParameterTypes) {
                cloned.addExtendedAddressParameterType(xtendedAddressParameterType);
            }
        }
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

