/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCard;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.AgentFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.parameters.AgentParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AgentType
extends Type
implements AgentFeature {
    private URI agentUri = null;
    private VCard agent = null;
    private List<AgentParameterType> agentParameterTypes = null;

    public AgentType() {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.agentParameterTypes = new ArrayList<AgentParameterType>();
    }

    public AgentType(URI agentUri) {
        super(EncodingType.EIGHT_BIT);
        this.setAgentURI(agentUri);
        this.agentParameterTypes = new ArrayList<AgentParameterType>();
    }

    public AgentType(VCard agent) {
        super(EncodingType.EIGHT_BIT);
        this.setAgent(agent);
        this.agentParameterTypes = new ArrayList<AgentParameterType>();
    }

    @Override
    public VCard getAgent() {
        return this.agent;
    }

    @Override
    public Iterator<AgentParameterType> getAgentParameterTypes() {
        return this.agentParameterTypes.listIterator();
    }

    @Override
    public URI getAgentURI() {
        return this.agentUri;
    }

    @Override
    public void setAgent(VCard agent) {
        this.agent = agent;
    }

    @Override
    public void setAgentURI(URI agentUri) {
        this.agentUri = agentUri;
    }

    @Override
    public boolean hasAgent() {
        return this.agentUri != null || this.agent != null;
    }

    @Override
    public boolean isURI() {
        return this.agentUri != null;
    }

    @Override
    public boolean isInline() {
        return this.agent != null;
    }

    @Override
    public void addAgentParameterType(AgentParameterType agentParameterType) {
        this.agentParameterTypes.add(agentParameterType);
    }

    @Override
    public void removeAgentParameterType(AgentParameterType agentParameterType) {
        this.agentParameterTypes.remove((Object)agentParameterType);
    }

    @Override
    public boolean containsAgentParameterType(AgentParameterType agentParameterType) {
        return this.agentParameterTypes.contains((Object)agentParameterType);
    }

    @Override
    public boolean hasAgentParameterTypes() {
        return !this.agentParameterTypes.isEmpty();
    }

    @Override
    public void clearAgentParameterTypes() {
        this.agentParameterTypes.clear();
    }

    @Override
    public String getTypeString() {
        return VCardType.AGENT.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof AgentType) {
                return this == obj || ((AgentType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (this.agentUri != null) {
            sb.append(this.agentUri.getPath());
            sb.append(",");
        }
        if (this.agent != null) {
            sb.append(this.agent.toString());
            sb.append(",");
        }
        if (!this.agentParameterTypes.isEmpty()) {
            for (int i = 0; i < this.agentParameterTypes.size(); ++i) {
                sb.append(this.agentParameterTypes.get(i).getType());
                sb.append(",");
            }
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public AgentFeature clone() {
        AgentType cloned = new AgentType();
        if (this.agentUri != null) {
            try {
                cloned.setAgentURI(new URI(this.agentUri.toString()));
            }
            catch (URISyntaxException e) {
                cloned.setAgentURI(null);
            }
        }
        if (this.agent != null) {
            cloned.setAgent(this.agent.clone());
        }
        if (!this.agentParameterTypes.isEmpty()) {
            for (int i = 0; i < this.agentParameterTypes.size(); ++i) {
                cloned.addAgentParameterType(this.agentParameterTypes.get(i));
            }
        }
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

