/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.BirthdayFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;
import java.util.Calendar;
import java.util.Date;

public class BirthdayType
extends Type
implements BirthdayFeature {
    private Calendar birthday = null;

    public BirthdayType() {
        this((Calendar)null);
    }

    public BirthdayType(Calendar birthday) {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setBirthday(birthday);
    }

    public BirthdayType(Date birthday) {
        super(EncodingType.EIGHT_BIT);
        this.setBirthday(birthday);
    }

    @Override
    public Calendar getBirthday() {
        return this.birthday;
    }

    @Override
    public void setBirthday(Calendar birthday) {
        this.birthday = birthday;
    }

    @Override
    public void setBirthday(Date date) {
        this.birthday.setTime(date);
    }

    @Override
    public String getTypeString() {
        return VCardType.BDAY.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof BirthdayType) {
                return this == obj || ((BirthdayType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (this.birthday != null) {
            sb.append(this.birthday.getTime().toString());
            sb.append(",");
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public BirthdayFeature clone() {
        BirthdayType cloned = new BirthdayType();
        if (this.birthday != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(this.birthday.getTimeInMillis());
            cloned.setBirthday(cal);
        }
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

