/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.CategoriesFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CategoriesType
extends Type
implements CategoriesFeature {
    private List<String> categories = new ArrayList<String>();

    public CategoriesType() {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
    }

    @Override
    public void addCategory(String category) throws NullPointerException {
        if (category == null) {
            throw new NullPointerException("Cannot add a null category.");
        }
        this.categories.add(category);
    }

    @Override
    public Iterator<String> getCategories() {
        return this.categories.listIterator();
    }

    @Override
    public void removeCategory(String category) throws NullPointerException {
        if (category == null) {
            throw new NullPointerException("Cannot remove a null category.");
        }
        this.categories.remove(category);
    }

    @Override
    public boolean containsCategory(String category) {
        if (category == null) {
            return false;
        }
        return this.categories.contains(category);
    }

    @Override
    public boolean hasCategories() {
        return !this.categories.isEmpty();
    }

    @Override
    public void clearCategories() {
        this.categories.clear();
    }

    @Override
    public String getTypeString() {
        return VCardType.CATEGORIES.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof CategoriesType) {
                return this == obj || ((CategoriesType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (!this.categories.isEmpty()) {
            for (int i = 0; i < this.categories.size(); ++i) {
                sb.append(this.categories.get(i));
                sb.append(",");
            }
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public CategoriesFeature clone() {
        CategoriesType cloned = new CategoriesType();
        if (!this.categories.isEmpty()) {
            for (String categorie : this.categories) {
                cloned.addCategory(categorie);
            }
        }
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

