/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.ClassFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;

public class ClassType
extends Type
implements ClassFeature {
    private String securityClass = null;

    public ClassType() {
        this((String)null);
    }

    public ClassType(String securityClass) {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setSecurityClass(securityClass);
    }

    @Override
    public String getSecurityClass() {
        return this.securityClass;
    }

    @Override
    public void setSecurityClass(String securityClass) {
        this.securityClass = securityClass;
    }

    @Override
    public void clearSecurityClass() {
        this.securityClass = null;
    }

    @Override
    public boolean hasSecurityClass() {
        return this.securityClass != null;
    }

    @Override
    public String getTypeString() {
        return VCardType.CLASS.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof ClassType) {
                return this == obj || ((ClassType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (this.securityClass != null) {
            sb.append(this.securityClass);
            sb.append(",");
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public ClassFeature clone() {
        ClassType cloned = new ClassType();
        if (this.securityClass != null) {
            cloned.setSecurityClass(this.securityClass);
        }
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

