/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.EmailFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.parameters.EmailParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;
import info.ineighborhood.cardme.vcard.types.parameters.XEmailParameterType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class EmailType
extends Type
implements EmailFeature {
    private String email = null;
    private List<EmailParameterType> emailParameterTypes = new ArrayList<EmailParameterType>();
    private List<XEmailParameterType> xtendedEmailParameterTypes = new ArrayList<XEmailParameterType>();

    public EmailType() {
        this((String)null);
    }

    public EmailType(String email) {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setEmail(email);
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public Iterator<EmailParameterType> getEmailParameterTypes() {
        return this.emailParameterTypes.listIterator();
    }

    @Override
    public List<EmailParameterType> getEmailParameterTypesList() {
        return Collections.unmodifiableList(this.emailParameterTypes);
    }

    @Override
    public int getEmailParameterSize() {
        return this.emailParameterTypes.size();
    }

    @Override
    public void addEmailParameterType(EmailParameterType emailParameterType) {
        this.emailParameterTypes.add(emailParameterType);
    }

    @Override
    public void removeEmailParameterType(EmailParameterType emailParameterType) {
        this.emailParameterTypes.remove((Object)emailParameterType);
    }

    @Override
    public boolean containsEmailParameterType(EmailParameterType emailParameterType) {
        return this.emailParameterTypes.contains((Object)emailParameterType);
    }

    @Override
    public boolean hasEmailParameterTypes() {
        return !this.emailParameterTypes.isEmpty();
    }

    @Override
    public void clearEmailParameterTypes() {
        this.emailParameterTypes.clear();
    }

    @Override
    public Iterator<XEmailParameterType> getExtendedEmailParameterTypes() {
        return this.xtendedEmailParameterTypes.listIterator();
    }

    @Override
    public List<XEmailParameterType> getExtendedEmailParameterTypesList() {
        return Collections.unmodifiableList(this.xtendedEmailParameterTypes);
    }

    @Override
    public int getExtendedEmailParameterSize() {
        return this.xtendedEmailParameterTypes.size();
    }

    @Override
    public void addExtendedEmailParameterType(XEmailParameterType xtendedEmailParameterType) {
        this.xtendedEmailParameterTypes.add(xtendedEmailParameterType);
    }

    @Override
    public void removeExtendedEmailParameterType(XEmailParameterType xtendedEmailParameterType) {
        this.xtendedEmailParameterTypes.remove(xtendedEmailParameterType);
    }

    @Override
    public boolean containsExtendedEmailParameterType(XEmailParameterType xtendedEmailParameterType) {
        return this.xtendedEmailParameterTypes.contains(xtendedEmailParameterType);
    }

    @Override
    public boolean hasExtendedEmailParameterTypes() {
        return !this.xtendedEmailParameterTypes.isEmpty();
    }

    @Override
    public void clearExtendedEmailParameterTypes() {
        this.xtendedEmailParameterTypes.clear();
    }

    @Override
    public boolean hasEmail() {
        return this.email != null;
    }

    @Override
    public String getTypeString() {
        return VCardType.EMAIL.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof EmailType) {
                return this == obj || ((EmailType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (this.email != null) {
            sb.append(this.email);
            sb.append(",");
        }
        if (!this.emailParameterTypes.isEmpty()) {
            for (i = 0; i < this.emailParameterTypes.size(); ++i) {
                sb.append(this.emailParameterTypes.get(i).getType());
                sb.append(",");
            }
        }
        if (!this.xtendedEmailParameterTypes.isEmpty()) {
            for (i = 0; i < this.xtendedEmailParameterTypes.size(); ++i) {
                sb.append(this.xtendedEmailParameterTypes.get(i).getType());
                sb.append(",");
            }
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public EmailFeature clone() {
        EmailType cloned = new EmailType();
        if (this.email != null) {
            cloned.setEmail(this.email);
        }
        if (!this.emailParameterTypes.isEmpty()) {
            for (EmailParameterType emailParameterType : this.emailParameterTypes) {
                cloned.addEmailParameterType(emailParameterType);
            }
        }
        if (!this.xtendedEmailParameterTypes.isEmpty()) {
            for (XEmailParameterType xtendedEmailParameterType : this.xtendedEmailParameterTypes) {
                cloned.addExtendedEmailParameterType(xtendedEmailParameterType);
            }
        }
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

