/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.ExtendedFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;

public class ExtendedType
extends Type
implements ExtendedFeature {
    private String extensionName = null;
    private String extensionData = null;

    public ExtendedType() {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
    }

    public ExtendedType(String extensionName, String extensionData) {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setExtensionName(extensionName);
        this.setExtensionData(extensionData);
    }

    @Override
    public String getExtensionName() {
        return this.extensionName;
    }

    @Override
    public void setExtensionName(String extension) {
        if (!extension.toUpperCase().startsWith("X-")) {
            throw new IllegalArgumentException("Extensions must start with X-");
        }
        this.extensionName = extension;
    }

    @Override
    public String getExtensionData() {
        return this.extensionData;
    }

    @Override
    public void setExtensionData(String extensionData) {
        this.extensionData = extensionData;
    }

    @Override
    public void clearExtension() {
        this.extensionName = null;
    }

    @Override
    public boolean hasExtension() {
        return this.extensionName != null;
    }

    @Override
    public String getTypeString() {
        return VCardType.XTENDED.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof ExtendedType) {
                return this == obj || ((ExtendedType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (this.extensionName != null) {
            sb.append(this.extensionName);
            sb.append(",");
        }
        if (this.extensionData != null) {
            sb.append(this.extensionData);
            sb.append(",");
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public ExtendedFeature clone() {
        ExtendedType cloned = new ExtendedType();
        if (this.extensionName != null) {
            cloned.setExtensionName(this.extensionName);
        }
        if (this.extensionData != null) {
            cloned.setExtensionData(this.extensionData);
        }
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

