/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.GeographicPositionFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;

public class GeographicPositionType
extends Type
implements GeographicPositionFeature {
    public static final String regexValidator = "\\-?\\d{1,3}\\.\\d{1,6}";
    private double lon = 0.0;
    private double lat = 0.0;

    public GeographicPositionType() {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
    }

    public GeographicPositionType(double longitude, double latitude) {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setLongitude(longitude);
        this.setLatitude(latitude);
    }

    public GeographicPositionType(String longitude, String latitude) {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setLongitude(longitude);
        this.setLatitude(latitude);
    }

    @Override
    public double getLatitude() {
        return this.lat;
    }

    @Override
    public double getLongitude() {
        return this.lon;
    }

    @Override
    public void setLatitude(double latitude) {
        this.lat = latitude;
    }

    @Override
    public void setLatitude(String latitude) throws IllegalArgumentException {
        if (!latitude.matches(regexValidator)) {
            throw new IllegalArgumentException("Latitude is invalid, must have at least 1 digit and precise to a minimum of 1 or maximum of 6 decimal places.");
        }
        this.setLatitude(Float.parseFloat(latitude));
    }

    @Override
    public void setLatitude(double degrees, double minutes, double seconds) {
        this.setLatitude(degrees + minutes / 60.0 + seconds / 3600.0);
    }

    @Override
    public void setLongitude(double longitude) {
        this.lon = longitude;
    }

    @Override
    public void setLongitude(String longitude) {
        if (!longitude.matches(regexValidator)) {
            throw new IllegalArgumentException("Longitude is invalid, must have at least 1 digit and precise to a minimum of 1 or maximum of 6 decimal places.");
        }
        this.setLongitude(Float.parseFloat(longitude));
    }

    @Override
    public void setLongitude(double degrees, double minutes, double seconds) {
        this.setLongitude(degrees + minutes / 60.0 + seconds / 3600.0);
    }

    @Override
    public String getTypeString() {
        return VCardType.GEO.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof GeographicPositionType) {
                return this == obj || ((GeographicPositionType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        sb.append(this.lon);
        sb.append(",");
        sb.append(this.lat);
        sb.append(",");
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public GeographicPositionFeature clone() {
        GeographicPositionType cloned = new GeographicPositionType();
        cloned.setLongitude(this.lon);
        cloned.setLatitude(this.lat);
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

