/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.StringUtil;
import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.KeyFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.media.KeyTextType;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;
import java.util.Arrays;

public class KeyType
extends Type
implements KeyFeature {
    private byte[] keyBytes = null;
    private KeyTextType keyTextType = null;
    private boolean isSetCompression = false;

    public KeyType() {
        super(EncodingType.BINARY, ParameterTypeStyle.PARAMETER_VALUE_LIST);
    }

    public KeyType(byte[] keyBytes, EncodingType encodingType, KeyTextType keyTextType) {
        super(encodingType, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setKey(keyBytes);
        this.setKeyTextType(keyTextType);
    }

    @Override
    public byte[] getKey() {
        return this.keyBytes;
    }

    @Override
    public KeyTextType getKeyTextType() {
        return this.keyTextType;
    }

    @Override
    public void setKeyTextType(KeyTextType keyTextType) {
        this.keyTextType = keyTextType;
    }

    @Override
    public void setKey(byte[] keyBytes) {
        this.keyBytes = keyBytes;
    }

    @Override
    public boolean hasKeyTextType() {
        return this.keyTextType != null;
    }

    @Override
    public void clearKey() {
        this.keyBytes = null;
        this.keyTextType = null;
        this.encodingType = null;
    }

    @Override
    public boolean hasKey() {
        return this.keyBytes != null;
    }

    @Override
    public void setCompression(boolean compression) {
        this.isSetCompression = compression;
    }

    @Override
    public boolean isSetCompression() {
        return this.isSetCompression;
    }

    @Override
    public boolean isInline() {
        return true;
    }

    @Override
    public String getTypeString() {
        return VCardType.KEY.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof KeyType) {
                return this == obj || ((KeyType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (this.keyTextType != null) {
            sb.append(this.keyTextType.getTypeName());
            sb.append(",");
        }
        if (this.keyBytes != null) {
            sb.append(StringUtil.toHexString(this.keyBytes));
            sb.append(",");
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public KeyFeature clone() {
        KeyType cloned = new KeyType();
        if (this.keyBytes != null) {
            byte[] clonedBytes = Arrays.copyOf(this.keyBytes, this.keyBytes.length);
            cloned.setKey(clonedBytes);
        }
        if (this.keyTextType != null) {
            cloned.setKeyTextType(this.keyTextType);
        }
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return this.clone();
    }
}

