/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.LabelFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.parameters.LabelParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;
import info.ineighborhood.cardme.vcard.types.parameters.XLabelParameterType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class LabelType
extends Type
implements LabelFeature {
    private String label = null;
    private List<LabelParameterType> labelParameterTypes = new ArrayList<LabelParameterType>();
    private List<XLabelParameterType> xtendedLabelParameterTypes = new ArrayList<XLabelParameterType>();

    public LabelType() {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public Iterator<LabelParameterType> getLabelParameterTypes() {
        return this.labelParameterTypes.listIterator();
    }

    @Override
    public List<LabelParameterType> getLabelParameterTypesList() {
        return Collections.unmodifiableList(this.labelParameterTypes);
    }

    @Override
    public int getLabelParameterSize() {
        return this.labelParameterTypes.size();
    }

    @Override
    public void addLabelParameterType(LabelParameterType labelParameterType) {
        this.labelParameterTypes.add(labelParameterType);
    }

    @Override
    public void removeLabelParameterType(LabelParameterType labelParameterType) {
        this.labelParameterTypes.remove((Object)labelParameterType);
    }

    @Override
    public boolean containsLabelParameterType(LabelParameterType labelParameterType) {
        return this.labelParameterTypes.contains((Object)labelParameterType);
    }

    @Override
    public boolean hasLabelParameterTypes() {
        return !this.labelParameterTypes.isEmpty();
    }

    @Override
    public void clearLabelParameterTypes() {
        this.labelParameterTypes.clear();
    }

    @Override
    public Iterator<XLabelParameterType> getExtendedLabelParameterTypes() {
        return this.xtendedLabelParameterTypes.listIterator();
    }

    @Override
    public List<XLabelParameterType> getExtendedLabelParameterTypesList() {
        return Collections.unmodifiableList(this.xtendedLabelParameterTypes);
    }

    @Override
    public int getExtendedLabelParameterSize() {
        return this.xtendedLabelParameterTypes.size();
    }

    @Override
    public void addExtendedLabelParameterType(XLabelParameterType xtendedLabelParameterType) {
        this.xtendedLabelParameterTypes.add(xtendedLabelParameterType);
    }

    @Override
    public void removeExtendedLabelParameterType(XLabelParameterType xtendedLabelParameterType) {
        this.xtendedLabelParameterTypes.remove(xtendedLabelParameterType);
    }

    @Override
    public boolean containsExtendedLabelParameterType(XLabelParameterType xtendedLabelParameterType) {
        return this.xtendedLabelParameterTypes.contains(xtendedLabelParameterType);
    }

    @Override
    public boolean hasExtendedLabelParameterTypes() {
        return !this.xtendedLabelParameterTypes.isEmpty();
    }

    @Override
    public void clearExtendedLabelParameterTypes() {
        this.xtendedLabelParameterTypes.clear();
    }

    @Override
    public boolean hasLabel() {
        return this.label != null;
    }

    @Override
    public String getTypeString() {
        return VCardType.LABEL.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof LabelType) {
                return this == obj || ((LabelType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (this.label != null) {
            sb.append(this.label);
            sb.append(",");
        }
        if (!this.labelParameterTypes.isEmpty()) {
            for (i = 0; i < this.labelParameterTypes.size(); ++i) {
                sb.append(this.labelParameterTypes.get(i).getType());
                sb.append(",");
            }
        }
        if (!this.xtendedLabelParameterTypes.isEmpty()) {
            for (i = 0; i < this.xtendedLabelParameterTypes.size(); ++i) {
                sb.append(this.xtendedLabelParameterTypes.get(i).getType());
                sb.append(",");
            }
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public LabelFeature clone() {
        LabelType cloned = new LabelType();
        if (this.label != null) {
            cloned.setLabel(this.label);
        }
        if (!this.labelParameterTypes.isEmpty()) {
            for (LabelParameterType labelParameterType : this.labelParameterTypes) {
                cloned.addLabelParameterType(labelParameterType);
            }
        }
        if (!this.xtendedLabelParameterTypes.isEmpty()) {
            for (XLabelParameterType xtendedLabelParameterType : this.xtendedLabelParameterTypes) {
                cloned.addExtendedLabelParameterType(xtendedLabelParameterType);
            }
        }
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

