/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.StringUtil;
import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.LogoFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.media.ImageMediaType;
import info.ineighborhood.cardme.vcard.types.parameters.LogoParameterType;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;

public class LogoType
extends Type
implements LogoFeature {
    private byte[] logoBytes = null;
    private URI logoUri = null;
    private LogoParameterType logoParameterType = null;
    private ImageMediaType imageMediaType = null;
    private boolean isSetCompression = false;

    public LogoType() {
        super(EncodingType.BINARY, ParameterTypeStyle.PARAMETER_VALUE_LIST);
    }

    public LogoType(URI logoUri, EncodingType encodingType, LogoParameterType logoParameterType) {
        super(encodingType, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setLogoURI(logoUri);
        this.setLogoParameterType(logoParameterType);
    }

    public LogoType(byte[] logoBytes, EncodingType encodingType, LogoParameterType logoParameterType) {
        super(encodingType, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setLogo(logoBytes);
        this.setLogoParameterType(logoParameterType);
    }

    @Override
    public byte[] getLogo() {
        return this.logoBytes;
    }

    @Override
    public URI getLogoURI() {
        return this.logoUri;
    }

    @Override
    public boolean hasLogo() {
        return this.logoBytes != null || this.logoUri != null;
    }

    @Override
    public boolean isURI() {
        return this.logoUri != null;
    }

    @Override
    public boolean isInline() {
        return this.logoBytes != null;
    }

    @Override
    public LogoParameterType getLogoParameterType() {
        return this.logoParameterType;
    }

    @Override
    public ImageMediaType getImageMediaType() {
        return this.imageMediaType;
    }

    @Override
    public void setLogoParameterType(LogoParameterType logoParameterType) {
        this.logoParameterType = logoParameterType;
    }

    @Override
    public void setImageMediaType(ImageMediaType imageMediaType) {
        this.imageMediaType = imageMediaType;
    }

    @Override
    public void setLogo(byte[] logoBytes) {
        this.logoBytes = logoBytes;
    }

    @Override
    public void setLogoURI(URI logoUri) {
        this.logoUri = logoUri;
    }

    @Override
    public boolean hasLogoParameterType() {
        return this.logoParameterType != null;
    }

    @Override
    public boolean hasImageMediaType() {
        return this.imageMediaType != null;
    }

    @Override
    public void setCompression(boolean compression) {
        this.isSetCompression = compression;
    }

    @Override
    public boolean isSetCompression() {
        return this.isSetCompression;
    }

    @Override
    public String getTypeString() {
        return VCardType.LOGO.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof LogoType) {
                return this == obj || ((LogoType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (this.logoBytes != null) {
            sb.append(StringUtil.toHexString(this.logoBytes));
            sb.append(",");
        }
        if (this.logoUri != null) {
            sb.append(this.logoUri.getPath());
            sb.append(",");
        }
        if (this.logoParameterType != null) {
            sb.append(this.logoParameterType.getTypeName());
            sb.append(",");
        }
        if (this.imageMediaType != null) {
            sb.append(this.imageMediaType.getTypeName());
            sb.append(",");
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public LogoFeature clone() {
        LogoType cloned = new LogoType();
        if (this.logoBytes != null) {
            byte[] clonedBytes = Arrays.copyOf(this.logoBytes, this.logoBytes.length);
            cloned.setLogo(clonedBytes);
        }
        if (this.logoUri != null) {
            try {
                cloned.setLogoURI(new URI(this.logoUri.getPath()));
            }
            catch (URISyntaxException e) {
                cloned.setLogoURI(null);
            }
        }
        if (this.logoParameterType != null) {
            cloned.setLogoParameterType(this.logoParameterType);
        }
        if (this.imageMediaType != null) {
            cloned.setImageMediaType(this.imageMediaType);
        }
        cloned.setCompression(this.isSetCompression);
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

