/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.MailerFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;

public class MailerType
extends Type
implements MailerFeature {
    private String mailer = null;

    public MailerType() {
        this((String)null);
    }

    public MailerType(String mailer) {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setMailer(mailer);
    }

    @Override
    public String getMailer() {
        return this.mailer;
    }

    @Override
    public void setMailer(String mailer) {
        this.mailer = mailer;
    }

    @Override
    public void clearMailer() {
        this.mailer = null;
    }

    @Override
    public boolean hasMailer() {
        return this.mailer != null;
    }

    @Override
    public String getTypeString() {
        return VCardType.MAILER.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof MailerType) {
                return this == obj || ((MailerType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (this.mailer != null) {
            sb.append(this.mailer);
            sb.append(",");
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public MailerFeature clone() {
        MailerType cloned = new MailerType();
        if (this.mailer != null) {
            cloned.setMailer(this.mailer);
        }
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

