/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.NameFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NameType
extends Type
implements NameFeature {
    private String familyName = null;
    private String givenName = null;
    private List<String> additionalNames = null;
    private List<String> honorificPrefixes = null;
    private List<String> honorificSuffixes = null;

    public NameType() {
        this((String)null, (String)null);
    }

    public NameType(String familyName) {
        this(familyName, null);
    }

    public NameType(String familyName, String givenName) {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setFamilyName(familyName);
        this.setGivenName(givenName);
        this.additionalNames = new ArrayList<String>();
        this.honorificPrefixes = new ArrayList<String>();
        this.honorificSuffixes = new ArrayList<String>();
    }

    @Override
    public String getFamilyName() {
        return this.familyName;
    }

    @Override
    public String getGivenName() {
        return this.givenName;
    }

    @Override
    public Iterator<String> getAdditionalNames() {
        return this.additionalNames.listIterator();
    }

    @Override
    public Iterator<String> getHonorificPrefixes() {
        return this.honorificPrefixes.listIterator();
    }

    @Override
    public Iterator<String> getHonorificSuffixes() {
        return this.honorificSuffixes.listIterator();
    }

    @Override
    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    @Override
    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    @Override
    public void addAdditionalName(String additionalName) {
        this.additionalNames.add(additionalName);
    }

    @Override
    public void addHonorificPrefix(String honorificPrefix) {
        this.honorificPrefixes.add(honorificPrefix);
    }

    @Override
    public void addHonorificSuffix(String honorificSuffix) {
        this.honorificSuffixes.add(honorificSuffix);
    }

    @Override
    public void removeAdditionalName(String additionalName) {
        this.additionalNames.remove(additionalName);
    }

    @Override
    public void removeHonorificPrefix(String honorificPrefix) {
        this.honorificPrefixes.remove(honorificPrefix);
    }

    @Override
    public void removeHonorificSuffix(String honorificSuffix) {
        this.honorificSuffixes.remove(honorificSuffix);
    }

    @Override
    public boolean containsAdditionalName(String additionalName) {
        return this.additionalNames.contains(additionalName);
    }

    @Override
    public boolean containsHonorificPrefix(String honorificPrefix) {
        return this.honorificPrefixes.contains(honorificPrefix);
    }

    @Override
    public boolean containsHonorificSuffix(String honorificSuffix) {
        return this.honorificSuffixes.contains(honorificSuffix);
    }

    @Override
    public boolean hasFamilyName() {
        return this.familyName != null;
    }

    @Override
    public boolean hasGivenName() {
        return this.givenName != null;
    }

    @Override
    public boolean hasAdditionalNames() {
        return !this.additionalNames.isEmpty();
    }

    @Override
    public boolean hasHonorificPrefixes() {
        return !this.honorificPrefixes.isEmpty();
    }

    @Override
    public boolean hasHonorificSuffixes() {
        return !this.honorificSuffixes.isEmpty();
    }

    @Override
    public void clearAdditionalNames() {
        this.additionalNames.clear();
    }

    @Override
    public void clearHonorificPrefixes() {
        this.honorificPrefixes.clear();
    }

    @Override
    public void clearHonorificSuffixes() {
        this.honorificSuffixes.clear();
    }

    @Override
    public String getTypeString() {
        return VCardType.N.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof NameType) {
                return this == obj || ((NameType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (!this.honorificPrefixes.isEmpty()) {
            for (i = 0; i < this.honorificPrefixes.size(); ++i) {
                sb.append(this.honorificPrefixes.get(i));
                sb.append(",");
            }
        }
        if (this.familyName != null) {
            sb.append(this.familyName);
            sb.append(",");
        }
        if (this.givenName != null) {
            sb.append(this.givenName);
            sb.append(",");
        }
        if (!this.additionalNames.isEmpty()) {
            for (i = 0; i < this.additionalNames.size(); ++i) {
                sb.append(this.additionalNames.get(i));
                sb.append(",");
            }
        }
        if (!this.honorificSuffixes.isEmpty()) {
            for (i = 0; i < this.honorificSuffixes.size(); ++i) {
                sb.append(this.honorificSuffixes.get(i));
                sb.append(",");
            }
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public NameFeature clone() {
        NameType cloned = new NameType();
        if (this.familyName != null) {
            cloned.setFamilyName(this.familyName);
        }
        if (this.givenName != null) {
            cloned.setGivenName(this.givenName);
        }
        if (!this.additionalNames.isEmpty()) {
            for (String additionalName : this.additionalNames) {
                cloned.addAdditionalName(additionalName);
            }
        }
        if (!this.honorificPrefixes.isEmpty()) {
            for (String honorificPrefixe : this.honorificPrefixes) {
                cloned.addHonorificPrefix(honorificPrefixe);
            }
        }
        if (!this.honorificSuffixes.isEmpty()) {
            for (String honorificSuffixe : this.honorificSuffixes) {
                cloned.addHonorificSuffix(honorificSuffixe);
            }
        }
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

