/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.NicknameFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class NicknameType
extends Type
implements NicknameFeature {
    private List<String> nicknames = new ArrayList<String>();

    public NicknameType() {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
    }

    @Override
    public Iterator<String> getNicknames() {
        return this.nicknames.listIterator();
    }

    @Override
    public void addNickname(String nickname) throws NullPointerException {
        if (nickname == null) {
            throw new NullPointerException("Cannot add a null nickname.");
        }
        this.nicknames.add(nickname);
    }

    @Override
    public void removeNickname(String nickname) throws NullPointerException {
        if (nickname == null) {
            throw new NullPointerException("Cannot remove a null nickname.");
        }
        this.nicknames.remove(nickname);
    }

    @Override
    public void addAllNicknames(Collection<String> nicknames) throws NullPointerException {
        if (nicknames == null) {
            throw new NullPointerException("Cannot add a null collection of nicknames.");
        }
        this.nicknames.addAll(nicknames);
    }

    @Override
    public boolean containsNickname(String nickname) {
        if (nickname == null) {
            return false;
        }
        return this.nicknames.contains(nickname);
    }

    @Override
    public boolean hasNicknames() {
        return !this.nicknames.isEmpty();
    }

    @Override
    public void clearNicknames() {
        this.nicknames.clear();
    }

    public boolean hasNickname() {
        return !this.nicknames.isEmpty();
    }

    @Override
    public String getTypeString() {
        return VCardType.NICKNAME.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof NicknameType) {
                return this == obj || ((NicknameType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (!this.nicknames.isEmpty()) {
            for (int i = 0; i < this.nicknames.size(); ++i) {
                sb.append(this.nicknames.get(i));
                sb.append(",");
            }
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public NicknameFeature clone() {
        NicknameType cloned = new NicknameType();
        if (!this.nicknames.isEmpty()) {
            for (String nickname : this.nicknames) {
                cloned.addNickname(nickname);
            }
        }
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

