/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.NoteFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;

public class NoteType
extends Type
implements NoteFeature {
    private String note = null;

    public NoteType() {
        this((String)null);
    }

    public NoteType(String note) {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setNote(note);
    }

    @Override
    public String getNote() {
        return this.note;
    }

    @Override
    public void setNote(String note) {
        this.note = note;
    }

    @Override
    public boolean hasNote() {
        return this.note != null;
    }

    @Override
    public String getTypeString() {
        return VCardType.NOTE.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof NoteType) {
                return this == obj || ((NoteType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (this.note != null) {
            sb.append(this.note);
            sb.append(",");
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public NoteFeature clone() {
        NoteType cloned = new NoteType();
        if (this.note != null) {
            cloned.setNote(this.note);
        }
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

