/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.OrganizationFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OrganizationType
extends Type
implements OrganizationFeature {
    private List<String> organizations = new ArrayList<String>();

    public OrganizationType() {
        super(EncodingType.EIGHT_BIT, ParameterTypeStyle.PARAMETER_VALUE_LIST);
    }

    @Override
    public void addOrganization(String category) {
        this.organizations.add(category);
    }

    @Override
    public Iterator<String> getOrganizations() {
        return this.organizations.listIterator();
    }

    @Override
    public void removeOrganization(String category) {
        this.organizations.remove(category);
    }

    @Override
    public boolean containsOrganization(String category) {
        return this.organizations.contains(category);
    }

    @Override
    public boolean hasOrganizations() {
        return !this.organizations.isEmpty();
    }

    @Override
    public void clearOrganizations() {
        this.organizations.clear();
    }

    @Override
    public String getTypeString() {
        return VCardType.ORG.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof OrganizationType) {
                return this == obj || ((OrganizationType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (!this.organizations.isEmpty()) {
            for (int i = 0; i < this.organizations.size(); ++i) {
                sb.append(this.organizations.get(i));
                sb.append(",");
            }
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public OrganizationFeature clone() {
        OrganizationType cloned = new OrganizationType();
        if (!this.organizations.isEmpty()) {
            for (String organization : this.organizations) {
                cloned.addOrganization(organization);
            }
        }
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

