/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.StringUtil;
import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.PhotoFeature;
import info.ineighborhood.cardme.vcard.types.Type;
import info.ineighborhood.cardme.vcard.types.media.ImageMediaType;
import info.ineighborhood.cardme.vcard.types.parameters.ParameterTypeStyle;
import info.ineighborhood.cardme.vcard.types.parameters.PhotoParameterType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;

public class PhotoType
extends Type
implements PhotoFeature {
    private byte[] photoBytes = null;
    private URI photoUri = null;
    private PhotoParameterType photoParameterType = null;
    private ImageMediaType imageMediaType = null;
    private boolean isSetCompression = false;

    public PhotoType() {
    }

    public PhotoType(URI photoUri, EncodingType encodingType, PhotoParameterType photoParameterType) {
        super(encodingType, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setPhotoURI(photoUri);
        this.setPhotoParameterType(photoParameterType);
    }

    public PhotoType(byte[] photoBytes, EncodingType encodingType, PhotoParameterType photoParameterType) {
        super(encodingType, ParameterTypeStyle.PARAMETER_VALUE_LIST);
        this.setPhoto(photoBytes);
        this.setPhotoParameterType(photoParameterType);
    }

    @Override
    public byte[] getPhoto() {
        return this.photoBytes;
    }

    @Override
    public URI getPhotoURI() {
        return this.photoUri;
    }

    @Override
    public boolean hasPhoto() {
        return this.photoBytes != null || this.photoUri != null;
    }

    @Override
    public boolean isURI() {
        return this.photoUri != null;
    }

    @Override
    public boolean isInline() {
        return this.photoBytes != null;
    }

    @Override
    public PhotoParameterType getPhotoParameterType() {
        return this.photoParameterType;
    }

    @Override
    public ImageMediaType getImageMediaType() {
        return this.imageMediaType;
    }

    @Override
    public void setPhotoParameterType(PhotoParameterType photoParameterType) {
        this.photoParameterType = photoParameterType;
    }

    @Override
    public void setImageMediaType(ImageMediaType imageMediaType) {
        this.imageMediaType = imageMediaType;
    }

    @Override
    public void setPhoto(byte[] photoBytes) {
        this.photoBytes = photoBytes;
    }

    @Override
    public void setPhotoURI(URI photoUri) {
        this.photoUri = photoUri;
    }

    @Override
    public boolean hasPhotoParameterType() {
        return this.photoParameterType != null;
    }

    @Override
    public boolean hasImageMediaType() {
        return this.imageMediaType != null;
    }

    @Override
    public void setCompression(boolean compression) {
        this.isSetCompression = compression;
    }

    @Override
    public boolean isSetCompression() {
        return this.isSetCompression;
    }

    @Override
    public String getTypeString() {
        return VCardType.PHOTO.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof PhotoType) {
                return this == obj || ((PhotoType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (this.photoBytes != null) {
            sb.append(StringUtil.toHexString(this.photoBytes));
            sb.append(",");
        }
        if (this.photoUri != null) {
            sb.append(this.photoUri.getPath());
            sb.append(",");
        }
        if (this.photoParameterType != null) {
            sb.append(this.photoParameterType.getTypeName());
            sb.append(",");
        }
        if (this.imageMediaType != null) {
            sb.append(this.imageMediaType.getTypeName());
            sb.append(",");
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public PhotoFeature clone() {
        PhotoType cloned = new PhotoType();
        if (this.photoBytes != null) {
            byte[] clonedBytes = Arrays.copyOf(this.photoBytes, this.photoBytes.length);
            cloned.setPhoto(clonedBytes);
        }
        if (this.photoUri != null) {
            try {
                cloned.setPhotoURI(new URI(this.photoUri.getPath()));
            }
            catch (URISyntaxException e) {
                cloned.setPhotoURI(null);
            }
        }
        if (this.photoParameterType != null) {
            cloned.setPhotoParameterType(this.photoParameterType);
        }
        if (this.imageMediaType != null) {
            cloned.setImageMediaType(this.imageMediaType);
        }
        cloned.setCompression(this.isSetCompression);
        cloned.setParameterTypeStyle(this.getParameterTypeStyle());
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

