/*
 * Decompiled with CFR 0.152.
 */
package info.ineighborhood.cardme.vcard.types;

import info.ineighborhood.cardme.util.Util;
import info.ineighborhood.cardme.vcard.EncodingType;
import info.ineighborhood.cardme.vcard.VCardType;
import info.ineighborhood.cardme.vcard.features.ProfileFeature;
import info.ineighborhood.cardme.vcard.types.Type;

public class ProfileType
extends Type
implements ProfileFeature {
    private String profile = null;

    public ProfileType() {
        super(EncodingType.EIGHT_BIT);
    }

    public ProfileType(String profile) {
        super(EncodingType.EIGHT_BIT);
        this.setProfile(profile);
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public void setProfile(String profile) {
        if (profile.compareToIgnoreCase("VCARD") != 0) {
            throw new IllegalArgumentException("profile must be \"VCard\"");
        }
        this.profile = profile;
    }

    @Override
    public String getTypeString() {
        return VCardType.PROFILE.getType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof ProfileType) {
                return this == obj || ((ProfileType)obj).hashCode() == this.hashCode();
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.generateHashCode(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[ ");
        if (this.encodingType != null) {
            sb.append(this.encodingType.getType());
            sb.append(",");
        }
        if (this.profile != null) {
            sb.append(this.profile);
            sb.append(",");
        }
        if (this.id != null) {
            sb.append(this.id);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public ProfileFeature clone() {
        ProfileType cloned = new ProfileType();
        if (this.profile != null) {
            cloned.setProfile(this.profile);
        }
        cloned.setEncodingType(this.getEncodingType());
        cloned.setID(this.getID());
        return cloned;
    }
}

